/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Log;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.dao.LogMapper;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.LogManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.persistence.manager.impl.FlowInstanceManagerImpl;
import com.hotent.todo.util.TodoUtil;
import com.hotent.uc.api.model.IUser;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogManagerImpl
extends BaseManagerImpl<LogMapper, Log>
implements LogManager {
    private static final Logger logger = LoggerFactory.getLogger(FlowInstanceManagerImpl.class);
    @Resource
    FlowInstanceManager flowInstanceManager;
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    TaskManager taskManager;

    @Override
    public CommonResult<String> handErrorLog(String type) {
        int successSize = 0;
        try {
            switch (type) {
                case "taskDoneByArriveDate": {
                    successSize = this.handTaskDoneByArriveDate();
                    break;
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(true, "\u5904\u7406\u5931\u8d25");
        }
        return new CommonResult(true, String.format("\u5df2\u5904\u7406\u6210\u529f\uff1a%s\u6761", successSize));
    }

    private int handTaskDoneByArriveDate() {
        List<Log> errorLogs = ((LogMapper)this.baseMapper).getErroeByTaskDoneByArriveDate();
        if (BeanUtils.isNotEmpty(errorLogs)) {
            ArrayList updateLogs = new ArrayList();
            errorLogs.forEach(log -> {
                try {
                    ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)log.getMessageBody());
                    if (jsonNode.has("taskDoneDate") && (BeanUtils.isNotEmpty((Object)jsonNode.get("taskDoneDate")) || " ".equals(jsonNode.get("taskDoneDate").asText()))) {
                        jsonNode.put("taskDoneDate", TimeUtil.getDateTimeString((LocalDateTime)log.getCreateTime()));
                        TaskDone entity = (TaskDone)((Object)((Object)JsonUtil.toBean((JsonNode)jsonNode, TaskDone.class)));
                        if (StringUtil.isNotEmpty((String)entity.getInstanceId())) {
                            FlowInstance flowInstance = this.isFlowInstanceExist(entity.getSystemCode(), entity.getInstanceId());
                            entity.setTitle(flowInstance.getTitle());
                        }
                        entity.setSystemName(log.getFromSystemName());
                        IUser approve = TodoUtil.getUser(entity.getTaskApproveAccount(), entity.getTaskApproveName());
                        entity.setTaskApproveNum(approve.getAccount());
                        entity.setTaskApproveAccount(approve.getAccount());
                        entity.setTaskApproveName(approve.getFullname());
                        List<Task> taskList = this.taskManager.getByTaskId(entity.getSystemCode(), entity.getTaskId());
                        Assert.isTrue((boolean)taskList.isEmpty(), (String)String.format("systemCode\u4e3a%s\uff0ctaskId\u4e3a%s\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", entity.getSystemCode(), entity.getTaskId()));
                        entity.setFrom(log.getFromSystemCode());
                        for (int i = 0; i < taskList.size(); ++i) {
                            Task task = taskList.get(i);
                            if (task.getTaskApproveAccount().equals(entity.getTaskApproveAccount())) {
                                this.taskDoneManager.taskToDone(entity, task);
                                log.setResult(String.format("%s-%s", log.getResult(), "handled"));
                                updateLogs.add(log);
                                continue;
                            }
                            this.taskManager.remove((Serializable)((Object)task.getId()));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("\u6d88\u606f\u4f53\u4e3a\uff1a%s\u7684\u65e5\u5fd7\u5904\u7406\u5931\u8d25\uff1a%s", log.getMessageBody(), e.getMessage()));
                }
            });
            if (BeanUtils.isNotEmpty(updateLogs)) {
                this.updateBatchById(updateLogs);
                return updateLogs.size();
            }
        }
        return 0;
    }

    protected FlowInstance isFlowInstanceExist(String systemCode, String instanceId) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)systemCode), (String)"systemCode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)instanceId), (String)"instanceId\u4e0d\u80fd\u4e3a\u7a7a");
        FlowInstance flowInstance = this.flowInstanceManager.getBySystemCodeAndInstanceId(systemCode, instanceId);
        if (flowInstance == null) {
            throw new MessageShouldRetryException(String.format("systemCode\u4e3a: %s\uff0cinstanceId\u4e3a\uff1a%s\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728", systemCode, instanceId));
        }
        return flowInstance;
    }

    @Override
    public CommonResult<String> migratingData() {
        try {
            ((LogMapper)this.baseMapper).createHi();
            ((LogMapper)this.baseMapper).removeBeforeMarch();
            return new CommonResult("\u65e5\u5fd7\u8f6c\u50a8\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult("\u65e5\u5fd7\u8f6c\u50a8\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

