/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.todo.model.SystemManage;
import com.hotent.todo.persistence.dao.SystemManageMapper;
import com.hotent.todo.persistence.manager.SystemManageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SystemManageManagerImpl
extends BaseManagerImpl<SystemManageMapper, SystemManage>
implements SystemManageManager {
    @Override
    public CommonResult<String> saveUserBatch(String sysCode, List<SystemManage> systemManages) {
        if (BeanUtils.isNotEmpty(systemManages)) {
            ArrayList<String> userIdList = new ArrayList<String>();
            for (SystemManage systemManage : systemManages) {
                userIdList.add(systemManage.getUserId());
            }
            QueryFilter query = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            query.addFilter("SYS_CODE_", (Object)sysCode, QueryOP.EQUAL);
            query.addFilter("USER_ID_", userIdList, QueryOP.IN);
            PageList page = this.query(query);
            HashSet ids = new HashSet();
            if (BeanUtils.isNotEmpty((Object)page.getRows())) {
                page.getRows().forEach(row -> ids.add(row.getUserId()));
            }
            ArrayList<SystemManage> userList = new ArrayList<SystemManage>();
            for (SystemManage systemManage : systemManages) {
                if (ids.contains(systemManage.getUserId())) continue;
                systemManage.setId(UniqueIdUtil.getSuid());
                systemManage.setSysCode(sysCode);
                userList.add(systemManage);
            }
            if (userList.size() > 0) {
                this.saveBatch(userList);
            }
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @Override
    public List<SystemManage> getByUserId(String userId) {
        return ((SystemManageMapper)this.baseMapper).getByUserId(userId);
    }
}

