/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.dao.CommonDao;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.model.WarningSetting;
import com.hotent.todo.persistence.dao.TaskDoneMapper;
import com.hotent.todo.persistence.manager.IWarningSettingService;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.service.WebSocketMessageService;
import com.hotent.todo.util.CacheRedisUtil;
import com.hotent.todo.util.TodoUtil;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDoneManagerImpl
extends BaseManagerImpl<TaskDoneMapper, TaskDone>
implements TaskDoneManager {
    @Resource
    TaskManager taskManager;
    @Resource
    IWarningSettingService warningSettingService;
    @Resource
    CommonDao commonDao;
    @Resource
    CacheRedisUtil cacheRedisUtil;
    @Resource
    WebSocketMessageService webSocketMessageService;
    private static final int defaultOverSecond = 172800;
    private static final String defaultQueryType = "week";
    private static final String QUERY_TYPE_WEEK = "week";
    private static final String QUERY_TYPE_MONTH = "month";
    private static final String QUERY_TYPE_YEAR = "year";
    private static final String QUERY_TYPE_RANGE = "range";
    private static final String ORG_RANGE_ALL = "all";
    private static final String QUERY_TYPE_GROUP = "group";

    @Override
    public void removeByInstanceId(LocalDateTime updateTime, String systemCode, String instanceId) {
        ((TaskDoneMapper)this.baseMapper).removeByInstanceId(updateTime, systemCode, instanceId);
    }

    @Override
    @Transactional
    public void taskToDone(TaskDone taskDone, Task task) {
        BeanUtils.copyProperties((Object)((Object)task), (Object)((Object)taskDone), (String[])new String[]{"createTime", "createBy", "updateBy", "updateTime", "createOrgId", "id", "mobileTaskUrl", "pcTaskUrl", "taskApproveAccount", "taskApproveName", "taskArriveDate", "taskDoneDate", "taskId", "todoType"});
        taskDone.setTaskCostSecond(Duration.between(task.getTaskArriveDate(), taskDone.getTaskDoneDate()).getSeconds());
        taskDone.setTaskApproveNum(taskDone.getTaskApproveAccount());
        this.taskManager.remove((Serializable)((Object)task.getId()));
        String state = task.getState();
        taskDone.setState(state);
        super.create((Model)taskDone);
        this.webSocketMessageService.sendToWebSocketMessage("done", StringUtil.isNotEmpty((String)task.getTaskApproveNum()) ? task.getTaskApproveNum() : task.getTaskApproveId());
    }

    @Override
    public PageList<TaskDone> queryPage(QueryFilter<TaskDone> queryFilter, String account) {
        return new PageList(((TaskDoneMapper)this.baseMapper).queryPage((IPage<TaskDone>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskDone>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account));
    }

    @Override
    public PageList<TaskDone> queryMobilePage(QueryFilter<TaskDone> queryFilter) {
        IPage taskDoneIPage = this.convert2IPage(queryFilter.getPageBean());
        Wrapper taskDoneWrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<TaskDone> resultPage = ((TaskDoneMapper)this.baseMapper).queryMobilePage((IPage<TaskDone>)taskDoneIPage, (Wrapper<TaskDone>)taskDoneWrapper);
        return new PageList(resultPage);
    }

    @Override
    public void ignoreLow(String ids, boolean ignore, String modifReason) {
        List<String> idList = Arrays.asList(ids.split(","));
        ((TaskDoneMapper)this.baseMapper).ignoreLowTag(idList, ignore ? "1" : "0");
        TodoUtil.addOperatIgnoreLowLog("ignoreLow", "taskDone", ids, ignore, modifReason);
    }

    @Override
    public PageList<Map<String, Object>> queryOvertimePage(QueryFilter<TaskDone> queryFilter) {
        PageList pageList;
        String startTime = null;
        String endTime = null;
        int overSecond = 172800;
        WarningSetting setting = (WarningSetting)this.warningSettingService.get((Serializable)((Object)"1"));
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)((Object)setting))) {
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)setting.getDuration())) {
                overSecond = setting.getDuration() * 60 * 60;
            }
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)setting.getStartTime())) {
                startTime = TimeUtil.getDateTimeString((LocalDateTime)setting.getStartTime());
            }
        }
        List<String> ignorIds = this.getIgnorUsers();
        com.hotent.base.util.BeanUtils.removeDuplicate(ignorIds);
        ArrayList<String> orgRangeUserIds = new ArrayList<String>();
        String queryType = "week";
        String sortSql = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            Iterable users;
            Map params = queryFilter.getParams();
            if (params.containsKey("queryType")) {
                queryType = params.get("queryType").toString();
                if (QUERY_TYPE_RANGE.equals(queryType)) {
                    startTime = params.get("startTime").toString();
                    endTime = params.get("endTime").toString();
                } else {
                    startTime = this.getStartTime(queryType);
                }
            }
            if (params.containsKey("orgRange") && QUERY_TYPE_GROUP.equals(params.get("orgRange")) && StringUtil.isNotEmpty((String)setting.getGroupOrgId()) && com.hotent.base.util.BeanUtils.isNotEmpty(users = null)) {
                users.forEach(u -> orgRangeUserIds.add(((String)u.get("id")).toString()));
            }
            if (params.containsKey("sortField") && com.hotent.base.util.BeanUtils.isNotEmpty(params.get("sortField")) && params.containsKey("sortOrder") && com.hotent.base.util.BeanUtils.isNotEmpty(params.get("sortOrder"))) {
                sortSql = String.format(" %s %s ", params.get("sortField").toString(), params.get("sortOrder").toString());
            }
        }
        String orgRangeUserSql = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgRangeUserIds)) {
            orgRangeUserSql = TodoUtil.getInSql(orgRangeUserIds, 999, "TASK_APPROVE_ID_", "IN");
        }
        String ignorUserSql = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty(ignorIds)) {
            ignorUserSql = TodoUtil.getInSql(ignorIds, 999, "TASK_APPROVE_ID_", "NOT IN");
        }
        ArrayList<String> invalidUserIds = null;
        Set<String> invalidUserIdSet = this.getInvalidUserIds();
        if (invalidUserIdSet.size() > 0) {
            invalidUserIds = new ArrayList<String>(invalidUserIdSet);
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)(pageList = new PageList(((TaskDoneMapper)this.baseMapper).getOvertimeReportPage((IPage<TaskDone>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskDone>)this.convert2Wrapper(queryFilter, this.currentModelClass()), overSecond, startTime, endTime, orgRangeUserSql, ignorUserSql, sortSql, invalidUserIds)))) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            List rows = pageList.getRows();
            ArrayList userIdList = new ArrayList();
            rows.forEach(row -> userIdList.add(row.get("userId").toString()));
            Iterable users = null;
            if (com.hotent.base.util.BeanUtils.isNotEmpty(users)) {
                HashedMap userPostMap = new HashedMap();
                users.forEach(arg_0 -> TaskDoneManagerImpl.lambda$queryOvertimePage$2((Map)userPostMap, arg_0));
                rows.forEach(arg_0 -> TaskDoneManagerImpl.lambda$queryOvertimePage$3((Map)userPostMap, arg_0));
                pageList.setRows(rows);
            }
        }
        return pageList;
    }

    private List<String> getIgnorUsers() {
        ArrayList<String> ignorIds = new ArrayList<String>();
        String ignorSql = "select OWNER_ID_ as 'id',PERMISSION_TYPE_ as 'type' from todo_permission where OBJ_TYPE_='task-overtime' and AUTHORIZE_ID_='1' and PERMISSION_TYPE_ in('user','post') ORDER BY PERMISSION_TYPE_";
        HashMap<String, String> dicMap = new HashMap<String, String>();
        dicMap.put("sql", ignorSql);
        List list = this.commonDao.query(dicMap);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)list)) {
            Iterable users;
            ArrayList postCodes = new ArrayList();
            list.forEach(map -> {
                if (com.hotent.base.util.BeanUtils.isNotEmpty(map.get("id")) && com.hotent.base.util.BeanUtils.isNotEmpty(map.get("type"))) {
                    if ("user".equals(map.get("type"))) {
                        ignorIds.add(map.get("id").toString());
                    } else {
                        postCodes.add(map.get("id").toString());
                    }
                }
            });
            if (com.hotent.base.util.BeanUtils.isNotEmpty(postCodes) && com.hotent.base.util.BeanUtils.isNotEmpty(users = null)) {
                users.forEach(u -> ignorIds.add(((String)u.get("id")).toString()));
            }
        }
        return ignorIds;
    }

    private String getStartTime(String queryType) {
        String startTime = "";
        LocalDate nowDate = LocalDate.now();
        switch (queryType) {
            case "month": {
                LocalDate firstMonthDay = nowDate.with(TemporalAdjusters.firstDayOfMonth());
                startTime = TimeUtil.getDateString((LocalDateTime)LocalDateTime.from(firstMonthDay)) + " 00:00:00";
                break;
            }
            case "year": {
                LocalDate firstYearDay = nowDate.with(TemporalAdjusters.firstDayOfYear());
                startTime = TimeUtil.getDateString((LocalDateTime)LocalDateTime.from(firstYearDay)) + " 00:00:00";
                break;
            }
            default: {
                LocalDate weekDate = nowDate.minusDays(7L);
                startTime = TimeUtil.getDateString((LocalDateTime)LocalDateTime.from(weekDate)) + " 00:00:00";
            }
        }
        return startTime;
    }

    @Override
    public PageList<TaskDone> queryLowPage(QueryFilter<TaskDone> queryFilter) {
        PageList pageList;
        String startTime = null;
        WarningSetting setting = (WarningSetting)this.warningSettingService.get((Serializable)((Object)"1"));
        Set<String> invalidUserIdSet = this.getInvalidUserIds();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)setting.getStartTime())) {
            startTime = TimeUtil.getDateTimeString((LocalDateTime)setting.getStartTime());
        }
        ArrayList<String> orgRangeUserIds = new ArrayList<String>();
        ArrayList<String> invalidUserIds = null;
        String invalidCondition = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            Iterable users;
            Map params = queryFilter.getParams();
            if (params.containsKey("orgRange") && QUERY_TYPE_GROUP.equals(params.get("orgRange")) && StringUtil.isNotEmpty((String)setting.getGroupOrgId()) && com.hotent.base.util.BeanUtils.isNotEmpty(users = null)) {
                users.forEach(u -> orgRangeUserIds.add(((String)u.get("id")).toString()));
            }
            if (params.containsKey("approveStatus") && !ORG_RANGE_ALL.equals(params.get("approveStatus")) && invalidUserIdSet.size() > 0) {
                invalidCondition = "enable".equals(params.get("approveStatus")) ? " not in " : " in ";
                invalidUserIds = new ArrayList<String>(invalidUserIdSet);
            }
        }
        String orgRangeUserSql = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgRangeUserIds)) {
            orgRangeUserSql = TodoUtil.getInSql(orgRangeUserIds, 999, "TASK_APPROVE_ID_", "IN");
        }
        List<String> ignorIds = this.getIgnorUsers();
        String ignorUserSql = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty(ignorIds)) {
            ignorUserSql = TodoUtil.getInSql(ignorIds, 999, "TASK_APPROVE_ID_", "NOT IN");
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)(pageList = new PageList(((TaskDoneMapper)this.baseMapper).queryLowPage((IPage<TaskDone>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskDone>)this.convert2Wrapper(queryFilter, this.currentModelClass()), startTime, orgRangeUserSql, ignorUserSql, invalidUserIds, invalidCondition)))) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            pageList.getRows().forEach(row -> {
                if (invalidUserIdSet.contains(row.getTaskApproveId())) {
                    row.setLeave(true);
                } else {
                    row.setLeave(false);
                }
            });
        }
        return pageList;
    }

    private Set<String> getInvalidUserIds() {
        HashSet<String> invalidUserIdSet = new HashSet<String>();
        return invalidUserIdSet;
    }

    @Override
    public int getUserTaskDoneCount(String instId, String userNumber) {
        Integer num = ((TaskDoneMapper)this.baseMapper).getUserTaskDoneCount(instId, userNumber);
        return com.hotent.base.util.BeanUtils.isNotEmpty((Object)num) ? num : 0;
    }

    @Override
    public List<Map<String, String>> queryUserTaskDoneList(String startTime, String endTime) {
        return ((TaskDoneMapper)this.baseMapper).queryUserTaskDoneList(startTime, endTime);
    }

    private static /* synthetic */ void lambda$queryOvertimePage$3(Map userPostMap, Map item) {
        String userId = item.get("userId").toString();
        if (userPostMap.containsKey(userId)) {
            Map userMap = (Map)userPostMap.get(userId);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(userMap.get("positionCode"))) {
                item.put("postCode", ((String)userMap.get("positionCode")).toString());
            }
            if (com.hotent.base.util.BeanUtils.isNotEmpty(userMap.get("positionName"))) {
                String postName = (String)userMap.get("positionName");
                postName = postName.replaceAll("\\\uff08.*\\\uff09", "");
                item.put("postName", postName);
            }
        }
    }

    private static /* synthetic */ void lambda$queryOvertimePage$2(Map userPostMap, Map u) {
        userPostMap.put(u.get("id"), u);
    }
}

