/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.dto.MobileProcessCountDto;
import com.hotent.base.feign.dto.MyApplyTaskDto;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.dao.TaskMapper;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.service.WebSocketMessageService;
import com.hotent.todo.util.CacheRedisUtil;
import com.hotent.todo.util.TodoUtil;
import com.hotent.todo.vo.DingTalkTaskVo;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskManagerImpl
extends BaseManagerImpl<TaskMapper, Task>
implements TaskManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    FlowInstanceManager flowInstanceManager;
    @Resource
    CacheRedisUtil cacheRedisUtil;
    @Resource
    CopyManager copyManager;
    @Resource
    WebSocketMessageService webSocketMessageService;

    @Override
    @Transactional
    public void removeTaskByIds(String systemCode, String instanceId, List<String> taskList) {
        this.sendDeleteMessage(systemCode, instanceId, taskList);
        ((TaskMapper)this.baseMapper).removeTaskByIds(systemCode, instanceId, taskList);
    }

    @Override
    @Transactional
    public void removeByInstanceId(LocalDateTime updateTime, String systemCode, String instanceId) {
        this.sendDeleteMessage(systemCode, instanceId, null);
        ((TaskMapper)this.baseMapper).removeByInstanceId(updateTime, systemCode, instanceId);
    }

    @Override
    public List<Task> getByTaskId(String systemCode, String taskId) {
        return ((TaskMapper)this.baseMapper).getByTaskId(systemCode, taskId);
    }

    @Override
    @Transactional
    public void task2Done(List<String> ids, boolean isCheck, String type) {
        ArrayList taskDoneList = new ArrayList();
        ids.forEach(id -> {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.ne(Task::getIsDele, (Object)"1")).eq(Task::getId, id);
            Task task = (Task)((Object)((Object)this.getOne((Wrapper)wrapper)));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)((Object)task))) {
                throw new BaseException("id\u4e3a" + id + "\u7684\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            TaskDone taskDone = new TaskDone();
            BeanUtils.copyProperties((Object)((Object)task), (Object)((Object)taskDone), (String[])new String[]{"createTime", "createBy", "updateBy", "updateTime", "createOrgId"});
            taskDone.setTaskDoneDate(LocalDateTime.now());
            taskDone.setTaskCostSecond(Duration.between(task.getTaskArriveDate(), taskDone.getTaskDoneDate()).getSeconds());
            if (isCheck) {
                taskDone.setRemark("taskCheck");
            } else if (StringUtil.isNotEmpty((String)type) && "self".equals(type)) {
                taskDone.setRemark("userSelf");
            }
            taskDoneList.add(taskDone);
            this.webSocketMessageService.sendToWebSocketMessage("done", StringUtil.isNotEmpty((String)task.getTaskApproveNum()) ? task.getTaskApproveNum() : task.getTaskApproveId());
        });
        this.taskDoneManager.saveBatch(taskDoneList);
        this.removeByIds(ids);
    }

    @Override
    @Transactional
    public void task2Done(Task task, boolean isCheck, String remark, LocalDateTime doneTime) {
        TaskDone taskDone = new TaskDone();
        BeanUtils.copyProperties((Object)((Object)task), (Object)((Object)taskDone), (String[])new String[]{"createTime", "createBy", "updateBy", "updateTime", "createOrgId"});
        taskDone.setTaskDoneDate(doneTime);
        taskDone.setTaskCostSecond(Duration.between(task.getTaskArriveDate(), taskDone.getTaskDoneDate()).getSeconds());
        taskDone.setRemark(remark);
        this.taskDoneManager.save((Object)taskDone);
        this.webSocketMessageService.sendToWebSocketMessage("done", StringUtil.isNotEmpty((String)task.getTaskApproveNum()) ? task.getTaskApproveNum() : task.getTaskApproveId());
        this.removeByIds(Collections.singletonList(task.getId()));
    }

    @Override
    public Integer queryMyTaskCount(QueryFilter<Task> queryFilter) {
        return ((TaskMapper)this.baseMapper).queryMyTaskCount((Wrapper<Task>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    private void sendDeleteMessage(String systemCode, String instanceId, List<String> taskList) {
        try {
            List<Task> tasks = null;
            tasks = taskList == null ? ((TaskMapper)this.baseMapper).getTaskByInstanceId(systemCode, instanceId) : ((TaskMapper)this.baseMapper).getTaskByIds(systemCode, instanceId, taskList);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(tasks)) {
                for (Task task : tasks) {
                    this.webSocketMessageService.sendToWebSocketMessage("delete", StringUtil.isNotEmpty((String)task.getTaskApproveNum()) ? task.getTaskApproveNum() : task.getTaskApproveId());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5f85\u529e\u65f6\u53d1\u9001websocket\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void ignoreLow(String ids, boolean ignore, String modifReason) {
        List<String> idList = Arrays.asList(ids.split(","));
        ((TaskMapper)this.baseMapper).ignoreLowTag(idList, ignore ? "1" : "0");
        ((TaskMapper)this.baseMapper).ignoreBakLowTag(idList, ignore ? "1" : "0");
        TodoUtil.addOperatIgnoreLowLog("ignoreLow", "task", ids, ignore, modifReason);
    }

    @Override
    public List<String> queryFlowCodesByFlowCode(String flowCode) {
        return ((TaskMapper)this.baseMapper).queryFlowCodesByFlowCode(flowCode);
    }

    @Override
    public PageList<Task> queryPageList(QueryFilter<Task> queryFilter, boolean initOa) {
        QueryWrapper taskWrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, this.currentModelClass());
        String taskApproveAccount = null;
        Map params = queryFilter.getParams();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)params)) {
            try {
                for (String key : params.keySet()) {
                    if (!"taskApproveAccount".equals(key)) continue;
                    taskApproveAccount = (String)params.get(key);
                    break;
                }
            }
            catch (Exception e) {
                logger.error(String.format("\u67e5\u8be2\u5f85\u529e\u5217\u8868\u89e3\u6790taskApproveId\u5931\u8d25\uff1a%s", e.getMessage()));
            }
        }
        PageList pageList = new PageList(((TaskMapper)this.baseMapper).queryAllPage((IPage<Task>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Task>)taskWrapper, taskApproveAccount));
        return pageList;
    }

    @Override
    public void handTask(DingTalkTaskVo vo) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(FlowInstance::getInstanceId, (Object)vo.getProcessInstanceId());
        lambdaQueryWrapper.eq(FlowInstance::getSystemCode, (Object)"dingtalk");
        FlowInstance flowInstance = (FlowInstance)((Object)this.flowInstanceManager.getOne((Wrapper)lambdaQueryWrapper));
        String taskId = vo.getTaskId();
        if (flowInstance == null) {
            throw new MessageShouldRetryException(String.format("systemCode\u4e3a%s\uff0cinstanceId\u4e3a%s\u7684\u5b9e\u4f8b\u4e0d\u5b58\u5728", flowInstance.getSystemCode(), flowInstance.getInstanceId()));
        }
        if (!"start".equals(vo.getType())) {
            List<Task> dingtalk = this.getByTaskId("dingtalk", taskId);
            if (dingtalk.isEmpty()) {
                throw new MessageShouldRetryException(String.format("systemCode\u4e3a%s\uff0ctaskId\u4e3a%s\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", "dingtalk", taskId));
            }
            TaskDone taskDone = new TaskDone();
            JsonNode node = this.cacheRedisUtil.getUserById(vo.getStaffId());
            if (node != null) {
                taskDone.setTaskApproveId(vo.getStaffId());
                taskDone.setTaskApproveName(node.get("fname").asText());
                taskDone.setTaskApproveAccount(node.get("fjobnumber").asText());
                taskDone.setTaskApproveNum(node.get("fjobnumber").asText());
            } else {
                taskDone.setTaskApproveId(vo.getStaffId());
            }
            taskDone.setTaskDoneDate(DateFormatUtil.parse((long)vo.getFinishTime()));
            taskDone.setTaskArriveDate(DateFormatUtil.parse((long)vo.getCreateTime()));
            taskDone.setTaskId(taskId);
            taskDone.setPcTaskUrl(flowInstance.getPcTaskUrl());
            taskDone.setMobileTaskUrl(flowInstance.getMobileTaskUrl());
            for (int i = 0; i < dingtalk.size(); ++i) {
                Task task = dingtalk.get(i);
                this.taskDoneManager.taskToDone(taskDone, task);
            }
        } else {
            Task task = new Task();
            task.setSystemCode("dingtalk");
            task.setSystemName("\u9489\u9489");
            task.setTitle(vo.getTitle());
            task.setInstanceId(vo.getProcessInstanceId());
            task.setTaskArriveDate(DateFormatUtil.parse((long)vo.getCreateTime()));
            task.setTaskStartId(flowInstance.getOwerId());
            task.setTaskStartAccount(flowInstance.getOwerAccount());
            task.setTaskStartName(flowInstance.getOwerName());
            task.setTaskStartNum(flowInstance.getOwerNum());
            JsonNode node = this.cacheRedisUtil.getUserById(vo.getStaffId());
            if (node != null) {
                task.setTaskApproveId(vo.getStaffId());
                task.setTaskApproveName(node.get("fname").asText());
                task.setTaskApproveAccount(node.get("fjobnumber").asText());
                task.setTaskApproveNum(node.get("fjobnumber").asText());
            } else {
                task.setTaskApproveId(vo.getStaffId());
            }
            task.setTaskId(taskId);
            task.setPcTaskUrl(flowInstance.getPcTaskUrl());
            task.setMobileTaskUrl(flowInstance.getMobileTaskUrl());
            super.save((Object)task);
        }
    }

    @Override
    public MobileProcessCountDto findCountByUser(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TASK_APPROVE_ACCOUNT_", (Object)account);
        Integer agencyCount = Optional.ofNullable(((TaskMapper)this.baseMapper).selectCount((Wrapper)queryWrapper)).orElse(0);
        int doneCount = this.taskDoneManager.count((Wrapper)queryWrapper);
        QueryWrapper copyQueryWrapper = new QueryWrapper();
        copyQueryWrapper.lambda().eq(Copy::getCallyReceiveAccount, (Object)account);
        int copyCount = this.copyManager.count((Wrapper)copyQueryWrapper);
        MobileProcessCountDto mobileProcessCountDto = new MobileProcessCountDto();
        mobileProcessCountDto.setAgencyCount(agencyCount);
        mobileProcessCountDto.setDoneCount(Integer.valueOf(doneCount));
        mobileProcessCountDto.setCopyCount(Integer.valueOf(copyCount));
        return mobileProcessCountDto;
    }

    @Override
    public PageList<MyApplyTaskDto> findPageMyTask(QueryFilter<Task> queryFilter, String account) {
        QueryWrapper taskWrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage taskIPage = this.convert2IPage(queryFilter.getPageBean());
        IPage<MyApplyTaskDto> myApplyTaskDtoIPage = ((TaskMapper)this.baseMapper).findPageMyTask((IPage<Task>)taskIPage, (Wrapper<Task>)taskWrapper, account);
        return new PageList(myApplyTaskDtoIPage);
    }
}

