/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.service.impl;

import com.hotent.base.util.time.TimeUtil;
import com.hotent.sdk.feign.service.EipTodoPushSdkService;
import com.hotent.todo.service.WebSocketMessageService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class WebSocketMessageServiceImp
implements WebSocketMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketMessageServiceImp.class);
    @Resource
    EipTodoPushSdkService eipTodoPushSdkService;

    @Override
    public void sendToWebSocketMessage(final String message, final String userId) {
        System.out.println(message);
        this.transactionSynchronizationExecute(new Runnable(){

            @Override
            public void run() {
                WebSocketMessageServiceImp.this.handlerWebSocketMessage(message, userId);
            }
        });
    }

    private void transactionSynchronizationExecute(Runnable runnable) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            runnable.run();
        } else {
            runnable.run();
        }
    }

    private void handlerWebSocketMessage(String message, String account) {
        logger.info(String.format("%s--webSocket\u6d88\u606f\u63a8\u9001:%s,%s", TimeUtil.getCurrentTime(), message, account));
        try {
            this.eipTodoPushSdkService.socketMessage(message, account);
        }
        catch (Exception e) {
            logger.error(String.format("webSocket[%s,%s]\u6d88\u606f\u63a8\u9001\u63a8\u9001\u5931\u8d25\uff1a%s", message, account, e.getMessage()));
        }
    }
}

