/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class CacheRedisUtil {
    @Cacheable(value={"eip:uc:dingtalkUser"}, key="#account", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public JsonNode getUser(String account) {
        return null;
    }

    @Cacheable(value={"eip:uc:dingtalkFUserId"}, key="#fUserId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public JsonNode getUserById(String fUserId) {
        UCFeignService bean = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        JsonNode dingtalkUserByAccount = bean.getDingtalkUserByFUserId(fUserId);
        return dingtalkUserByAccount;
    }

    @Cacheable(value={"eip:portal:msgTemplate"}, key="#templateKey")
    public JsonNode getMsgTemplateByKey(String templateKey) {
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        return portalFeignService.getMsgTemplateByKey(templateKey);
    }

    @Cacheable(value={"eip:portal:sysExternalUnite"}, key="dingtalk", pureKey=true)
    public JsonNode getDingtalk() {
        return null;
    }

    @Cacheable(value={"eip:uc:oaCookie"}, key="#key", firstCache=@FirstCache(expireTime=10, expireTimeExp="#expireTime"), secondaryCache=@SecondaryCache(expireTime=10, expireTimeExp="#expireTime", forceRefresh=true, timeUnit=TimeUnit.MINUTES))
    public String getCookie(String key) {
        return null;
    }

    @CachePut(value={"eip:uc:oaCookie"}, key="#key", firstCache=@FirstCache(expireTime=10, expireTimeExp="#time"), secondaryCache=@SecondaryCache(expireTime=10, expireTimeExp="#time", forceRefresh=true, timeUnit=TimeUnit.MINUTES))
    public String setCookie(String key, String value, Integer time) {
        return value;
    }
}

