/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.util.TodoUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/todo/flow-instance"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b"})
@ApiGroup(group={"group_todo"})
public class FlowInstanceController
extends BaseController<FlowInstanceManager, FlowInstance> {
    @PostMapping(value={"/queryList"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<FlowInstance> queryList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FlowInstance> queryFilter) throws Exception {
        List querys = queryFilter.getQuerys();
        ArrayList<QueryField> newQuerys = new ArrayList<QueryField>();
        boolean isDel = false;
        if (querys != null) {
            for (int i = 0; i < querys.size(); ++i) {
                QueryField queryField = (QueryField)querys.get(i);
                if (queryField.getProperty().equals("flowStatus")) {
                    if (Objects.equals("delete", queryField.getValue())) {
                        newQuerys.add(new QueryField("isDele", (Object)"1", QueryOP.EQUAL, FieldRelation.AND, "system"));
                        continue;
                    }
                    newQuerys.add(queryField);
                    isDel = true;
                    continue;
                }
                newQuerys.add(queryField);
            }
        }
        if (isDel) {
            newQuerys.add(new QueryField("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system"));
        }
        queryFilter.setQuerys(newQuerys);
        return ((FlowInstanceManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<FlowInstance> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FlowInstance> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        List<String> authSysCodes = TodoUtil.getAuthSystem();
        if (authSysCodes != null) {
            queryFilter.addFilter("SYSTEM_CODE_", authSysCodes, QueryOP.IN, FieldRelation.AND, "auth");
        }
        return ((FlowInstanceManager)this.baseService).queryPage(queryFilter, null);
    }

    @PostMapping(value={"/front/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<FlowInstance> queryFrontPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FlowInstance> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("owerAccount", (Object)currentUser.getAccount(), QueryOP.EQUAL, FieldRelation.AND, "system");
        return ((FlowInstanceManager)this.baseService).queryPage(queryFilter, currentUser.getAccount());
    }

    @PostMapping(value={"/mobile/myRequest"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<FlowInstance> myRequest(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FlowInstance> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("owerId", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND, "system");
        return ((FlowInstanceManager)this.baseService).queryPage(queryFilter, currentUser.getUserId());
    }

    @GetMapping(value={"/getHomeInstance"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u53d1\u8d77\u7684\u8bf7\u6c42", httpMethod="GET", notes="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u53d1\u8d77\u7684\u8bf7\u6c42")
    public List<FlowInstance> getHomeInstance() {
        LambdaQueryWrapper taskQueryWrapper = new LambdaQueryWrapper();
        String account = ContextUtil.getCurrentUser().getAccount();
        taskQueryWrapper.eq(FlowInstance::getOwerAccount, (Object)account);
        taskQueryWrapper.orderByDesc(FlowInstance::getFlowStartDate);
        taskQueryWrapper.last("limit 0,3");
        return ((FlowInstanceManager)this.baseService).list((Wrapper)taskQueryWrapper);
    }

    @RequestMapping(value={"/getDefaultTodoInfoMap"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u95e8\u6237\u7edf\u4e00\u5f85\u529e\u4fe1\u606f\u76d2\u5b50", httpMethod="GET", notes="\u9996\u9875\u95e8\u6237\u7edf\u4e00\u5f85\u529e\u680f\u76ee\u4fe1\u606f\u76d2\u5b50")
    public Map<String, Object> getDefaultTodoInfoMap() throws Exception {
        Map<String, Object> res = ((FlowInstanceManager)this.baseService).getDefaultTodoInfoMap();
        return res;
    }
}

