/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.Task;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.service.WebSocketMessageService;
import com.hotent.todo.util.TodoUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AddTaskMessageHandler
extends AbstractMessageHandler<Task>
implements MessageHandler {
    @Resource
    TaskManager taskManager;
    @Resource
    FlowInstanceManager flowInstanceManager;
    @Resource
    WebSocketMessageService webSocketMessageService;
    @Value(value="${msg.WhiteList:oa}")
    private String msgWhiteList;
    @Value(value="${dingTalk.corpId:ding86fe8ae26d0e3eee35c2f4657eb6378f}")
    private String dingTalkCorpId;

    @Override
    public String getType() {
        return TodoMessageType.ADD_TASK.key();
    }

    @Override
    public void doHandler(Task entity, AccessSystem accessSystem) {
        entity.setSystemName(accessSystem.getSystemName());
        entity.setTaskApproveNum(entity.getTaskApproveAccount());
        entity.setTaskStartNum(entity.getTaskStartAccount());
        entity.setFrom(accessSystem.getFrom());
        this.taskManager.create((Model)entity);
        this.webSocketMessageService.sendToWebSocketMessage("todo", StringUtil.isNotEmpty((String)entity.getTaskApproveId()) ? entity.getTaskApproveId() : entity.getTaskApproveNum());
        if (!TodoUtil.isInMsgWhiteList(this.msgWhiteList, accessSystem.getSystemCode())) {
            Map<String, String> map = this.flowInstanceManager.getVars(entity.getTitle(), entity.getTaskStartName(), entity.getInstanceId(), entity.getMobileTaskUrl());
        }
    }
}

