/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.persistence.manager.TaskManager;
import io.jsonwebtoken.lang.Assert;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DeleteTaskMessageHandler
extends AbstractMessageHandler<ObjectNode>
implements MessageHandler {
    @Resource
    TaskManager taskManager;

    @Override
    public String getType() {
        return TodoMessageType.DELETE_TASK.key();
    }

    @Override
    public void doHandler(ObjectNode entity, AccessSystem accessSystem) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)entity.get("systemCode")), (String)"systemCode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)entity.get("taskIdList")), (String)"taskIdList\u4e0d\u80fd\u4e3a\u7a7a");
        String taskIdList = entity.get("taskIdList").asText();
        List<String> taskIds = Arrays.asList(taskIdList.split(","));
        String instanceId = BeanUtils.isNotEmpty((Object)entity.get("instanceId")) ? entity.get("instanceId").asText() : null;
        this.taskManager.removeTaskByIds(entity.get("systemCode").asText(), instanceId, taskIds);
    }
}

