/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Task;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.util.TodoUtil;
import com.hotent.uc.api.model.IUser;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StartFlowMessageHandler
extends AbstractMessageHandler<FlowInstance>
implements MessageHandler {
    @Resource
    FlowInstanceManager flowInstanceManager;
    @Value(value="${dingTalk.corpId:ding86fe8ae26d0e3eee35c2f4657eb6378f}")
    private String dingTalkCorpId;

    @Override
    public String getType() {
        return TodoMessageType.START_FLOW.key();
    }

    @Override
    public void doHandler(FlowInstance entity, AccessSystem accessSystem) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entity.getSystemCode()), (String)"systemCode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entity.getInstanceId()), (String)"instanceId\u4e0d\u80fd\u4e3a\u7a7a");
        FlowInstance flowInstance = this.flowInstanceManager.getBySystemCodeAndInstanceId(entity.getSystemCode(), entity.getInstanceId());
        Assert.isTrue((boolean)BeanUtils.isEmpty((Object)((Object)flowInstance)), (String)String.format("systemCode\u4e3a%s\uff0cinstanceId\u4e3a%s\u7684\u5b9e\u4f8b\u5df2\u5b58\u5728", entity.getSystemCode(), entity.getInstanceId()));
        entity.setSystemName(accessSystem.getSystemName());
        entity.setOwerNum(entity.getOwerAccount());
        entity.setSerialNumber(entity.getInstanceId());
        ArrayList<IUser> users = new ArrayList<IUser>();
        this.handleTaskApprove(entity, users);
        entity.setFrom(accessSystem.getFrom());
        IUser startUser = TodoUtil.getUser(entity.getOwerAccount(), entity.getOwerName());
        this.flowInstanceManager.handleInstance(entity, users, startUser);
    }

    private void handleTaskApprove(FlowInstance flowInstance, List<IUser> users) {
        List<Task> taskList = flowInstance.getTaskList();
        if (BeanUtils.isNotEmpty(taskList) && taskList.size() > 0) {
            for (Task task : taskList) {
                task.setSystemCode(flowInstance.getSystemCode());
                task.setSystemName(flowInstance.getSystemName());
                task.setTaskStartId(flowInstance.getOwerId());
                task.setTaskStartNum(flowInstance.getOwerNum());
                task.setTaskStartAccount(flowInstance.getOwerAccount());
                task.setTaskStartName(flowInstance.getOwerName());
                IUser user = TodoUtil.getUser(task.getTaskApproveAccount(), task.getTaskApproveName());
                users.add(user);
            }
        }
    }
}

