/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.mq;

import com.hotent.base.jms.JmsProducer;
import com.hotent.todo.mq.MessageHandlerProcessor;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DelayKafkaMessageListener {
    protected static final Logger logger = LoggerFactory.getLogger(DelayKafkaMessageListener.class);
    @Resource
    JmsProducer jmsProducer;
    @Value(value="${spring.rocketmq.delay-seconds:10}")
    Integer delay;

    private TopicAndRetryKey structureRetryKey(String key) {
        Matcher regexMatcher = MessageHandlerProcessor.RETRY_REGEX.matcher(key);
        if (regexMatcher.find()) {
            String timeStr = regexMatcher.group(1);
            String topicName = regexMatcher.group(2);
            int retryTime = Integer.parseInt(timeStr);
            String retryKey = String.format("retry-%s-%s", retryTime, topicName);
            return new TopicAndRetryKey(topicName, retryKey);
        }
        return null;
    }

    class TopicAndRetryKey {
        private String topic;
        private String retryKey;

        public TopicAndRetryKey(String topic, String retryKey) {
            this.topic = topic;
            this.retryKey = retryKey;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getRetryKey() {
            return this.retryKey;
        }
    }
}

