/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.mq;

import com.hotent.base.jms.JmsProducer;
import com.hotent.todo.mq.MessageHandlerProcessor;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DingTalkMessageListener {
    protected static final Logger logger = LoggerFactory.getLogger(DingTalkMessageListener.class);
    @Resource
    JmsProducer jmsProducer;
    @Value(value="${spring.rocketmq.delay-seconds:10}")
    Integer delay;

    public void Listener() throws MQClientException {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer("rocketmqDingTalkRetryGroup");
        consumer.subscribe("ding-talk-todo-topic", "*");
        consumer.registerMessageListener(new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                for (MessageExt message : msgs) {
                    long timestamp = message.getBornTimestamp();
                    int judgeMS = DingTalkMessageListener.this.delay * 1000;
                    while (System.currentTimeMillis() < timestamp + (long)judgeMS) {
                        try {
                            long max = Math.max(0L, timestamp + (long)judgeMS - System.currentTimeMillis());
                            logger.info("\u65f6\u95f4\u95f4\u9694\u4e3a:" + max);
                            Thread.sleep(max);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    String str = new String(message.getBody());
                    Optional<String> kafkaMessage = Optional.ofNullable(str);
                    if (!kafkaMessage.isPresent()) continue;
                    String data = kafkaMessage.get();
                    Optional<String> keyVal = Optional.ofNullable(message.getProperty("topicKey"));
                    if (!keyVal.isPresent()) {
                        logger.error("\u5ef6\u65f6\u6d88\u606f\u961f\u5217\u4e2d\u7684\u6d88\u606fkey\u4e3a\u7a7a\uff0c\u5ef6\u65f6\u5230\u671f\u540e\u65e0\u6cd5\u901a\u8fc7key\u51b3\u5b9a\u6d88\u606f\u7684\u6295\u9012topic\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)data);
                        continue;
                    }
                    String key = keyVal.get();
                    TopicAndRetryKey topicAndRetryKey = DingTalkMessageListener.this.structureRetryKey(key);
                    if (topicAndRetryKey == null) {
                        logger.error("\u5ef6\u65f6\u6d88\u606f\u961f\u5217\u4e2d\u7684\u6d88\u606fkey\u4e0d\u7b26\u5408retry-{retryTime}-{topicName}\u7684\u683c\u5f0f\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)data);
                        continue;
                    }
                    try {
                        DingTalkMessageListener.this.jmsProducer.sendToTopic(topicAndRetryKey.getRetryKey(), (Object)data, topicAndRetryKey.getTopic());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        consumer.start();
    }

    private TopicAndRetryKey structureRetryKey(String key) {
        Matcher regexMatcher = MessageHandlerProcessor.RETRY_REGEX.matcher(key);
        if (regexMatcher.find()) {
            String timeStr = regexMatcher.group(1);
            String topicName = regexMatcher.group(2);
            int retryTime = Integer.parseInt(timeStr);
            String retryKey = String.format("retry-%s-%s", retryTime, topicName);
            return new TopicAndRetryKey(topicName, retryKey);
        }
        return null;
    }

    class TopicAndRetryKey {
        private String topic;
        private String retryKey;

        public TopicAndRetryKey(String topic, String retryKey) {
            this.topic = topic;
            this.retryKey = retryKey;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getRetryKey() {
            return this.retryKey;
        }
    }
}

