/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.vo.AccountOrIdVo;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.model.CommonFlow;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.MsgCenterLog;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.msg.persistence.manager.IMsgCenterLogService;
import com.hotent.todo.persistence.dao.FlowInstanceMapper;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.service.WebSocketMessageService;
import com.hotent.todo.util.CacheRedisUtil;
import com.hotent.todo.util.TodoUtil;
import com.hotent.todo.vo.DingTalkInstanceVo;
import com.hotent.todo.vo.TodoInfoboxVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlowInstanceManagerImpl
extends BaseManagerImpl<FlowInstanceMapper, FlowInstance>
implements FlowInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(FlowInstanceManagerImpl.class);
    @Resource
    TaskManager taskManager;
    @Resource
    CopyManager copyManager;
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    IMsgCenterLogService msgCenterLogService;
    @Resource
    CacheRedisUtil cacheRedisUtil;
    @Resource
    WebSocketMessageService webSocketMessageService;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public FlowInstance getBySystemCodeAndInstanceId(String systemCode, String instanceId) {
        return ((FlowInstanceMapper)this.baseMapper).getBySystemCodeAndInstanceId(systemCode, instanceId);
    }

    public void update(FlowInstance flowInstance) {
        FlowInstance dbFlowInstance = (FlowInstance)((Object)((FlowInstanceMapper)this.baseMapper).selectById((Serializable)((Object)flowInstance.getId())));
        if (BeanUtils.isNotEmpty((Object)((Object)dbFlowInstance))) {
            flowInstance.setFlowType(dbFlowInstance.getFlowType());
        }
        super.update((Model)flowInstance);
    }

    @Override
    @Transactional
    public void handleInstance(FlowInstance flowInstance, List<IUser> users, IUser startUser) {
        String status = flowInstance.getFlowStatus();
        String title = flowInstance.getTitle();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(CommonFlow::getFlowCode, (Object)flowInstance.getFlowType());
        CommonFlow commonFlow = null;
        if (BeanUtils.isNotEmpty(commonFlow)) {
            flowInstance.setTypeId(commonFlow.getTypeCode());
            flowInstance.setTypeName(commonFlow.getTypeName());
        }
        String id = flowInstance.getId();
        switch (status) {
            case "draft": 
            case "approving": {
                if (BeanUtils.isEmpty((Object)flowInstance.getId())) {
                    flowInstance.setId(UniqueIdUtil.getSuid());
                    super.create((Model)flowInstance);
                } else {
                    super.update((Model)flowInstance);
                }
                if (!BeanUtils.isNotEmpty(flowInstance.getTaskList())) break;
                this.handleTask(flowInstance, title, users);
                break;
            }
            case "revoke": 
            case "refuse": 
            case "backToStart": 
            case "back": {
                super.update((Model)flowInstance);
                if (!BeanUtils.isNotEmpty(flowInstance.getTaskList())) break;
                this.handleTask(flowInstance, title, users);
                break;
            }
            case "complete": {
                if (BeanUtils.isNotEmpty(flowInstance.getTaskList())) {
                    this.handleTask(flowInstance, title, users);
                }
                if (BeanUtils.isEmpty((Object)flowInstance.getFlowCostSecond())) {
                    flowInstance.setFlowCostSecond(Duration.between(flowInstance.getFlowStartDate(), LocalDateTime.now()).getSeconds());
                }
                super.update((Model)flowInstance);
                break;
            }
            case "cancel": {
                if (BeanUtils.isEmpty((Object)flowInstance.getFlowCostSecond())) {
                    flowInstance.setFlowCostSecond(Duration.between(flowInstance.getFlowStartDate(), LocalDateTime.now()).getSeconds());
                }
                super.update((Model)flowInstance);
                break;
            }
            case "delete": {
                LocalDateTime updateTime = LocalDateTime.now();
                this.taskManager.removeByInstanceId(updateTime, flowInstance.getSystemCode(), flowInstance.getInstanceId());
                this.taskDoneManager.removeByInstanceId(updateTime, flowInstance.getSystemCode(), flowInstance.getInstanceId());
                this.copyManager.removeByInstanceId(updateTime, flowInstance.getSystemCode(), flowInstance.getInstanceId());
                ((FlowInstanceMapper)this.baseMapper).removeByInstanceId(updateTime, flowInstance.getSystemCode(), flowInstance.getInstanceId());
            }
        }
    }

    @Override
    public PageList<FlowInstance> queryPage(QueryFilter<FlowInstance> filter, String owerNum) {
        return new PageList(((FlowInstanceMapper)this.baseMapper).queryPage((IPage<FlowInstance>)this.convert2IPage(filter.getPageBean()), (Wrapper<FlowInstance>)this.convert2Wrapper(filter, this.currentModelClass()), owerNum));
    }

    @Override
    public Map<String, String> getVars(String title, String startName, String instanceId, String url) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("subject", title);
        vars.put("creator", startName);
        vars.put("url", TodoUtil.addBackParam(url));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(FlowInstance::getInstanceId, (Object)instanceId);
        FlowInstance flowInstance = (FlowInstance)((Object)this.getOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)flowInstance))) {
            vars.put("createTime", DateFormatUtil.formaDateTime((LocalDateTime)flowInstance.getCreateTime()));
        } else {
            vars.put("createTime", DateUtil.getCurrentTime());
        }
        return vars;
    }

    private void handleTask(FlowInstance flowInstance, String title, List<IUser> users) {
        List<Task> taskList = flowInstance.getTaskList();
        for (Task task : taskList) {
            task.setId(UniqueIdUtil.getSuid());
            task.setSystemCode(flowInstance.getSystemCode());
            task.setSystemName(flowInstance.getSystemName());
            task.setInstanceId(flowInstance.getInstanceId());
            task.setTitle(title);
            task.setOrgFullName(flowInstance.getOrgFullName());
            task.setOrgName(flowInstance.getOrgName());
            task.setBusinessTypeId(flowInstance.getFlowType());
            task.setBusinessType(flowInstance.getFlowTypeName());
            task.setFrom(flowInstance.getFrom());
            task.setState(flowInstance.getState());
            this.webSocketMessageService.sendToWebSocketMessage("todo", StringUtil.isNotEmpty((String)task.getTaskApproveNum()) ? task.getTaskApproveNum() : task.getTaskApproveId());
        }
        this.taskManager.saveBatch(taskList);
    }

    private void createLog(String type, String destination, String content, String state, String error, String taskId) {
        MsgCenterLog msgCenterLog = new MsgCenterLog();
        msgCenterLog.setType(type);
        msgCenterLog.setDestination(destination);
        msgCenterLog.setContent(content);
        msgCenterLog.setSendTime(LocalDateTime.now());
        msgCenterLog.setState(state);
        msgCenterLog.setError(error);
        msgCenterLog.setMsgId(taskId);
        this.msgCenterLogService.create((Model)msgCenterLog);
    }

    @Override
    public List<FlowInstance> queryOaInstanceIds(String startTime, String endTime) {
        return ((FlowInstanceMapper)this.baseMapper).queryOaInstanceIds(startTime, endTime);
    }

    @Override
    public void saveInstance(DingTalkInstanceVo vo) {
        FlowInstance flowInstance = new FlowInstance();
        flowInstance.setInstanceId(vo.getProcessInstanceId());
        flowInstance.setSystemCode("dingtalk");
        flowInstance.setSystemName("\u9489\u9489");
        flowInstance.setTitle(vo.getTitle());
        flowInstance.setFlowStartDate(DateFormatUtil.parse((long)vo.getCreateTime()));
        flowInstance.setMobileTaskUrl(vo.getUrl());
        flowInstance.setPcTaskUrl(vo.getUrl());
        flowInstance.setSerialNumber(vo.getBusinessId());
        JsonNode node = this.cacheRedisUtil.getUserById(vo.getStaffId());
        if (vo.getType().equals("start")) {
            System.out.println("\u53d1\u8d77\u6d41\u7a0b\u4e8b\u4ef6==============");
            if (node != null) {
                flowInstance.setOwerId(vo.getStaffId());
                flowInstance.setOwerName(node.get("fname").asText());
                flowInstance.setOwerAccount(node.get("fjobnumber").asText());
                flowInstance.setOwerNum(node.get("fjobnumber").asText());
            } else {
                flowInstance.setOwerId(vo.getStaffId());
            }
            flowInstance.setFlowStatus("approving");
            super.save((Object)flowInstance);
        } else {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(FlowInstance::getInstanceId, (Object)vo.getProcessInstanceId());
            lambdaQueryWrapper.eq(FlowInstance::getSystemCode, (Object)"dingtalk");
            FlowInstance flowInstance1 = (FlowInstance)((Object)((FlowInstanceMapper)this.baseMapper).selectOne((Wrapper)lambdaQueryWrapper));
            if (flowInstance1 != null) {
                flowInstance1.setFlowStatus("complete");
                flowInstance1.setFlowCostSecond((vo.getFinishTime() - vo.getCreateTime()) / 1000L);
                flowInstance1.setResult(vo.getResult());
                super.update((Model)flowInstance1);
            } else {
                throw new MessageShouldRetryException(String.format("systemCode\u4e3a%s\uff0cinstanceId\u4e3a%s\u7684\u5b9e\u4f8b\u4e0d\u5b58\u5728", flowInstance.getSystemCode(), flowInstance.getInstanceId()));
            }
        }
    }

    @Override
    public Map<String, String> findSerialNumber(Set<String> ids) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ids != null && ids.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(FlowInstance::getInstanceId, ids);
            List flowInstances = ((FlowInstanceMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (flowInstances != null && flowInstances.size() > 0) {
                for (FlowInstance flowInstance : flowInstances) {
                    String instanceId = flowInstance.getInstanceId();
                    String serialNumber = flowInstance.getSerialNumber();
                    resultMap.put(instanceId, serialNumber);
                }
            }
        }
        return resultMap;
    }

    @Override
    public PageList<FlowInstance> queryMobilePage(QueryFilter<FlowInstance> queryFilter) {
        return new PageList(((FlowInstanceMapper)this.baseMapper).queryMobilePage((IPage<FlowInstance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FlowInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    @Transactional
    public void physicsRemove(String flowKey, String sysCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(FlowInstance::getFlowType, (Object)flowKey);
        lambdaQueryWrapper.eq(FlowInstance::getSystemCode, (Object)sysCode);
        List flowInstances = ((FlowInstanceMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
        if (!flowInstances.isEmpty()) {
            List ids = flowInstances.stream().map(FlowInstance::getInstanceId).collect(Collectors.toList());
            LambdaQueryWrapper taskLambdaQueryWrapper = new LambdaQueryWrapper();
            taskLambdaQueryWrapper.in(Task::getInstanceId, ids);
            taskLambdaQueryWrapper.eq(Task::getSystemCode, (Object)sysCode);
            this.taskManager.remove((Wrapper)taskLambdaQueryWrapper);
            LambdaQueryWrapper taskDoneLambdaQueryWrapper = new LambdaQueryWrapper();
            taskDoneLambdaQueryWrapper.in(TaskDone::getInstanceId, ids);
            taskDoneLambdaQueryWrapper.eq(TaskDone::getSystemCode, (Object)sysCode);
            this.taskDoneManager.remove((Wrapper)taskDoneLambdaQueryWrapper);
            LambdaQueryWrapper copyLambdaQueryWrapper = new LambdaQueryWrapper();
            copyLambdaQueryWrapper.in(Copy::getInstanceId, ids);
            copyLambdaQueryWrapper.eq(Copy::getSystemCode, (Object)sysCode);
            this.copyManager.remove((Wrapper)copyLambdaQueryWrapper);
            this.removeByIds(flowInstances.stream().map(FlowInstance::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public Map<String, Object> getDefaultTodoInfoMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map<String, Integer> defaultTodoInfoMap = ((FlowInstanceMapper)this.baseMapper).getDefaultTodoInfoMap(ContextUtil.getCurrentUser().getAccount());
            TodoInfoboxVo myTaksBox = this.getMyTodoTaksBox();
            myTaksBox.setDataText(defaultTodoInfoMap.get("taskCount") + "");
            TodoInfoboxVo myAlreadyBox = this.getMyTodoAlreadyBox();
            myAlreadyBox.setDataText(defaultTodoInfoMap.get("doneCount") + "");
            TodoInfoboxVo myRequestBox = this.getMyTodoRequestBox();
            myRequestBox.setDataText(defaultTodoInfoMap.get("requestCount") + "");
            TodoInfoboxVo myNoticeReadBox = this.getMyNoticeTodoRead();
            myNoticeReadBox.setDataText(defaultTodoInfoMap.get("copyCount") + "");
            map.put("myTaks", myTaksBox);
            map.put("myAlready", myAlreadyBox);
            map.put("myRequest", myRequestBox);
            map.put("myNoticeRead", myNoticeReadBox);
            AccountOrIdVo AccountOrIdVo2 = new AccountOrIdVo(ContextUtil.getCurrentUserId());
            JsonNode jsonNode = JsonUtil.toJsonNode((Object)AccountOrIdVo2);
            Map userInfoMap = this.ucFeignService.getDetailByAccountOrId((ObjectNode)jsonNode);
            if (BeanUtils.isNotEmpty((Object)userInfoMap)) {
                map.putAll(userInfoMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private TodoInfoboxVo getMyTodoTaksBox() {
        TodoInfoboxVo infobox = new TodoInfoboxVo();
        infobox.setIcon("fa-pencil-square-o");
        infobox.setColor("wood");
        infobox.setDataType("task");
        infobox.setDataContent("\u6211\u7684\u5f85\u529e");
        infobox.setUrl("/todoCenter/task");
        return infobox;
    }

    private TodoInfoboxVo getMyTodoAlreadyBox() throws Exception {
        TodoInfoboxVo infobox = new TodoInfoboxVo();
        infobox.setIcon("fa-flag");
        infobox.setColor("red");
        infobox.setDataType("done");
        infobox.setDataContent("\u5df2\u529e\u4e8b\u5b9c");
        infobox.setUrl("/todoCenter/done");
        return infobox;
    }

    private TodoInfoboxVo getMyTodoRequestBox() {
        TodoInfoboxVo infobox = new TodoInfoboxVo();
        infobox.setIcon("fa-hand-o-up");
        infobox.setColor("blue2");
        infobox.setDataType("myRequest");
        infobox.setDataContent("\u6211\u7684\u8bf7\u6c42");
        infobox.setUrl("/todoCenter/myRequest");
        return infobox;
    }

    private TodoInfoboxVo getMyNoticeTodoRead() throws Exception {
        TodoInfoboxVo infobox = new TodoInfoboxVo();
        infobox.setIcon("fa-comments");
        infobox.setColor("blue3");
        infobox.setDataType("noRead");
        infobox.setDataContent("\u6211\u7684\u5f85\u9605");
        infobox.setUrl("/todoCenter/noRead");
        return infobox;
    }

    private TodoInfoboxVo getMyNoticeTodoReaded() throws Exception {
        TodoInfoboxVo infobox = new TodoInfoboxVo();
        infobox.setIcon("fa-comments");
        infobox.setColor("blue3");
        infobox.setDataType("read");
        infobox.setDataContent("\u6211\u7684\u5df2\u9605");
        infobox.setUrl("/todoCenter/readed");
        return infobox;
    }
}

