/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.sim.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.OpenApi;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.handler.impl.AddCopyMessageHandler;
import com.hotent.todo.handler.impl.AddTaskMessageHandler;
import com.hotent.todo.handler.impl.DeleteTaskMessageHandler;
import com.hotent.todo.handler.impl.DoneCopyMessageHandler;
import com.hotent.todo.handler.impl.StartFlowMessageHandler;
import com.hotent.todo.handler.impl.TaskToDoneMessageHandler;
import com.hotent.todo.handler.impl.UpdateFlowMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.CopyDone;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Log;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.LogManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.vo.CopyDoneVo;
import com.hotent.todo.vo.CopyVo;
import com.hotent.todo.vo.DeleteTaskVo;
import com.hotent.todo.vo.FlowInstanceVo;
import com.hotent.todo.vo.LockOrUnLockVo;
import com.hotent.todo.vo.TaskDoneVo;
import com.hotent.todo.vo.TaskVo;
import com.hotent.todo.vo.TodoQueryVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${openApi.prefix}/todo/v1"})
@Api(tags={"\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u63a5\u53e3"})
@ApiGroup(group={"group_todo_external"})
@OpenApi(moduleName="\u7edf\u4e00\u5f85\u529e\u4e2d\u5fc3", function="\u63a8\u9001\u6d41\u7a0b\u6570\u636e", serviceType="todo", serviceTypeName="\u7edf\u4e00\u5f85\u529e\u63a5\u53e3")
public class ExternalTaskController {
    @Resource
    LogManager logManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/startFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u53d1\u8d77\u6d41\u7a0b", provide=true)
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b", httpMethod="POST", notes="\u53d1\u8d77\u6d41\u7a0b")
    public CommonResult startFlow(@ApiParam(name="flowInstanceVo", value="\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody FlowInstanceVo flowInstanceVo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        StartFlowMessageHandler messageHandler = (StartFlowMessageHandler)AppUtil.getBean(StartFlowMessageHandler.class);
        try {
            toJson = JsonUtil.toJson((Object)flowInstanceVo);
            FlowInstance flowInstance = new FlowInstance(flowInstanceVo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(flowInstanceVo.getSystemName());
            accessSystem.setSystemCode(flowInstanceVo.getSystemCode());
            messageHandler.doHandler(flowInstance, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, flowInstanceVo.getSystemCode(), flowInstanceVo.getSystemName(), flowInstanceVo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateFlow"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u66f4\u65b0\u6d41\u7a0b", provide=true)
    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b", httpMethod="POST", notes="\u66f4\u65b0\u6d41\u7a0b")
    public CommonResult updateFlow(@ApiParam(name="flowInstanceVo", value="\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody FlowInstanceVo flowInstanceVo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        UpdateFlowMessageHandler messageHandler = (UpdateFlowMessageHandler)AppUtil.getBean(UpdateFlowMessageHandler.class);
        try {
            toJson = JsonUtil.toJson((Object)flowInstanceVo);
            FlowInstance flowInstance = new FlowInstance(flowInstanceVo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(flowInstanceVo.getSystemName());
            accessSystem.setSystemCode(flowInstanceVo.getSystemCode());
            messageHandler.doHandler(flowInstance, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, flowInstanceVo.getSystemCode(), flowInstanceVo.getSystemName(), flowInstanceVo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5220\u9664\u5f85\u529e", provide=true)
    @ApiOperation(value="\u5220\u9664\u5f85\u529e", httpMethod="POST", notes="\u5220\u9664\u5f85\u529e")
    public CommonResult deleteTask(@ApiParam(name="vo", value="\u53c2\u6570", required=true) @RequestBody DeleteTaskVo vo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        DeleteTaskMessageHandler messageHandler = (DeleteTaskMessageHandler)AppUtil.getBean(DeleteTaskMessageHandler.class);
        try {
            toJson = JsonUtil.toJson((Object)vo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(vo.getSystemName());
            accessSystem.setSystemCode(vo.getSystemCode());
            messageHandler.doHandler((ObjectNode)JsonUtil.toJsonNode((Object)vo), accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, vo.getSystemCode(), vo.getSystemName(), vo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/taskToDone"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5f85\u529e\u8f6c\u5df2\u529e", provide=true)
    @ApiOperation(value="\u5f85\u529e\u8f6c\u5df2\u529e", httpMethod="POST", notes="\u5f85\u529e\u8f6c\u5df2\u529e")
    public CommonResult taskToDone(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody TaskDoneVo vo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        TaskToDoneMessageHandler messageHandler = (TaskToDoneMessageHandler)AppUtil.getBean(TaskToDoneMessageHandler.class);
        if (BeanUtils.isEmpty((Object)vo.getCreateTime())) {
            vo.setCreateTime(LocalDateTime.now());
        }
        try {
            toJson = JsonUtil.toJson((Object)vo);
            TaskDone taskDone = new TaskDone(vo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(vo.getSystemName());
            accessSystem.setSystemCode(vo.getSystemCode());
            messageHandler.doHandler(taskDone, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, vo.getSystemCode(), vo.getSystemName(), vo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/addCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u65b0\u589e\u6284\u9001", provide=true)
    @ApiOperation(value="\u65b0\u589e\u6284\u9001", httpMethod="POST", notes="\u65b0\u589e\u6284\u9001")
    public CommonResult addCopy(@ApiParam(name="copyVo", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody CopyVo copyVo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        AddCopyMessageHandler messageHandler = (AddCopyMessageHandler)AppUtil.getBean(AddCopyMessageHandler.class);
        if (BeanUtils.isEmpty((Object)copyVo.getCreateTime())) {
            copyVo.setCreateTime(LocalDateTime.now());
        }
        try {
            toJson = JsonUtil.toJson((Object)copyVo);
            Copy copy = new Copy(copyVo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(copyVo.getSystemName());
            accessSystem.setSystemCode(copyVo.getSystemCode());
            messageHandler.doHandler(copy, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, copyVo.getSystemCode(), copyVo.getSystemName(), copyVo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/doneCopy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5904\u7406\u6284\u9001", provide=true)
    @ApiOperation(value="\u5904\u7406\u6284\u9001", httpMethod="POST", notes="\u5904\u7406\u6284\u9001")
    public CommonResult doneCopy(@ApiParam(name="vo", value="\u8bf7\u6c42\u5bf9\u8c61", required=true) @RequestBody CopyDoneVo vo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        DoneCopyMessageHandler messageHandler = (DoneCopyMessageHandler)AppUtil.getBean(DoneCopyMessageHandler.class);
        try {
            toJson = JsonUtil.toJson((Object)vo);
            CopyDone copyDone = new CopyDone(vo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(vo.getSystemName());
            accessSystem.setSystemCode(vo.getSystemCode());
            messageHandler.doHandler(copyDone, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, "2", toJson, result, vo.getSystemCode(), vo.getSystemName(), vo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/addTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u65b0\u589e\u4efb\u52a1(\u975e\u5ba1\u6279\u7c7b\u578b))", provide=true)
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1(\u975e\u5ba1\u6279\u7c7b\u578b)", httpMethod="POST", notes="\u65b0\u589e\u4efb\u52a1(\u975e\u5ba1\u6279\u7c7b\u578b)")
    public CommonResult addTask(@ApiParam(name="taskVo", value="\u53c2\u6570", required=true) @RequestBody TaskVo taskVo) throws IOException {
        boolean res = true;
        String msg = "\u6210\u529f";
        String result = "";
        String toJson = "";
        AddTaskMessageHandler messageHandler = (AddTaskMessageHandler)AppUtil.getBean(AddTaskMessageHandler.class);
        try {
            toJson = JsonUtil.toJson((Object)taskVo);
            Task task = new Task(taskVo);
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemName(AuthenticationUtil.getSysName());
            messageHandler.doHandler(task, accessSystem);
        }
        catch (Exception e) {
            msg = "\u5931\u8d25";
            result = e.getMessage();
            res = false;
        }
        finally {
            this.recordLog(res, messageHandler.getType(), toJson, result, taskVo.getSystemCode(), taskVo.getSystemName(), taskVo.getInstanceId());
        }
        return new CommonResult(res, msg);
    }

    @RequestMapping(value={"/task/exist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5f85\u529e\u662f\u5426\u5b58\u5728", provide=true)
    @ApiOperation(value="\u5f85\u529e\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u5f85\u529e\u662f\u5426\u5b58\u5728")
    public CommonResult<Boolean> exist(@ApiParam(name="instanceId", value="\u53c2\u6570", required=true) @RequestParam String instanceId, @ApiParam(name="taskId", value="\u53c2\u6570", required=true) @RequestParam String taskId) throws IOException {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(Task::getTaskId, (Object)taskId);
        lambdaQueryWrapper.eq(Task::getInstanceId, (Object)instanceId);
        TaskManager taskManager = (TaskManager)AppUtil.getBean(TaskManager.class);
        List list = taskManager.list((Wrapper)lambdaQueryWrapper);
        return new CommonResult(true, "", (Object)(!list.isEmpty() ? 1 : 0));
    }

    @RequestMapping(value={"/instanceQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u6211\u53d1\u8d77\u7684\u6d41\u7a0b", provide=true)
    @ApiOperation(value="\u6211\u53d1\u8d77\u7684\u6d41\u7a0b", httpMethod="POST", notes="\u6211\u53d1\u8d77\u7684\u6d41\u7a0b")
    public CommonResult<PageList<FlowInstance>> instanceQuery(@ApiParam(name="instanceId", value="\u53c2\u6570", required=true) @RequestBody TodoQueryVo todoQueryVo) throws IOException {
        FlowInstanceManager flowInstanceManager = (FlowInstanceManager)AppUtil.getBean(FlowInstanceManager.class);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.withDefaultPage();
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getPage()) && BeanUtils.isNotEmpty((Object)todoQueryVo.getPageSize())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(todoQueryVo.getPage()), Integer.valueOf(todoQueryVo.getPageSize())));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getStartTime())) {
            queryFilter.getQuerys().add(new QueryField("FLOW_START_DATE_", (Object)todoQueryVo.getStartTime(), QueryOP.GREAT_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getEndTime())) {
            queryFilter.getQuerys().add(new QueryField("FLOW_START_DATE_", (Object)todoQueryVo.getEndTime(), QueryOP.LESS_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getTitle())) {
            queryFilter.getQuerys().add(new QueryField("TITLE_", (Object)todoQueryVo.getTitle(), QueryOP.LIKE));
        }
        String account = ContextUtil.getCurrentUser().getAccount();
        if (StringUtil.isNotEmpty((String)todoQueryVo.getAccount())) {
            account = todoQueryVo.getAccount();
        }
        queryFilter.getQuerys().add(new QueryField("OWER_ACCOUNT_", (Object)account, QueryOP.EQUAL));
        return new CommonResult(true, "", (Object)flowInstanceManager.query(queryFilter));
    }

    @RequestMapping(value={"/taskQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5f85\u529e\u67e5\u8be2\u63a5\u53e3", provide=true)
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2\u63a5\u53e3", httpMethod="POST", notes="\u5f85\u529e\u67e5\u8be2\u63a5\u53e3")
    public CommonResult<PageList<Task>> taskQuery(@ApiParam(name="instanceId", value="\u53c2\u6570", required=true) @RequestBody TodoQueryVo todoQueryVo) throws IOException {
        TaskManager taskManager = (TaskManager)AppUtil.getBean(TaskManager.class);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.withDefaultPage();
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getPage()) && BeanUtils.isNotEmpty((Object)todoQueryVo.getPageSize())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(todoQueryVo.getPage()), Integer.valueOf(todoQueryVo.getPageSize())));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getStartTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_ARRIVE_DATE_", (Object)todoQueryVo.getStartTime(), QueryOP.GREAT_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getEndTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_ARRIVE_DATE_", (Object)todoQueryVo.getEndTime(), QueryOP.LESS_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getTitle())) {
            queryFilter.getQuerys().add(new QueryField("TITLE_", (Object)todoQueryVo.getTitle(), QueryOP.LIKE));
        }
        String account = ContextUtil.getCurrentUser().getAccount();
        if (StringUtil.isNotEmpty((String)todoQueryVo.getAccount())) {
            account = todoQueryVo.getAccount();
        }
        queryFilter.getQuerys().add(new QueryField("TASK_APPROVE_ACCOUNT_", (Object)account, QueryOP.EQUAL));
        return new CommonResult(true, "", (Object)taskManager.query(queryFilter));
    }

    @RequestMapping(value={"/taskDoneQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5df2\u529e\u67e5\u8be2\u63a5\u53e3", provide=true)
    @ApiOperation(value="\u5df2\u529e\u67e5\u8be2\u63a5\u53e3", httpMethod="POST", notes="\u5df2\u529e\u67e5\u8be2\u63a5\u53e3")
    public CommonResult<PageList<TaskDone>> taskDoneQuery(@ApiParam(name="instanceId", value="\u53c2\u6570", required=true) @RequestBody TodoQueryVo todoQueryVo) throws IOException {
        TaskDoneManager taskDone = (TaskDoneManager)AppUtil.getBean(TaskDoneManager.class);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.withDefaultPage();
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getPage()) && BeanUtils.isNotEmpty((Object)todoQueryVo.getPageSize())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(todoQueryVo.getPage()), Integer.valueOf(todoQueryVo.getPageSize())));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getStartTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_DONE_DATE_", (Object)todoQueryVo.getStartTime(), QueryOP.GREAT_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getEndTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_DONE_DATE_", (Object)todoQueryVo.getEndTime(), QueryOP.LESS_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getTitle())) {
            queryFilter.getQuerys().add(new QueryField("TITLE_", (Object)todoQueryVo.getTitle(), QueryOP.LIKE));
        }
        String account = ContextUtil.getCurrentUser().getAccount();
        if (StringUtil.isNotEmpty((String)todoQueryVo.getAccount())) {
            account = todoQueryVo.getAccount();
        }
        queryFilter.getQuerys().add(new QueryField("TASK_APPROVE_ACCOUNT_", (Object)account, QueryOP.EQUAL));
        return new CommonResult(true, "", (Object)taskDone.query(queryFilter));
    }

    @RequestMapping(value={"/task/lockOrUnLockTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u9501\u5b9a\u6216\u89e3\u9501\u4efb\u52a1", provide=true)
    @ApiOperation(value="\u9501\u5b9a\u6216\u89e3\u9501\u4efb\u52a1", httpMethod="GET", notes="\u9501\u5b9a\u6216\u89e3\u9501\u4efb\u52a1")
    public CommonResult<String> lockOrUnLockTask(@ApiParam(name="instanceId", value="\u53c2\u6570", required=true) @RequestBody LockOrUnLockVo vo) throws IOException {
        TaskManager taskManager = (TaskManager)AppUtil.getBean(TaskManager.class);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.eq(Task::getTaskId, (Object)vo.getTaskId());
        lambdaUpdateWrapper.eq(Task::getInstanceId, (Object)vo.getInstanceId());
        if (Objects.equals("1", vo.getType())) {
            lambdaUpdateWrapper.set(Task::getIsDele, (Object)"1");
            lambdaUpdateWrapper.ne(Task::getTaskApproveAccount, (Object)vo.getAccount());
        } else if (Objects.equals("2", vo.getType())) {
            lambdaUpdateWrapper.set(Task::getIsDele, (Object)"0");
        }
        taskManager.update((Wrapper)lambdaUpdateWrapper);
        return new CommonResult(true, "", (Object)"");
    }

    @RequestMapping(value={"/copyQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u4f20\u9605\u67e5\u8be2\u63a5\u53e3", provide=true)
    @ApiOperation(value="\u4f20\u9605\u67e5\u8be2\u63a5\u53e3", httpMethod="POST", notes="\u4f20\u9605\u67e5\u8be2\u63a5\u53e3")
    public CommonResult<PageList<Copy>> copyQuery(@ApiParam(name="todoQueryVo", value="\u53c2\u6570", required=true) @RequestBody TodoQueryVo todoQueryVo) throws IOException {
        CopyManager copyManager = (CopyManager)AppUtil.getBean(CopyManager.class);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.withDefaultPage();
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getPage()) && BeanUtils.isNotEmpty((Object)todoQueryVo.getPageSize())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(todoQueryVo.getPage()), Integer.valueOf(todoQueryVo.getPageSize())));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getStartTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_ARRIVE_DATE_", (Object)todoQueryVo.getStartTime(), QueryOP.GREAT_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getEndTime())) {
            queryFilter.getQuerys().add(new QueryField("TASK_ARRIVE_DATE_", (Object)todoQueryVo.getEndTime(), QueryOP.LESS_EQUAL));
        }
        if (BeanUtils.isNotEmpty((Object)todoQueryVo.getTitle())) {
            queryFilter.getQuerys().add(new QueryField("TITLE_", (Object)todoQueryVo.getTitle(), QueryOP.LIKE));
        }
        String account = ContextUtil.getCurrentUser().getAccount();
        if (StringUtil.isNotEmpty((String)todoQueryVo.getAccount())) {
            account = todoQueryVo.getAccount();
        }
        queryFilter.getQuerys().add(new QueryField("CALLY_RECEIVE_ACCOUNT_", (Object)account, QueryOP.EQUAL));
        return new CommonResult(true, "", (Object)copyManager.query(queryFilter));
    }

    @RequestMapping(value={"/physicsRemove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @OpenApi(description="\u5220\u9664\u6d41\u7a0b\u6570\u636e", provide=true)
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u6570\u636e", httpMethod="GET", notes="\u5220\u9664\u6d41\u7a0b\u6570\u636e")
    public CommonResult<String> physicsRemove(@ApiParam(name="flowKey", value="\u6d41\u7a0b\u5b9a\u4e49Key", required=true) @RequestParam String flowKey, @ApiParam(name="sysCode", value="\u7cfb\u7edf\u7f16\u7801", required=true) @RequestParam String sysCode) throws IOException {
        FlowInstanceManager flowInstanceManager = (FlowInstanceManager)AppUtil.getBean(FlowInstanceManager.class);
        flowInstanceManager.physicsRemove(flowKey, sysCode);
        return new CommonResult(true, "", (Object)"");
    }

    private void recordLog(boolean isSuccess, String messageType, String message, String result, String systemCode, String systemName, String instanceId) {
        Log log = new Log();
        log.setStatus(isSuccess ? "1" : "0");
        log.setVersion(1);
        log.setInstanceId(instanceId);
        log.setMessageType(messageType);
        log.setMessageBody(message);
        log.setTimestamp(LocalDateTime.now());
        log.setResult(result);
        log.setFromSystemCode(systemCode);
        log.setFromSystemName(systemName);
        log.setFrom("REST");
        this.logManager.create((Model)log);
    }
}

