/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.todo.model.SystemManage;
import com.hotent.todo.persistence.manager.SystemManageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/todo/system-manage"})
@Api(tags={"\u63a5\u5165\u7cfb\u7edf\u7ba1\u7406\u5458"})
@ApiGroup(group={"group_todo"})
public class SystemManageController
extends BaseController<SystemManageManager, SystemManage> {
    @Resource
    SystemManageManager systemManageManager;

    @PostMapping(value={"/queryList"})
    @ApiOperation(value="\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u7cfb\u7edf\u7ba1\u7406\u5458\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<SystemManage> queryList(@ApiParam(name="sysCode", value="\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801", required=true) @RequestParam String sysCode, @ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SystemManage> queryFilter) throws Exception {
        queryFilter.addFilter("sysCode", (Object)sysCode, QueryOP.EQUAL, FieldRelation.AND, "system");
        return ((SystemManageManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"saveBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u7ba1\u7406\u5458\u4fe1\u606f", httpMethod="POST", notes="\u6279\u91cf\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u7ba1\u7406\u5458\u4fe1\u606f")
    public CommonResult<String> saveBatch(@ApiParam(name="sysCode", value="\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801", required=true) @RequestParam String sysCode, @ApiParam(name="systemManages", value="\u7cfb\u7edf\u7ba1\u7406\u5458", required=true) @RequestBody @Valid List<SystemManage> systemManages) throws Exception {
        return this.systemManageManager.saveUserBatch(sysCode, systemManages);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u5220\u9664", httpMethod="POST", notes="\u7ba1\u7406\u5458\u5220\u9664")
    public CommonResult<String> remove(@RequestBody List<String> ids) {
        ((SystemManageManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5f85\u529e\u5220\u9664\u6210\u529f");
    }
}

