/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.vo.TaskDoneVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/todo/task-done"})
@Api(tags={"\u5f85\u529e\u4efb\u52a1\u5df2\u529e"})
@ApiGroup(group={"group_todo"})
public class TaskDoneController
extends BaseController<TaskDoneManager, TaskDone> {
    @Resource
    private FlowInstanceManager flowInstanceManager;

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<TaskDone> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        return ((TaskDoneManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/front/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<TaskDone> queryFrontPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        return ((TaskDoneManager)this.baseService).queryPage(queryFilter, currentUser.getAccount());
    }

    @PostMapping(value={"/mobile/myTaskDone"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<TaskDone> myTaskDone(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        return ((TaskDoneManager)this.baseService).queryPage(queryFilter, currentUser.getUserId());
    }

    @PostMapping(value={"/ignoreLow"})
    @ApiOperation(value="\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1", httpMethod="POST", notes="\u6253\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1\u6807\u7b7e")
    public CommonResult<String> ignoreLow(@ApiParam(name="modifReason", value="\u539f\u56e0\u5bf9\u8c61") @RequestBody String modifReason, @ApiParam(name="ids", value="\u4efb\u52a1\u4e3b\u952e(\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694)") @RequestParam String ids, @ApiParam(name="ignore", value="true\uff1a\u5ffd\u7565\uff0cfalse\uff1a\u5ffd\u7565") @RequestParam boolean ignore) {
        if (StringUtil.isNotEmpty((String)ids)) {
            ((TaskDoneManager)this.baseService).ignoreLow(ids, ignore, modifReason);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u672a\u4f20\u5165\u5ffd\u7565\u6570\u636eid");
    }

    @PostMapping(value={"/queryOvertimePage"})
    @ApiOperation(value="\u4f4e\u6548\u7edf\u8ba1\u5217\u8868", httpMethod="POST", notes="\u4f4e\u6548\u7edf\u8ba1\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Map<String, Object>> queryOvertimePage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        return ((TaskDoneManager)this.baseService).queryOvertimePage(queryFilter);
    }

    @PostMapping(value={"/queryLowPage"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<TaskDone> queryLowPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        return ((TaskDoneManager)this.baseService).queryLowPage(queryFilter);
    }

    @PostMapping(value={"/mobile/findPageTaskDone"})
    @ApiOperation(value="\u79fb\u52a8\u7aef-\u5df2\u529e\u5217\u8868", httpMethod="POST", notes="\u79fb\u52a8\u7aef-\u5df2\u529e\u5217\u8868")
    public CommonResult<PageList<TaskDoneVo>> findPageTaskDone(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        PageList resultPage = new PageList();
        ArrayList voList = new ArrayList();
        String account = Optional.ofNullable(ContextUtil.getCurrentUser()).map(IUser::getAccount).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        this.getMobileQueryParams(queryFilter);
        queryFilter.addFilter("done.TASK_APPROVE_NUM_", (Object)account, QueryOP.EQUAL);
        PageList<TaskDone> pageList = ((TaskDoneManager)this.baseService).queryMobilePage(queryFilter);
        List rows = pageList.getRows();
        if (rows != null && rows.size() > 0) {
            Set<String> instanceIdSet = rows.stream().map(TaskDone::getInstanceId).collect(Collectors.toSet());
            Map<String, String> serialNumberMap = this.flowInstanceManager.findSerialNumber(instanceIdSet);
            rows.forEach(item -> {
                TaskDoneVo taskDoneVo = (TaskDoneVo)BeanUtil.copyProperties((Object)item, TaskDoneVo.class, (String[])new String[0]);
                String serialNumber = (String)serialNumberMap.get(taskDoneVo.getInstanceId());
                taskDoneVo.setSerialNumber(serialNumber);
                voList.add(taskDoneVo);
            });
        }
        resultPage.setPage(pageList.getPage());
        resultPage.setRows(voList);
        resultPage.setTotal(pageList.getTotal());
        resultPage.setPageSize(pageList.getPageSize());
        return new CommonResult(true, "\u79fb\u52a8\u7aef-\u4ee3\u529e\u5217\u8868", (Object)resultPage);
    }

    private void getMobileQueryParams(QueryFilter<?> queryFilter) {
        List querys = queryFilter.getQuerys();
        if (querys != null && querys.size() > 0) {
            querys = querys.stream().peek(item -> item.setProperty("done." + item.getProperty())).collect(Collectors.toList());
            String keyword = ((QueryField)querys.get(0)).getValue().toString();
            String group = ((QueryField)querys.get(0)).getGroup();
            if (StringUtils.hasText((String)keyword)) {
                queryFilter.setQuerys(querys);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().like(FlowInstance::getSerialNumber, (Object)keyword);
                List list = this.flowInstanceManager.list((Wrapper)queryWrapper);
                List insIdList = list.stream().map(FlowInstance::getInstanceId).collect(Collectors.toList());
                if (insIdList.size() > 0) {
                    QueryField queryField = new QueryField();
                    queryField.setProperty("done.INSTANCE_ID_");
                    queryField.setOperation(QueryOP.IN);
                    queryField.setRelation(FieldRelation.OR);
                    queryField.setGroup(group);
                    queryField.setValue(insIdList);
                    queryFilter.addQueryField(queryField);
                }
            }
        }
    }
}

