/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.impl.FlowInstanceManagerImpl;
import io.jsonwebtoken.lang.Assert;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(FlowInstanceManagerImpl.class);
    @Resource
    FlowInstanceManager flowInstanceManager;

    public abstract void doHandler(T var1, AccessSystem var2);

    public AccessSystem handler(ObjectNode message, String topic, AccessSystem accessSystem) {
        accessSystem.setFrom(this.getFrom(topic));
        this.doHandler(this.convertMessageToEntity(message), accessSystem);
        return accessSystem;
    }

    private String getFrom(String topic) {
        if (StringUtil.isNotEmpty((String)topic)) {
            String[] arrays = topic.split("_");
            return arrays[2];
        }
        return "";
    }

    protected Class<T> getEntityClass() {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return entityClass;
    }

    protected T convertMessageToEntity(ObjectNode message) {
        try {
            try {
                if ("4".equals(message.get("operatorType").asText()) && message.has("taskDoneDate") && (BeanUtils.isNotEmpty((Object)message.get("taskDoneDate")) || " ".equals(message.get("taskDoneDate").asText()))) {
                    message.put("taskDoneDate", TimeUtil.getDateTimeString((LocalDateTime)LocalDateTime.now()));
                    logger.info(String.format("\u5904\u7406\u5f85\u529e\u8f6c\u5df2\u529e\u5904\u7406\u5b8c\u6210\u65e5\u671f\uff1a%s", message.toString()));
                }
            }
            catch (Exception e) {
                logger.error(String.format("\u5904\u7406\u5f85\u529e\u8f6c\u5df2\u529e\u5f02\u5e38\u5b8c\u6210\u65e5\u671f\u51fa\u9519\uff1a%s", e.getMessage()));
            }
            return (T)JsonUtil.toBean((JsonNode)message, this.getEntityClass());
        }
        catch (Exception e) {
            throw new BaseException("\u6d88\u606f\u7684json\u683c\u5f0f\u6709\u8bef");
        }
    }

    protected FlowInstance isFlowInstanceExist(String systemCode, String instanceId) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)systemCode), (String)"systemCode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)instanceId), (String)"instanceId\u4e0d\u80fd\u4e3a\u7a7a");
        FlowInstance flowInstance = this.flowInstanceManager.getBySystemCodeAndInstanceId(systemCode, instanceId);
        if (flowInstance == null) {
            throw new MessageShouldRetryException(String.format("systemCode\u4e3a: %s\uff0cinstanceId\u4e3a\uff1a%s\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728", systemCode, instanceId));
        }
        return flowInstance;
    }
}

