/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.msg.service.TodoMessageService;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.util.CacheRedisUtil;
import io.jsonwebtoken.lang.Assert;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AddCopyMessageHandler
extends AbstractMessageHandler<Copy>
implements MessageHandler {
    protected static final Logger logger = LoggerFactory.getLogger(AddCopyMessageHandler.class);
    @Resource
    CopyManager copyManager;
    @Resource
    TodoMessageService todoMessageService;
    @Resource
    CacheRedisUtil cacheRedisUtil;
    @Value(value="${dingTalk.corpId:ding86fe8ae26d0e3eee35c2f4657eb6378f}")
    private String dingTalkCorpId;

    @Override
    public String getType() {
        return TodoMessageType.ADD_COPY.key();
    }

    @Override
    public void doHandler(Copy entity, AccessSystem accessSystem) {
        if (StringUtil.isNotEmpty((String)entity.getInstanceId())) {
            FlowInstance flowInstance = this.isFlowInstanceExist(entity.getSystemCode(), entity.getInstanceId());
            entity.setTitle(flowInstance.getTitle());
        } else {
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entity.getBusinessTypeId()), (String)"businessTypeId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)entity.getBusinessType()), (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        entity.setSystemName(accessSystem.getSystemName());
        entity.setCallyReceiveNum(entity.getCallyReceiveAccount());
        entity.setCallyStartNum(entity.getCallyStartAccount());
        entity.setStatus("pending");
        entity.setFrom(accessSystem.getFrom());
        this.copyManager.create((Model)entity);
    }
}

