/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.hotent.base.util.StringUtil;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.CopyDone;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.persistence.manager.CopyManager;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DoneCopyMessageHandler
extends AbstractMessageHandler<CopyDone>
implements MessageHandler {
    @Resource
    CopyManager copyManager;

    @Override
    public String getType() {
        return TodoMessageType.DONE_COPY.key();
    }

    @Override
    public void doHandler(CopyDone entity, AccessSystem accessSystem) {
        if (StringUtil.isNotEmpty((String)entity.getInstanceId())) {
            FlowInstance flowInstance = this.isFlowInstanceExist(entity.getSystemCode(), entity.getInstanceId());
            entity.setTitle(flowInstance.getTitle());
        }
        entity.setSystemName(accessSystem.getSystemName());
        entity.setFrom(accessSystem.getFrom());
        this.copyManager.copyToDone(entity);
    }
}

