/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Task;
import com.hotent.todo.util.TodoUtil;
import com.hotent.uc.api.model.IUser;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UpdateFlowMessageHandler
extends AbstractMessageHandler<FlowInstance>
implements MessageHandler {
    @Value(value="${dingTalk.corpId:ding86fe8ae26d0e3eee35c2f4657eb6378f}")
    private String dingTalkCorpId;

    @Override
    public String getType() {
        return TodoMessageType.UPDATE_FLOW.key();
    }

    @Override
    public void doHandler(FlowInstance entity, AccessSystem accessSystem) {
        FlowInstance flowInstance = this.isFlowInstanceExist(entity.getSystemCode(), entity.getInstanceId());
        entity.setId(flowInstance.getId());
        entity.setFlowCostSecond(flowInstance.getFlowCostSecond());
        Assert.isTrue((!"complete".equals(flowInstance.getFlowStatus()) || !"delete".equals(entity.getFlowStatus()) ? 1 : 0) != 0, (String)String.format("id\u4e3a: %s\u7684\u5b9e\u4f8b\u5df2\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", entity.getInstanceId()));
        IUser startUser = TodoUtil.getUser(entity.getOwerAccount(), entity.getOwerName());
        entity.setOwerNum(startUser.getAccount());
        entity.setOwerName(startUser.getFullname());
        entity.setOwerAccount(startUser.getAccount());
        entity.setSystemName(accessSystem.getSystemName());
        entity.setPositionCode(flowInstance.getPositionCode());
        entity.setPostGroupCode(flowInstance.getPostGroupCode());
        entity.setOrgName(flowInstance.getOrgName());
        entity.setOrgFullName(flowInstance.getOrgFullName());
        entity.setSerialNumber(flowInstance.getInstanceId());
        ArrayList<IUser> users = new ArrayList<IUser>();
        this.handleTaskApprove(entity, users);
        entity.setFrom(accessSystem.getFrom());
        this.flowInstanceManager.handleInstance(entity, users, startUser);
    }

    private void handleTaskApprove(FlowInstance flowInstance, List<IUser> users) {
        List<Task> taskList = flowInstance.getTaskList();
        if (BeanUtils.isNotEmpty(taskList) && taskList.size() > 0) {
            for (Task task : taskList) {
                task.setSystemCode(flowInstance.getSystemCode());
                task.setSystemName(flowInstance.getSystemName());
                task.setTaskStartId(flowInstance.getOwerId());
                task.setTaskStartNum(flowInstance.getOwerNum());
                task.setTaskStartAccount(flowInstance.getOwerAccount());
                task.setTaskStartName(flowInstance.getOwerName());
                IUser approve = TodoUtil.getUser(task.getTaskApproveAccount(), task.getTaskApproveName());
                task.setTaskApproveNum(approve.getAccount());
                users.add(approve);
            }
        }
    }
}

