/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.msg.service.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.constants.MessageType;
import com.hotent.todo.model.MsgCenterLog;
import com.hotent.todo.msg.model.Message;
import com.hotent.todo.msg.persistence.manager.IMsgCenterLogService;
import com.hotent.todo.msg.service.IMessageSender;
import com.hotent.todo.msg.service.TodoMessageService;
import com.hotent.todo.util.CacheRedisUtil;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements TodoMessageService {
    Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Resource
    FreeMarkerEngine freeMarkerEngine;
    @Resource
    IMsgCenterLogService msgCenterLogService;
    @Resource(name="asyncExecutor")
    Executor executorService;
    @Resource
    CacheRedisUtil cacheRedisUtil;
    @Resource
    JmsProducer jmsProducer;
    public String mobileUrlPrefix;
    public static final String TASK_CREATE_DEFAULT = "taskcreate-default";
    public static final String PROCESS_END_DEFAULT = "processend-default";
    public static final String COPY_TO_DEFAULT = "copyto-default";

    @Override
    public String sendMessage(MessageType msgType, String destination, String templateId, Map<String, String> vars, boolean isLog) {
        return this.send(msgType, templateId, vars, isLog, sender -> destination);
    }

    @Override
    public void sendMessage(MessageType msgType, JsonNode users, String templateId, Map<String, String> vars, boolean isLog) {
        this.executorService.execute(() -> this.send(msgType, templateId, vars, isLog, sender -> users.get("fuserid").asText()));
    }

    private String send(MessageType msgType, String templateId, Map<String, String> vars, boolean isLog, Function<IMessageSender, String> function) {
        String content = "";
        String title = "";
        String destination = "";
        try {
            JsonNode node = this.cacheRedisUtil.getMsgTemplateByKey(templateId);
            title = this.getTitle(node, vars, templateId);
            content = this.getContent(node, vars, templateId);
            IMessageSender messageSender = (IMessageSender)AppUtil.getBean((String)msgType.getKey());
            if (BeanUtils.isEmpty((Object)messageSender)) {
                this.log.error("\u672a\u627e\u5230{}\u6d88\u606f\u53d1\u9001\u5668\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u7c7b\u578b", (Object)msgType);
                throw new BaseException("\u672a\u627e\u5230" + (Object)((Object)msgType) + "\u6d88\u606f\u53d1\u9001\u5668\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u7c7b\u578b");
            }
            destination = function.apply(messageSender);
            Message message = new Message();
            message.setTitle(title);
            message.setContent(content);
            message.setDestination(destination);
            String url = vars.get("url");
            if (StringUtil.isNotEmpty((String)url)) {
                String newUrl = url.replaceAll("redirect_uri=" + this.mobileUrlPrefix + "/", "redirect_uri=");
                message.setPcUrl(newUrl);
                message.setMobileUrl(newUrl);
                vars.put("url", newUrl);
            }
            String id = messageSender.send(message);
            if (isLog) {
                this.createLog(msgType.getKey(), destination, templateId, content, vars, id);
            }
            return id;
        }
        catch (Exception e) {
            if (isLog) {
                MsgCenterLog msgCenterLog = new MsgCenterLog();
                msgCenterLog.setType(msgType.getKey());
                msgCenterLog.setDestination(destination);
                msgCenterLog.setTemplateId(templateId);
                msgCenterLog.setContent(content);
                msgCenterLog.setVars(JsonUtil.toJsonString(vars));
                msgCenterLog.setSendTime(LocalDateTime.now());
                msgCenterLog.setError(ExceptionUtil.getFullStackTrace((Throwable)e));
                this.msgCenterLogService.create((Model)msgCenterLog);
                this.log.error(ExceptionUtil.getFullStackTrace((Throwable)e));
            }
            return null;
        }
    }

    private void createLog(String type, String destination, String templateId, String content, Map<String, String> vars, String taskId) {
        this.executorService.execute(() -> {
            MsgCenterLog msgCenterLog = new MsgCenterLog();
            msgCenterLog.setType(type);
            msgCenterLog.setDestination(destination);
            msgCenterLog.setTemplateId(templateId);
            msgCenterLog.setContent(content);
            msgCenterLog.setVars(JsonUtil.toJsonString((Object)vars));
            msgCenterLog.setSendTime(LocalDateTime.now());
            msgCenterLog.setMsgId(taskId);
            this.msgCenterLogService.create((Model)msgCenterLog);
        });
    }

    private String getTitle(JsonNode msgTemplate, Map<String, String> vars, String templateKey) throws Exception {
        if (BeanUtils.isNotEmpty((Object)msgTemplate)) {
            String template = msgTemplate.get("subject").asText();
            return this.freeMarkerEngine.parseByTemplate(template, vars);
        }
        String title = "\u5f85\u529e\u63d0\u9192";
        if (TASK_CREATE_DEFAULT.equals(templateKey)) {
            title = "\u5f85\u529e\u63d0\u9192:";
        } else if (PROCESS_END_DEFAULT.equals(templateKey)) {
            title = "\u529e\u7ed3\u63d0\u9192:";
        } else if (COPY_TO_DEFAULT.equals(templateKey)) {
            title = "\u6284\u9001\u63d0\u9192:";
        }
        return title;
    }

    private String getContent(JsonNode msgTemplate, Map<String, String> vars, String templateKey) throws Exception {
        if (BeanUtils.isNotEmpty((Object)msgTemplate)) {
            String template = msgTemplate.get("plain").asText();
            return this.freeMarkerEngine.parseByTemplate(template, vars);
        }
        String title = "\u5f85\u529e\u63d0\u9192";
        if (TASK_CREATE_DEFAULT.equals(templateKey)) {
            title = "\u5f85\u529e\u63d0\u9192:";
        } else if (PROCESS_END_DEFAULT.equals(templateKey)) {
            title = "\u529e\u7ed3\u63d0\u9192:";
        } else if (COPY_TO_DEFAULT.equals(templateKey)) {
            title = "\u6284\u9001\u63d0\u9192:";
        }
        String content = "### **%s\uff1a${subject}**\n\n\u53d1\u8d77\u4eba\uff1a${creator}\n\n\u53d1\u8d77\u65f6\u95f4\uff1a${createTime}\n";
        content = this.freeMarkerEngine.parseByTemplate(content, vars);
        return String.format(content, title);
    }
}

