/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.handler.impl.AddCopyMessageHandler;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.CopyDone;
import com.hotent.todo.persistence.dao.CopyMapper;
import com.hotent.todo.persistence.manager.CopyManager;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CopyManagerImpl
extends BaseManagerImpl<CopyMapper, Copy>
implements CopyManager {
    protected static final Logger logger = LoggerFactory.getLogger(AddCopyMessageHandler.class);

    @Override
    public Copy getByCallyId(String callyId, String systemCode, String instanceId) {
        return ((CopyMapper)this.baseMapper).getByCallyId(callyId, systemCode, instanceId);
    }

    @Override
    public void copyToDone(CopyDone copyDone) {
        String instanceId = StringUtil.isNotEmpty((String)copyDone.getInstanceId()) ? copyDone.getInstanceId() : null;
        Copy copy = ((CopyMapper)this.baseMapper).getByCallyId(copyDone.getCallyId(), copyDone.getSystemCode(), instanceId);
        if (BeanUtils.isEmpty((Object)((Object)copy))) {
            throw new MessageShouldRetryException(String.format("callyId\u4e3a: %s\uff0csystemCode\u4e3a: %s\uff0cinstanceId\u4e3a\uff1a%s\u7684\u6284\u9001\u4e0d\u5b58\u5728", copyDone.getCallyId(), copyDone.getSystemCode(), copyDone.getInstanceId()));
        }
        copy.setStatus("read");
        if (BeanUtils.isNotEmpty((Object)copyDone.getPcTaskUrl())) {
            copy.setPcTaskUrl(copyDone.getPcTaskUrl());
        }
        if (BeanUtils.isNotEmpty((Object)copyDone.getMobileTaskUrl())) {
            copy.setMobileTaskUrl(copyDone.getMobileTaskUrl());
        }
        super.update((Model)copy);
    }

    @Override
    public void copyToDone(String id) {
        Copy copy = (Copy)super.get((Serializable)((Object)id));
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)copy)), (String)String.format("id\u4e3a: %s\u7684\u6284\u9001\u4e0d\u5b58\u5728", id));
        copy.setStatus("read");
        super.update((Model)copy);
    }

    @Override
    @Transactional
    public void copyToDone(List<String> ids) {
        ids.forEach(this::copyToDone);
    }

    @Override
    public void removeByInstanceId(LocalDateTime updateTime, String systemCode, String instanceId) {
        ((CopyMapper)this.baseMapper).removeByInstanceId(updateTime, systemCode, instanceId);
    }

    @Override
    public void ignoreLow(String ids, boolean ignore) {
        List<String> idList = Arrays.asList(ids.split(","));
        ((CopyMapper)this.baseMapper).ignoreLowTag(idList, ignore ? "1" : "0");
    }

    @Override
    public Integer findMyTaskCount(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(Copy::getStatus, (Object)"pending")).eq(Copy::getCallyReceiveAccount, (Object)account)).eq(Copy::getIsDele, (Object)"0");
        return ((CopyMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }
}

