/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.todo.model.TaskMonitor;
import com.hotent.todo.persistence.dao.TaskMonitorMapper;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.persistence.manager.TaskMonitorManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TaskMonitorManagerImpl
extends BaseManagerImpl<TaskMonitorMapper, TaskMonitor>
implements TaskMonitorManager {
    @Resource
    TaskManager taskManager;
    @Resource
    DatabaseContext databaseContext;

    @Override
    public List<TaskMonitor> countTaskGroupByUser(String accountOrName) {
        return ((TaskMonitorMapper)this.baseMapper).countTaskGroupByUser(accountOrName);
    }

    @Override
    public void saveMonitors(List<TaskMonitor> monitors) {
        List userIds = monitors.stream().map(TaskMonitor::getUserId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(userIds)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(TaskMonitor::getUserId, userIds);
            this.remove((Wrapper)wrapper);
        }
        this.saveBatch(monitors);
    }
}

