/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.persistence.manager.impl;

import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.model.TaskOa;
import com.hotent.todo.persistence.dao.TaskMapper;
import com.hotent.todo.persistence.dao.TaskOaMapper;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.persistence.manager.TaskOaManager;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskOaManagerImpl
extends BaseManagerImpl<TaskOaMapper, TaskOa>
implements TaskOaManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskOaManager.class);
    @Value(value="${oa.pcTaskUrl:http://10.0.2.213:2081/spa/workflow/static4form/index.html?#/main/workflow/req}")
    private String pcTaskUrl;
    @Value(value="${oa.mobileTaskUrl:http://10.0.2.213:2081/spa/workflow/static4mobileform/index.html?#/req}")
    private String mobileTaskUrl;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    TaskMapper taskMapper;
    @Resource
    TaskManager taskManager;
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    FlowInstanceManager flowInstanceManager;

    @Override
    @Transactional
    public void removeTaskByUserId(String userId) {
        ((TaskOaMapper)this.baseMapper).removeTaskByUserId(userId);
    }

    @Override
    public List<Map<String, Object>> queryOaTasks(String userNumber, List<String> instIdList, String arriveTime, String startDate) {
        return null;
    }

    @Override
    @Transactional
    public void initOaTask(List<Map<String, Object>> oaTasks, String userId) {
    }

    @Override
    public void handledOaTaskInit(String userId, String userNumber, String arriveTime, String startDate) {
        if (StringUtil.isNotEmpty((String)userId)) {
            if (StringUtil.isEmpty((String)arriveTime)) {
                arriveTime = this.getTimeByType(90);
            }
            ArrayList<Map<String, Object>> list = new ArrayList();
            List<String> ids = this.taskMapper.queryOaInstanceIds(userId, arriveTime);
            list = this.queryOaTasks(userNumber, BeanUtils.isNotEmpty(ids) ? ids : null, arriveTime, startDate);
            this.initOaTask(list, userId);
        }
    }

    @Override
    public void initAllUserTasks(String startDate) {
        logger.error("\u5f00\u59cb----------------------------\uff1a" + TimeUtil.getCurrentTime());
        logger.error("\u7ed3\u675f----------------------------\uff1a" + TimeUtil.getCurrentTime());
    }

    private String getTimeByType(Integer seconds) {
        LocalDateTime now = LocalDateTime.now();
        now = now.minusSeconds(seconds.intValue());
        return TimeUtil.getDateString((LocalDateTime)now, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private List<Map<String, Object>> queryOaTaskDones(String startDate, String endDate, String endTime) {
        return null;
    }

    @Override
    public void handledOaTaskDoneInit(String startDate) throws IOException {
    }

    private void buildTaskDone(Map<String, Object> taskDoneMap, Map<String, String> userNumberMap, List<TaskDone> taskDones) {
        String userNumber = String.valueOf(taskDoneMap.get("approvenum"));
    }

    @Override
    public void handledOaInstanceInit(String startDate, String endDateTime) throws IOException {
    }

    private void buildInstance(Map<String, Object> instanceMap, Map<String, String> userNumberMap, List<FlowInstance> instances) {
        String userNumber = String.valueOf(instanceMap.get("startnum"));
        if (userNumberMap.containsKey(userNumber)) {
            String instId = String.valueOf(instanceMap.get("requestid"));
            String createdate = String.valueOf(instanceMap.get("createdate"));
            String createtime = String.valueOf(instanceMap.get("createtime"));
            String requestname = String.valueOf(instanceMap.get("requestname"));
            String flowid = String.valueOf(instanceMap.get("flowid"));
            String flowname = String.valueOf(instanceMap.get("flowname"));
            String lastoperatedate = "";
            String lastoperatetime = "";
            if (BeanUtils.isNotEmpty((Object)instanceMap.get("lastoperatedate"))) {
                lastoperatedate = String.valueOf(instanceMap.get("lastoperatedate"));
                lastoperatetime = String.valueOf(instanceMap.get("lastoperatetime"));
            }
            String startaccount = String.valueOf(instanceMap.get("startaccount"));
            String startnum = String.valueOf(instanceMap.get("startnum"));
            String startname = String.valueOf(instanceMap.get("startname"));
            String status = String.valueOf(instanceMap.get("status"));
            int processusercount = Integer.valueOf(instanceMap.get("processusercount").toString());
            String startId = "";
            if (userNumberMap.containsKey(startnum)) {
                startId = userNumberMap.get(startnum);
            }
            String startOrgName = "";
            if (BeanUtils.isNotEmpty((Object)instanceMap.get("startOrgName"))) {
                startOrgName = String.valueOf(instanceMap.get("startOrgName"));
            }
            FlowInstance instance = new FlowInstance();
            instance.setId(instId);
            instance.setInstanceId(instId);
            instance.setRemark("oa_query");
            instance.setFlowType(flowid);
            instance.setFlowTypeName(flowname);
            instance.setTitle(this.handTitle(requestname));
            instance.setFrom("oa");
            instance.setSystemCode("oa");
            instance.setSystemName("\u6cdb\u5faeOA");
            instance.setCreateTime(LocalDateTime.now());
            instance.setOwerId(startId);
            instance.setOwerNum(startnum);
            instance.setOwerAccount(startaccount);
            instance.setOwerName(startname);
            String instanceStatus = this.getInstanceStatus(status, processusercount);
            instance.setFlowStatus(instanceStatus);
            if (StringUtil.isNotEmpty((String)instanceStatus)) {
                instance.setFlowStatusName(this.getInstanceStatusName(instanceStatus));
            }
            instance.setOrgName(startOrgName);
            instance.setPcTaskUrl(String.format("%s?requestid=%s", this.pcTaskUrl, instId));
            instance.setMobileTaskUrl(String.format("%s?requestid=%s", this.mobileTaskUrl, instId));
            LocalDateTime flowStartDate = TimeUtil.getDateTimeByTimeString((String)String.format("%s %s", createdate, createtime));
            LocalDateTime updateDate = null;
            try {
                if (StringUtil.isNotEmpty((String)lastoperatedate) && !lastoperatedate.contains("null")) {
                    updateDate = TimeUtil.getDateTimeByTimeString((String)String.format("%s %s", lastoperatedate, lastoperatetime));
                    instance.setUpdateTime(updateDate);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            instance.setFlowStartDate(flowStartDate);
            if ("complete".equals(instanceStatus) && BeanUtils.isNotEmpty(updateDate)) {
                instance.setFlowCostSecond(Duration.between(flowStartDate, updateDate).getSeconds());
            }
            instances.add(instance);
        }
    }

    private String handTitle(String title) {
        if (StringUtil.isNotEmpty((String)title) && title.contains("~`~`7")) {
            title = title.replace("~`~`7 ", "");
            title = title.replace("`~`8 Notice Of  Meeting`~`9 \u6703\u8b70\u901a\u77e5`~`~", "");
            title = title.replace(" ~`~`7", "");
            title = title.replace("`~`8 Meeting Times`~`9 \u6703\u8b70\u6642\u9593`~`~", "");
            title = title.replace("`~`8 Meeting Location`~`9 \u6703\u8b70\u5730\u9ede`~`~", "");
            title = title.replace("~`~`7 \u4f1a\u8bae\u5730\u70b9`~`8 Meeting Location`~`9", "");
        }
        return title;
    }

    private String getInstanceStatusName(String status) {
        String name = "";
        switch (status) {
            case "approving": {
                name = "\u5ba1\u6279\u4e2d";
                break;
            }
            case "delete": {
                name = "\u5220\u9664";
                break;
            }
            case "cancel": {
                name = "\u4f5c\u5e9f";
                break;
            }
            case "complete": {
                name = "\u5b8c\u6210";
                break;
            }
            case "draft": {
                name = "\u8349\u7a3f";
                break;
            }
            case "refuse": {
                name = "\u9a73\u56de";
                break;
            }
            case "revoke": {
                name = "\u64a4\u56de";
            }
        }
        return name;
    }

    private String getInstanceStatus(String statuSstr, int processusercount) {
        String status = "";
        if (statuSstr.equals("0")) {
            status = processusercount > 0 ? "revoke" : "draft";
        } else if (statuSstr.equals("1") || statuSstr.equals("2")) {
            status = "approving";
        } else if (statuSstr.equals("3")) {
            status = "complete";
        }
        return status;
    }
}

