/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.service.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.activemq.todo.service.TodoMessageHandler;
import com.hotent.base.exception.BaseException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.Log;
import com.hotent.todo.mq.MessageHandlerProcessor;
import com.hotent.todo.persistence.manager.LogManager;
import dm.jdbc.util.StringUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class TodoMessageHandlerProcessor
implements TodoMessageHandler {
    protected static final Logger logger = LoggerFactory.getLogger(MessageHandlerProcessor.class);
    private static final Map<String, MessageHandler> messageHandlerMap = new HashMap<String, MessageHandler>();
    public static final Pattern RETRY_REGEX = Pattern.compile("^retry-(\\d+)-(.*)$");
    public static final String RETRY_TOPIC_NAME = "delay-topic";
    public static final String RETRY_DING_TALK_TOPIC_NAME = "ding-talk-todo-topic";
    @Resource
    JmsProducer jmsProducer;
    @Value(value="${spring.rocketmq.max-retry-time:3}")
    Integer maxRetryTime;
    @Resource
    LogManager logManager;

    public void initial() {
        if (BeanUtils.isNotEmpty(messageHandlerMap)) {
            return;
        }
        List messageHandlerList = (List)AppUtil.getBean((String)"messageHandlerList");
        for (MessageHandler handler : messageHandlerList) {
            messageHandlerMap.put(handler.getType(), handler);
        }
    }

    public void process(String key, String message, String topic, long timestamp) {
        this.initial();
        String operatorType = "";
        String instanceId = "";
        String systemCode = "";
        String systemName = "";
        try {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)message);
            if (!jsonNode.isObject()) {
                throw new BaseException("\u6d88\u606f\u4e0d\u662f\u6709\u6548\u7684json\u683c\u5f0f");
            }
            ObjectNode obj = (ObjectNode)jsonNode;
            operatorType = JsonUtil.getString((JsonNode)obj, (String)"operatorType");
            instanceId = JsonUtil.getString((JsonNode)obj, (String)"instanceId");
            systemCode = JsonUtil.getString((JsonNode)obj, (String)"systemCode");
            systemName = JsonUtil.getString((JsonNode)obj, (String)"systemName");
            AccessSystem accessSystem = new AccessSystem();
            accessSystem.setSystemCode(systemCode);
            accessSystem.setSystemName(systemName);
            MessageHandler messageHandler = messageHandlerMap.get(operatorType);
            messageHandler.handler(obj, topic, accessSystem);
            this.recordLog(true, operatorType, message, timestamp, "", systemCode, systemName, instanceId);
        }
        catch (MessageShouldRetryException e) {
            try {
                this.retryHandler(key, message, topic, RETRY_TOPIC_NAME);
            }
            catch (Exception ex) {
                this.recordLog(false, operatorType, message, timestamp, e.getMessage(), systemCode, systemName, instanceId);
            }
        }
        catch (Exception e) {
            this.recordLog(false, operatorType, message, timestamp, e.getMessage(), systemCode, systemName, instanceId);
        }
    }

    private void retryHandler(String key, String message, String topic, String retryTopicName) throws Exception {
        Matcher regexMatcher;
        int retryTime = 0;
        if (StringUtil.isNotEmpty((String)key) && (regexMatcher = RETRY_REGEX.matcher(key)).find()) {
            String timeStr = regexMatcher.group(1);
            retryTime = Integer.parseInt(timeStr);
        }
        if (retryTime >= this.maxRetryTime) {
            throw new BaseException("\u6d88\u606f\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u4e86");
        }
        String retryKey = String.format("retry-%s-%s", ++retryTime, topic);
        this.jmsProducer.sendToTopic(retryKey, (Object)message, retryTopicName);
    }

    private void recordLog(boolean isSuccess, String messageType, String message, long timestamp, String result, String systemCode, String systemName, String instanceId) {
        Log log = new Log();
        log.setStatus(isSuccess ? "1" : "0");
        log.setVersion(1);
        log.setInstanceId(instanceId);
        log.setMessageType(messageType);
        log.setMessageBody(message);
        log.setTimestamp(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()));
        log.setResult(result);
        log.setFromSystemCode(systemCode);
        log.setFromSystemName(systemName);
        this.logManager.create((Model)log);
    }
}

