/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.util;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.todo.model.FlowTypeTree;
import com.hotent.todo.model.OperateLog;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class TodoUtil {
    private static final Logger logger = LoggerFactory.getLogger(TodoUtil.class);

    public static IUser getUser(String account, String userName) {
        IUser user = new IUser(){
            private static final long serialVersionUID = -3279144470311301256L;
            String account = "";
            String fullName = "";

            public String getIdentityType() {
                return null;
            }

            public void setUserId(String userId) {
            }

            public void setFullname(String fullName) {
                this.fullName = fullName;
            }

            public void setAccount(String account) {
                this.account = account;
            }

            public String getUserId() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public String getMobile() {
                return null;
            }

            public String getFullname() {
                return this.fullName;
            }

            public String getEmail() {
                return null;
            }

            public String getAccount() {
                return this.account;
            }

            public void setAttributes(Map<String, String> map) {
            }

            public Map<String, String> getAttributes() {
                return null;
            }

            public boolean isAdmin() {
                return false;
            }

            public String getAttrbuite(String key) {
                return "";
            }

            public String getPhoto() {
                return null;
            }

            public String getWeixin() {
                return null;
            }

            public Integer getHasSyncToWx() {
                return null;
            }

            public boolean isEnable() {
                return true;
            }

            public Collection<GrantedAuthority> getAuthorities() {
                return null;
            }

            public String getUsername() {
                return null;
            }

            public boolean isAccountNonExpired() {
                return false;
            }

            public boolean isAccountNonLocked() {
                return false;
            }

            public boolean isCredentialsNonExpired() {
                return false;
            }

            public boolean isEnabled() {
                return false;
            }

            public Integer getStatus() {
                return null;
            }

            public String getTenantId() {
                return null;
            }

            public LocalDateTime getPwdCreateTime() {
                return null;
            }

            public LocalDate getExpireDate() {
                return null;
            }

            public String getClientId() {
                return null;
            }

            public String getClientToken() {
                return null;
            }

            public LocalDate getEntryDate() {
                return null;
            }
        };
        user.setFullname(userName);
        user.setAccount(account);
        return user;
    }

    public static String addBackParam(String url) {
        if (StringUtil.isNotEmpty((String)url)) {
            url = url.contains("?") ? url + "&msgType=dingMsg" : url + "?msgType=dingMsg";
        }
        return url;
    }

    public static boolean isInMsgWhiteList(String msgWhiteList, String sysCode) {
        if (StringUtil.isNotEmpty((String)msgWhiteList)) {
            HashSet whiteListSet = new HashSet();
            Collections.addAll(whiteListSet, msgWhiteList.split(","));
            if (whiteListSet.contains(sysCode)) {
                return true;
            }
        }
        return false;
    }

    public static List<String> getAuthSystem() {
        return null;
    }

    public static List<List<String>> decomposeList(List<String> ids, int length) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int size = ids.size();
        boolean isOk = false;
        int i = 0;
        while (!isOk) {
            List<String> newIds;
            int o = i * length;
            int p = (i + 1) * length;
            if (p > size) {
                p = size;
                isOk = true;
            }
            if (BeanUtils.isEmpty(newIds = ids.subList(o, p))) {
                isOk = true;
            } else {
                result.add(newIds);
            }
            ++i;
        }
        return result;
    }

    public static String getInSql(List<String> ids, int length, String column, String inOrNotIn) {
        List<List<String>> newList = TodoUtil.decomposeList(ids, length);
        StringBuffer sql = new StringBuffer();
        sql.append(" ( ");
        StringBuffer sql1 = new StringBuffer();
        for (List<String> list : newList) {
            if (sql1.length() != 0) {
                if ("NOT IN".equals(inOrNotIn.toUpperCase())) {
                    sql1.append(" and ");
                } else {
                    sql1.append(" or ");
                }
            }
            sql1.append(column);
            sql1.append(" ");
            sql1.append(inOrNotIn);
            sql1.append("(");
            StringBuffer sql2 = new StringBuffer();
            for (String id : list) {
                if (sql2.length() == 0) {
                    sql2.append("'");
                    sql2.append(id);
                    sql2.append("'");
                    continue;
                }
                sql2.append(",'" + id);
                sql2.append("'");
            }
            sql1.append(sql2);
            sql1.append(" )  ");
        }
        sql.append(sql1);
        sql.append(" )");
        return sql.toString();
    }

    public static void addOperatIgnoreLowLog(String operateType, String type, String ids, boolean ignore, String modifReason) {
        try {
            String typeMsg;
            IUser user = ContextUtil.getCurrentUser();
            OperateLog log = new OperateLog();
            log.setId(UniqueIdUtil.getSuid());
            log.setCreator(user.getFullname());
            log.setCreateBy(user.getUserId());
            log.setOperateType("ignoreLow");
            log.setOperateType(operateType);
            String string = typeMsg = "task".equals(type) ? "\u5f85\u529e" : "\u5df2\u529e";
            if (!ignore) {
                typeMsg = typeMsg + "\u53d6\u6d88";
            }
            String msg = String.format("\u7528\u6237\uff1a%s\uff0c\u5c06id\u4e3a%s\u7684%s\u8bbe\u7f6e\u4e0d\u8ba1\u8d85\u65f6\u3002\u64cd\u4f5c\u539f\u56e0\uff1a%s", user.getFullname(), ids, typeMsg, modifReason);
            log.setMessage(msg);
        }
        catch (Exception e) {
            logger.error("\u5ffd\u7565\u8d85\u65f6\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static List<FlowTypeTree> transTypeTree(List<Map<String, String>> types) {
        ArrayList<FlowTypeTree> list = new ArrayList<FlowTypeTree>();
        if (BeanUtils.isNotEmpty(types)) {
            HashSet typeCodes;
            ArrayList flowList = new ArrayList();
            ArrayList taskList = new ArrayList();
            types.forEach(type -> {
                if ("flow".equals(type.get("model"))) {
                    flowList.add(type);
                } else if ("task".equals(type.get("model"))) {
                    taskList.add(type);
                }
            });
            if (BeanUtils.isNotEmpty(flowList)) {
                typeCodes = new HashSet();
                flowList.forEach(flow -> {
                    String typeCode = (String)flow.get("typeCode");
                    if (StringUtil.isNotEmpty((String)typeCode) && !typeCodes.contains(typeCode)) {
                        typeCodes.add(typeCode);
                        FlowTypeTree tree = new FlowTypeTree();
                        tree.setId((String)flow.get("model") + "_" + typeCode);
                        tree.setTypeCode(typeCode);
                        tree.setTypeName((String)flow.get("typeName"));
                        tree.setModel((String)flow.get("model"));
                        tree.setChildren(TodoUtil.getTypeTreeChildren(tree, flowList));
                        tree.setExpand(true);
                        tree.setLevel(1);
                        list.add(tree);
                    }
                });
            }
            if (BeanUtils.isNotEmpty(taskList)) {
                typeCodes = new HashSet();
                taskList.forEach(task -> {
                    String typeCode = (String)task.get("typeCode");
                    if (StringUtil.isNotEmpty((String)typeCode) && !typeCodes.contains(typeCode)) {
                        typeCodes.add(typeCode);
                        FlowTypeTree tree = new FlowTypeTree();
                        tree.setId((String)task.get("model") + "_" + typeCode);
                        tree.setTypeCode(typeCode);
                        tree.setTypeName((String)task.get("typeName"));
                        tree.setModel((String)task.get("model"));
                        tree.setChildren(TodoUtil.getTypeTreeChildren(tree, taskList));
                        tree.setExpand(true);
                        tree.setLevel(1);
                        list.add(tree);
                    }
                });
            }
        }
        return list;
    }

    private static List<FlowTypeTree> getTypeTreeChildren(FlowTypeTree pTree, List<Map<String, String>> list) {
        ArrayList<FlowTypeTree> treeList = new ArrayList<FlowTypeTree>();
        list.forEach(f -> {
            if (pTree.getTypeCode().equals(f.get("typeCode"))) {
                FlowTypeTree tree = new FlowTypeTree();
                tree.setId(pTree.getId() + "_" + (String)f.get("flowCode"));
                tree.setTypeCode(pTree.getTypeCode());
                tree.setTypeName(pTree.getTypeName());
                tree.setModel(pTree.getModel());
                tree.setFlowCode((String)f.get("flowCode"));
                tree.setFlowName((String)f.get("flowName"));
                tree.setExpand(false);
                tree.setLevel(2);
                treeList.add(tree);
            }
        });
        if (BeanUtils.isNotEmpty(treeList)) {
            BeanUtils.removeDuplicate(treeList);
        }
        return treeList;
    }
}

