/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.context;

import com.hotent.base.annotation.IgnoreOnAssembly;
import com.hotent.base.context.BaseContext;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@IgnoreOnAssembly
@Primary
public class UcimplContext
implements BaseContext,
ContextThread {
    private ThreadLocal<String> tempTenantId = new ThreadLocal();

    public void setTempTenantId(String tenantId) {
        this.tempTenantId.set(tenantId);
    }

    public void clearTempTenantId() {
        this.tempTenantId.remove();
    }

    public boolean hasTempTenant() {
        return BeanUtils.isNotEmpty((Object)this.tempTenantId.get());
    }

    public String getCurrentUserId() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentUserId();
    }

    public String getCurrentUserAccout() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentUser().getAccount();
    }

    public String getCurrentUserFullname() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUser().getFullname();
    }

    public String getCurrentOrgId() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentGroupId();
    }

    public String getCurrentTenantId() {
        String tempTenantId = this.tempTenantId.get();
        if (StringUtil.isNotEmpty((String)tempTenantId)) {
            return tempTenantId;
        }
        String tenantId = HttpUtil.getTenantId();
        if (BeanUtils.isNotEmpty((Object)tenantId)) {
            return tenantId;
        }
        if (this.authenticationEmpty()) {
            return "-1";
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return "-1";
        }
        return currentUser.getTenantId();
    }

    private boolean authenticationEmpty() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return BeanUtils.isEmpty((Object)authentication) || authentication instanceof AnonymousAuthenticationToken;
    }

    public void cleanAll() {
        this.clearTempTenantId();
    }
}

