/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.Org;
import com.hotent.uc.api.impl.model.OrgJob;
import com.hotent.uc.api.impl.model.OrgRel;
import com.hotent.uc.api.impl.model.Role;
import com.hotent.uc.api.model.Group;
import com.hotent.uc.api.model.GroupType;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IUserGroupService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class DefaultUserGroupService
implements IUserGroupService {
    @Resource
    UCFeignService ucFeignService;

    public List<GroupType> getGroupTypes() {
        ArrayList<GroupType> list = new ArrayList<GroupType>();
        for (GroupTypeConstant e : GroupTypeConstant.values()) {
            GroupType type = new GroupType(e.key(), e.label());
            list.add(type);
        }
        return list;
    }

    public IGroup getGroupByIdOrCode(String groupType, String code) {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        try {
            CommonResult commonResult;
            if (groupType.equals(GroupTypeConstant.ORG.key()) && BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getOrgByIdOrCode(code)))) {
                return (IGroup)JsonUtil.toBean((JsonNode)result, Org.class);
            }
            if (groupType.equals(GroupTypeConstant.ROLE.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getRoleByIdOrCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), Role.class);
            }
            if (groupType.equals(GroupTypeConstant.POSITION.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getPostByIdOrCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), OrgRel.class);
            }
            if (groupType.equals(GroupTypeConstant.JOB.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getJobByOrgCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), OrgJob.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<? extends IGroup> getGroupsByIdsOrCodes(String groupType, List<String> idsOrCodes) {
        try {
            ArrayNode value;
            ArrayNode result;
            if (groupType.equals(GroupTypeConstant.ORG.key()) && BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getOrgsByIdsOrCodes(String.join((CharSequence)",", idsOrCodes))))) {
                return (List)JsonUtil.toBean((JsonNode)result, (TypeReference)new TypeReference<List<Org>>(){});
            }
            if (groupType.equals(GroupTypeConstant.ROLE.key()) && BeanUtils.isNotEmpty((Object)(value = this.ucFeignService.getRolesByIdsOrCodes(String.join((CharSequence)",", idsOrCodes))))) {
                return (List)JsonUtil.toBean((JsonNode)value, (TypeReference)new TypeReference<List<Role>>(){});
            }
            if (groupType.equals(GroupTypeConstant.POSITION.key()) && BeanUtils.isNotEmpty((Object)(value = this.ucFeignService.getPostsByIdsOrCodes(String.join((CharSequence)",", idsOrCodes))))) {
                return (List)JsonUtil.toBean((JsonNode)value, (TypeReference)new TypeReference<List<OrgRel>>(){});
            }
            if (groupType.equals(GroupTypeConstant.JOB.key()) && BeanUtils.isNotEmpty((Object)(value = this.ucFeignService.getJobsByIdsOrCodes(String.join((CharSequence)",", idsOrCodes))))) {
                return (List)JsonUtil.toBean((JsonNode)value, (TypeReference)new TypeReference<List<OrgJob>>(){});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<IGroup> getGroupsByUserIdOrAccount(String groupType, String userId) {
        ArrayList<IGroup> listMap = new ArrayList<IGroup>();
        List groupIdsByUserId = this.ucFeignService.getGroupsByUidAndType(userId, groupType);
        for (Group group : groupIdsByUserId) {
            listMap.add((IGroup)group);
        }
        return listMap;
    }

    public List<IGroup> getGroupsByUserIdOrAccount(String account) {
        ArrayList<IGroup> listMap = new ArrayList<IGroup>();
        List groupIdsByUserId = this.ucFeignService.getGroupsByUidAndType(account, "all");
        for (Group group : groupIdsByUserId) {
            listMap.add((IGroup)group);
        }
        return listMap;
    }

    public Map<String, List<IGroup>> getGroupsMapUserIdOrAccount(String id) {
        List<IGroup> groups = this.getGroupsByUserIdOrAccount(id);
        HashMap<String, List<IGroup>> map = new HashMap<String, List<IGroup>>();
        if (BeanUtils.isEmpty(groups)) {
            return map;
        }
        for (IGroup group : groups) {
            String type = group.getGroupType();
            List list = null;
            list = map.containsKey(type) ? (List)map.get(type) : new ArrayList();
            list.add(group);
            map.put(type, list);
        }
        return map;
    }

    public List<IGroup> getSubGroupByIdOrCode(String parentId) {
        List orgs = this.ucFeignService.getOrgsByparentId(parentId);
        if (BeanUtils.isEmpty((Object)orgs)) {
            return new ArrayList<IGroup>();
        }
        ArrayList<IGroup> groups = new ArrayList<IGroup>();
        try {
            for (ObjectNode jsonOrg : orgs) {
                groups.add((IGroup)JsonUtil.toBean((JsonNode)jsonOrg, Org.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return groups;
    }
}

