/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.service;

import com.hotent.uc.api.impl.model.UserFacade;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.util.Assert;

public class UCCachingUserDetailsService
implements UserDetailsService {
    private UserCache userCache = new NullUserCache();
    private final UserDetailsService delegate;

    public UCCachingUserDetailsService(UserDetailsService delegate) {
        this.delegate = delegate;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserDetails loadUserByUsername(String username) {
        UserFacade user = (UserFacade)this.userCache.getUserFromCache(username);
        if (user == null) {
            user = (UserFacade)this.delegate.loadUserByUsername(username);
        }
        Assert.notNull((Object)user, (String)("UserDetailsService " + this.delegate + " returned null for username " + username + ". This is an interface contract violation"));
        this.userCache.putUserInCache((UserDetails)user);
        return user;
    }
}

