/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.JsonUtil;
import com.hotent.uc.api.impl.model.UserFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class UCRestUserDetailsServiceImpl
implements UserDetailsService {
    private static final Log logger = LogFactory.getLog(UCRestUserDetailsServiceImpl.class);
    private UCFeignService ucFeignService;

    public UCRestUserDetailsServiceImpl(UCFeignService ucFeignService) {
        this.ucFeignService = ucFeignService;
        Assert.notNull((Object)this.ucFeignService, (String)"RestInvoker could not be empty.");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            JsonNode result = this.ucFeignService.loadUserByUsername(username);
            UserFacade user = (UserFacade)JsonUtil.toBean((JsonNode)result, UserFacade.class);
            return user;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
    }
}

