/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.impl.service.UserCacheImpl;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Primary
@Service
public class UserServiceImpl
implements IUserService {
    private static final Log logger = LogFactory.getLog(UserServiceImpl.class);
    @Resource
    UCFeignService ucFeignService;
    @Resource
    UserCacheImpl userCacheImpl;

    private ObjectNode getObjectNode() {
        return JsonUtil.getMapper().createObjectNode();
    }

    public IUser getUserById(String userId) {
        try {
            UserFacade userfacade = this.userCacheImpl.getUserFromCacheById(userId);
            if (userfacade != null) {
                return userfacade;
            }
            CommonResult ObjectNode2 = this.ucFeignService.loadUserByUserId(userId);
            if (ObjectNode2.getState().booleanValue()) {
                userfacade = (UserFacade)JsonUtil.toBean((JsonNode)((JsonNode)ObjectNode2.getValue()), UserFacade.class);
                this.userCacheImpl.putUserInCache((UserDetails)userfacade);
                return userfacade;
            }
            logger.error((Object)("\u6839\u636e\u7528\u6237id\u65e0\u6cd5\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f-" + (StringUtil.isEmpty((String)userId) ? "" : userId)));
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public IUser getUserByAccount(String account) {
        try {
            JsonNode result = this.ucFeignService.getUser(account, "");
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            UserFacade bean = (UserFacade)JsonUtil.toBean((JsonNode)result, UserFacade.class);
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserByAccounts(String accounts) {
        ObjectNode params = this.getObjectNode();
        params.put("accounts", accounts);
        try {
            ArrayNode node = this.ucFeignService.getUserByAccounts(accounts);
            ArrayList<IUser> bean = new ArrayList<IUser>();
            for (JsonNode j : node) {
                bean.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserListByGroup(String groupType, String groupId, String groupCode) {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        if (groupType.equals(GroupTypeConstant.ORG.key())) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            if (StringUtil.isNotEmpty((String)groupId) || groupId.split(",").length > 1) {
                queryFilter.addFilter("org_id_", Arrays.asList(groupId.split(",")), QueryOP.IN);
            } else {
                queryFilter.addFilter("org_id_", (Object)groupId, QueryOP.EQUAL);
            }
            result = this.ucFeignService.getAllOrgUsers(queryFilter);
        }
        if (groupType.equals(GroupTypeConstant.ROLE.key())) {
            result = this.ucFeignService.getUsersByRoleCode(StringUtil.isEmpty((String)groupCode) ? groupId : groupCode);
        }
        if (groupType.equals(GroupTypeConstant.POSITION.key()) || groupType.equals(GroupTypeConstant.POST.key())) {
            result = this.ucFeignService.getUserByPost(groupId);
        }
        if (groupType.equals(GroupTypeConstant.JOB.key())) {
            result = this.ucFeignService.getUsersByJob(groupId);
        }
        if (BeanUtils.isEmpty((Object)result)) {
            return new ArrayList<IUser>();
        }
        List list = null;
        try {
            list = (List)JsonUtil.toBean((String)(!groupType.equals(GroupTypeConstant.ORG.key()) ? JsonUtil.toJson((Object)result) : JsonUtil.toJson((Object)result.get("rows"))), (TypeReference)new TypeReference<List<UserFacade>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<IUser> Ilist = new ArrayList<IUser>();
        for (UserFacade user : list) {
            Ilist.add(user);
        }
        return Ilist;
    }

    public List<IUser> getByEmail(String email) {
        ObjectNode params = this.getObjectNode();
        params.put("email", email);
        List list = null;
        try {
            ArrayNode result = this.ucFeignService.getUserByEmail(email);
            list = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)result), (TypeReference)new TypeReference<List<UserFacade>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<IUser> Ilist = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (UserFacade user : list) {
                Ilist.add(user);
            }
        }
        return Ilist;
    }

    public IUser getSuperior(String underId, String demId) {
        try {
            JsonNode result = this.ucFeignService.getSuperior(underId, demId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            UserFacade bean = (UserFacade)JsonUtil.toBean((JsonNode)result, UserFacade.class);
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getMainPostOrOrgByUserId(String startId) {
        try {
            ObjectNode result = this.ucFeignService.getMainPostOrOrgByUserId(startId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getSuperiorPost(String userId) {
        try {
            JsonNode result = this.ucFeignService.getSuperiorPost(userId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserByIds(String userIds) {
        try {
            ArrayNode ObjectNode2 = this.ucFeignService.getUserByIds(userIds);
            ArrayList<IUser> bean = new ArrayList<IUser>();
            if (BeanUtils.isNotEmpty((Object)ObjectNode2)) {
                for (JsonNode j : ObjectNode2) {
                    bean.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

