/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.api.impl.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IPermission;
import com.hotent.uc.api.util.IPermissionCalc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionCalc
implements IPermissionCalc {
    private Map<String, IPermission> permissionMap = new HashMap<String, IPermission>();
    private List<IPermission> permissionList = new ArrayList<IPermission>();

    public void setPermissionList(List<IPermission> iPermissions) {
        for (IPermission permission : iPermissions) {
            this.permissionMap.put(permission.getType(), permission);
        }
        this.permissionList = iPermissions;
    }

    public IPermission getPermission(String type) {
        return this.permissionMap.get(type);
    }

    public Map<String, Set<String>> getCurrentProfiles() {
        PermissionCalc permissionCalc = (PermissionCalc)AppUtil.getBean(PermissionCalc.class);
        return permissionCalc.getCurrentProfilesCache(ContextUtil.getCurrentUserId());
    }

    @Cacheable(value={"eip:uc:currentProfiles"}, key="#userId")
    public Map<String, Set<String>> getCurrentProfilesCache(String userId) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (IPermission permission : this.permissionList) {
            Set set = permission.getCurrentProfile();
            if (BeanUtils.isEmpty((Object)set)) continue;
            map.put(permission.getType(), set);
        }
        return map;
    }

    public boolean hasRight(String json, Map<String, Set<String>> currentMap) throws IOException {
        JsonNode jsonObj = JsonUtil.toJsonNode((String)json);
        String type = jsonObj.get("type").asText();
        IPermission permission = this.getPermission(type);
        return permission.hasRight(json, currentMap);
    }
}

