/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.aop;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.annotation.CheckExit;
import com.hotent.uc.annotation.TableAlias;
import com.hotent.uc.model.UcBaseModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CheckExitAspect {
    @Resource
    CommonManager commonManager;
    @Resource
    BaseContext baseContext;

    @Around(value="execution(* *..*Controller.*(..))  && @annotation(com.hotent.uc.annotation.CheckExit)")
    public Object workflow(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Object[] args = joinPoint.getArgs();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        CheckExit checkExit = method.getAnnotation(CheckExit.class);
        LocalVariableTableParameterNameDiscoverer localVariableTable = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = localVariableTable.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        String alias = checkExit.alias();
        if (alias.matches("^#.*.$")) {
            alias = (String)parser.parseExpression(alias).getValue((EvaluationContext)context, String.class);
        }
        Class<? extends UcBaseModel> currentModelClass = checkExit.modelClass();
        List allField = ReflectUtil.getAllField(currentModelClass);
        TableField aliasField = null;
        TableField logicField = null;
        String aliasDesc = "";
        for (Field f : allField) {
            if (f.getAnnotation(TableAlias.class) != null) {
                aliasField = f.getAnnotation(TableField.class);
                aliasDesc = f.getAnnotation(ApiModelProperty.class).notes();
            }
            if (f.getAnnotation(TableLogic.class) == null) continue;
            logicField = f.getAnnotation(TableField.class);
        }
        if (StringUtil.isEmpty((String)alias)) {
            return CommonResult.error((String)String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", aliasDesc));
        }
        if (aliasField == null) {
            return CommonResult.error((String)"\u672a\u627e\u5230\u522b\u540d\u5b57\u6bb5\uff0c\u65e0\u6cd5\u6267\u884c\u5224\u65ad\u662f\u5426\u5b58\u5728");
        }
        TableName tableName = currentModelClass.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new BaseException("\u672a\u627e\u5230\u8868\u540d\uff0c\u65e0\u6cd5\u6267\u884c\u5224\u65ad\u662f\u5426\u5b58\u5728");
        }
        QueryFilter filter = QueryFilter.build();
        filter.addFilter(aliasField.value(), (Object)alias, QueryOP.EQUAL);
        HttpServletRequest request = HttpUtil.getRequest();
        PageList query = new PageList();
        if (BeanUtils.isNotEmpty((Object)request) && StringUtil.isNotEmpty((String)request.getParameter("tenantId"))) {
            this.baseContext.setTempTenantId(request.getParameter("tenantId"));
            query = this.commonManager.query(String.format("select * from %s ", tableName.value()), filter);
            this.baseContext.setTempTenantId(null);
        } else {
            query = this.commonManager.query(String.format("select * from %s ", tableName.value()), filter);
        }
        this.baseContext.setTempTenantId(null);
        List list = query.getRows();
        if (BeanUtils.isEmpty((Object)list)) {
            return joinPoint.proceed();
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Map l = (Map)iterator.next();
            if (logicField != null && "1".equals(MapUtil.getIgnoreCase((Map)l, (String)logicField.value()))) {
                CommonResult message = CommonResult.ok().message(String.format("%s[%s]\u5df2\u5b58\u5728\u5e76\u88ab\u5220\u9664\uff0c\u662f\u5426\u6062\u590d\uff1f", aliasDesc, alias));
                message.setErrorCode(ResponseErrorEnums.DATA_EXIST.getCode());
                return message;
            }
            return CommonResult.error((String)String.format("%s[%s]\u5df2\u7ecf\u5b58\u5728\uff01", aliasDesc, alias));
        }
        return joinPoint.proceed();
    }
}

