/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.DataPermission;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.annotation.CheckExit;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.User;
import com.hotent.uc.params.role.RoleVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/api/role/v1/"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class RoleController
extends UcBaseController<RoleManager, Role> {
    @Resource
    RoleManager roleService;
    @Autowired
    UserManager userService;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    DatabaseContext databaseContext;

    @RequestMapping(value={"roles/getRolePage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @DataPermission
    public PageList<Role> getRolePage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        PageList list = this.roleService.query(filter);
        return list;
    }

    @RequestMapping(value={"roles/getEnableRolePage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @DataPermission
    public PageList<Role> getEnableRolePage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        filter.addFilter("ENABLED_", (Object)0, QueryOP.NOT_EQUAL);
        PageList list = this.roleService.query(filter);
        return list;
    }

    @RequestMapping(value={"roles/getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u89d2\u8272", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u89d2\u8272")
    public List<Role> getAll() throws Exception {
        return this.roleService.getAll();
    }

    @RequestMapping(value={"role/addRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272", httpMethod="POST", notes="\u6dfb\u52a0\u89d2\u8272")
    @CheckExit(alias="#role.code", modelClass=Role.class)
    public CommonResult<String> addRole(@ApiParam(name="role", value="\u89d2\u8272\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody RoleVo role) throws Exception {
        CommonResult<String> rtn = this.roleService.addRole(role);
        return rtn;
    }

    @RequestMapping(value={"role/deleteRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u5220\u9664\u89d2\u8272", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u89d2\u8272")
    @DataPermission
    public CommonResult<String> deleteRole(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.deleteRole(codes);
    }

    @RequestMapping(value={"role/deleteRoleByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u5220\u9664\u89d2\u8272", httpMethod="DELETE", notes="\u6839\u636e\u89d2\u8272id\u5220\u9664\u89d2\u8272")
    @DataPermission
    public CommonResult<String> deleteRoleByIds(@ApiParam(name="ids", value="\u89d2\u8272id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        return this.roleService.deleteRoleByIds(ids);
    }

    @RequestMapping(value={"role/updateRole"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272", httpMethod="PUT", notes="\u66f4\u65b0\u89d2\u8272")
    @UpdateMethod(type=RoleVo.class)
    @DataPermission
    public CommonResult<String> updateRole(@ApiParam(name="role", value="\u89d2\u8272\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody RoleVo role) throws Exception {
        return this.roleService.updateRole(role);
    }

    @RequestMapping(value={"role/getRole"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    public CommonResult<Role> getRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            return new CommonResult(false, "\u89d2\u8272\u7f16\u7801\u5fc5\u586b\uff01", null);
        }
        Role r = this.roleService.getByAlias(code);
        if (BeanUtils.isEmpty((Object)r)) {
            r = (Role)this.roleService.get((Serializable)((Object)code));
        }
        if (BeanUtils.isEmpty((Object)r)) {
            return new CommonResult(false, "\u6839\u636e\u8f93\u5165\u7684\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272", null);
        }
        return new CommonResult(true, "", (Object)r);
    }

    @RequestMapping(value={"roleUser/saveUserRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09")
    public CommonResult<String> saveUserRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String accounts) throws Exception {
        return this.roleService.saveUserRole(code, accounts);
    }

    @RequestMapping(value={"roleUser/saveUserRoles"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09")
    public CommonResult<String> saveUserRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String codes, @ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        return this.roleService.saveUserRoles(codes, account);
    }

    @RequestMapping(value={"roleUser/addUserRoleByOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7ec4\u7ec7\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7ec4\u7ec7\uff09")
    public CommonResult<String> addUserRoleByOrg(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String orgCodes) throws Exception {
        return this.roleService.addUserRoleByOrg(code, orgCodes);
    }

    @RequestMapping(value={"roleUser/deleteUserRole"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u79fb\u9664\u7528\u6237", httpMethod="DELETE", notes="\u89d2\u8272\u79fb\u9664\u7528\u6237")
    public CommonResult<String> deleteUserRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String accounts) throws Exception {
        return this.roleService.removeUserRole(code, accounts);
    }

    @RequestMapping(value={"role/getRolesByUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u89d2\u8272\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u89d2\u8272\u5217\u8868")
    public List<Role> getRolesByUser(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        return this.roleService.getListByAccount(account);
    }

    @RequestMapping(value={"role/getUsersByRoleCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\uff08\u591a\u4e2a\uff09\u4e2d\u7684\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\uff08\u591a\u4e2a\uff09\u4e2d\u7684\u7528\u6237")
    public List<UserVo> getUsersByRoleCode(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.getUsersByRoleCode(codes);
    }

    @RequestMapping(value={"role/deleteRolePhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u89d2\u8272\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u89d2\u8272\u6570\u636e")
    public CommonResult<Integer> deleteRolePhysical() throws Exception {
        Integer num = this.roleService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"role/deleteUserRolePhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e")
    public CommonResult<Integer> deleteUserRolePhysical() throws Exception {
        Integer num = this.userRoleService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"role/forbiddenRoles"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7981\u7528\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="PUT", notes="\u7981\u7528\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> forbiddenRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.forbiddenRoles(codes);
    }

    @RequestMapping(value={"role/activateRoles"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6fc0\u6d3b\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="PUT", notes="\u6fc0\u6d3b\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> activateRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.activateRoles(codes);
    }

    @RequestMapping(value={"roles/getRoleByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<Role> getRoleByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        return this.roleService.getRoleByTime(btime, etime);
    }

    @RequestMapping(value={"role/getRoleUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7528\u6237\uff08\u5206\u9875\uff09", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\u7528\u6237\uff08\u5206\u9875\uff09", hidden=false)
    public PageList<User> getRoleUsers(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter, @ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        filter.addFilter("r.CODE_", (Object)code, QueryOP.EQUAL, FieldRelation.AND, "group_code");
        Page list = (Page)this.userService.getRoleUserQuery(filter);
        return new PageList((IPage)list);
    }

    @RequestMapping(value={"role/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.roleService.isCodeExist(code);
    }

    @RequestMapping(value={"roles/getNotCodeAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u522b\u540d\u83b7\u53d6\u9664\u8fd9\u4e2a\u89d2\u8272\u4e4b\u5916\u7684\u6240\u6709\u89d2\u8272", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u89d2\u8272")
    public List<Role> getNotCodeAll(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.roleService.getOrgRoleListNotCode(code);
    }

    @RequestMapping(value={"roles/importRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u5bfc\u5165", httpMethod="POST", notes="\u89d2\u8272\u5bfc\u5165")
    public CommonResult<String> importRole(@ApiParam(name="request", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") MultipartHttpServletRequest request) throws Exception {
        CommonResult<String> res = this.roleService.importRole(request);
        return res;
    }

    @RequestMapping(value={"roles/importRoleData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u5bfc\u5165", httpMethod="POST", notes="\u89d2\u8272\u5bfc\u5165")
    public CommonResult<String> importRoleData(@ApiParam(name="request", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") MultipartHttpServletRequest request, @ApiParam(name="status", value="status", required=true) @RequestParam String status) throws Exception {
        CommonResult<String> res = this.roleService.importRoleData(request, status);
        return res;
    }

    @RequestMapping(value={"roles/export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u5bfc\u51fa", httpMethod="GET", notes="\u89d2\u8272\u5bfc\u51fa")
    public void export(HttpServletResponse response, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        this.roleService.export(response, ids);
    }

    @RequestMapping(value={"roleUser/operatingUserRoles"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8f6c\u79fb\u3001\u590d\u5236\u89d2\u8272\u7ed9\u7528\u6237\uff08\u591a\u4e2a\u89d2\u8272\uff0c\u591a\u4e2a\u7528\u6237\uff09", httpMethod="POST", notes="\u8f6c\u79fb\u3001\u590d\u5236\u89d2\u8272\u7ed9\u7528\u6237\uff08\u591a\u4e2a\u89d2\u8272\uff0c\u591a\u4e2a\u7528\u6237\uff09")
    public CommonResult<String> operatingUserRoles(@ApiParam(name="map", value="\u53c2\u6570", required=true) @RequestBody Map<String, Object> map) throws Exception {
        return this.roleService.operatingUserRoles(map);
    }

    @RequestMapping(value={"roleUser/delUserRoles"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u9664\u7528\u6237\u6240\u5c5e\u7684\u6307\u5b9a\u89d2\u8272", httpMethod="DELETE", notes="\u79fb\u9664\u7528\u6237\u6240\u5c5e\u7684\u6307\u5b9a\u89d2\u8272")
    public CommonResult<String> delUserRoles(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String codes) throws Exception {
        this.userRoleService.removeUserRole(account, codes.split(","));
        return CommonResult.ok();
    }

    @RequestMapping(value={"role/getListByUserId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u89d2\u8272\u5217\u8868", httpMethod="POST", notes="\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    public List<Role> getListByUserId(@ApiParam(name="userId", value="\u7528\u6237ID", required=true) @RequestParam String userId) throws Exception {
        return this.roleService.getListByUserId(userId);
    }

    @RequestMapping(value={"role/getRoleIdByCodes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u89d2\u8272codes\u83b7\u53d6\u89d2\u8272ids", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u89d2\u8272codes\u83b7\u53d6\u89d2\u8272ids")
    public List<String> getRoleIdByCodes(@ApiParam(name="codes", value="\u7ec4\u7ec7codes") @RequestBody List<String> codes) {
        List<String> result = new ArrayList<String>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("CODE_", codes, QueryOP.IN);
        List roles = this.roleService.queryNoPage(queryFilter);
        if (BeanUtils.isNotEmpty((Object)roles)) {
            result = roles.stream().map(Role::getId).collect(Collectors.toList());
        } else if (BeanUtils.isNotEmpty(codes)) {
            result.add("nullValue");
        }
        return result;
    }

    @GetMapping(value={"role/restoreRoleByAlias/{alias}"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u6062\u590d\u89d2\u8272\u548c\u89d2\u8272\u7528\u6237\u5173\u7cfb")
    public CommonResult<String> restoreRoleByAlias(@ApiParam(name="alias", value="\u89d2\u8272\u522b\u540d") @PathVariable String alias) {
        return this.roleService.restoreByAlias(alias);
    }

    @RequestMapping(value={"role/getRolesByIdsOrCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public List<Role> getRolesByIdsOrCodes(@ApiParam(name="idsOrCodes", value="\u7ec4\u7ec7ids\u6216codes") @RequestParam(required=true) String idsOrCodes) throws Exception {
        return this.roleService.getByIdsOrCodes(idsOrCodes);
    }
}

