/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.TenantAuthManager;
import com.hotent.uc.model.TenantAuth;
import com.hotent.uc.params.tenant.TenantAuthAddObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantAuth/v1"})
@Api(tags={"\u79df\u6237\u5206\u7c7b\u7ba1\u7406\u5458"})
@ApiGroup(group={"group_uc"})
public class TenantAuthController
extends UcBaseController<TenantAuthManager, TenantAuth> {
    @Resource
    TenantAuthManager tenantAuthManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7ba1\u7406\u5458\u5217\u8868")
    public PageList<TenantAuth> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.tenantAuthManager.query(queryFilter);
    }

    @PostMapping(value={"/queryByTypeOrTenant"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7ba1\u7406\u5458\u5217\u8868")
    public PageList<TenantAuth> queryByTypeOrTenant(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.tenantAuthManager.queryByTypeAndTenantId(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e\u8be6\u60c5")
    public TenantAuth get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (TenantAuth)this.tenantAuthManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406\u5458\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantAuth", value="\u79df\u6237\u7ba1\u7406\u5458\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantAuth tenantAuth) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u7ba1\u7406\u5458\u6210\u529f";
        if (StringUtil.isEmpty((String)tenantAuth.getId())) {
            this.tenantAuthManager.create((Model)tenantAuth);
        } else {
            this.tenantAuthManager.update((Model)tenantAuth);
            msg = "\u66f4\u65b0\u79df\u6237\u7ba1\u7406\u5458\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406\u5458\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantAuthManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveTenantAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u79df\u6237\u7ba1\u7406\u5458\uff08\u6309\u7528\u6237\uff09", httpMethod="POST", notes="\u5206\u914d\u79df\u6237\u7ba1\u7406\u5458\uff08\u6309\u7528\u6237\uff09")
    public CommonResult<String> saveTenantAuth(@ApiParam(name="authAddObject", value="authAddObject", required=true) @RequestBody TenantAuthAddObject authAddObject) throws Exception {
        return this.tenantAuthManager.saveTenantAuth(authAddObject);
    }

    @RequestMapping(value={"deleteTenantAuth"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u9664\u79df\u6237\u7ba1\u7406\u5458", httpMethod="DELETE", notes="\u79fb\u9664\u79df\u6237\u7ba1\u7406\u5458")
    public CommonResult<String> deleteUserRole(@ApiParam(name="typeId", value="\u79df\u6237\u7c7b\u578bid", required=true) @RequestParam String typeId, @ApiParam(name="tenantId", value="\u79df\u6237id", required=false) @RequestParam Optional<String> tenantId, @ApiParam(name="userIds", value="\u7528\u6237ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String userIds) throws Exception {
        return this.tenantAuthManager.removeTenantAuth(typeId, tenantId.orElse(""), userIds);
    }
}

