/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.uc.manager.TenantIgnoreMenuManager;
import com.hotent.uc.model.TenantIgnoreMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantIgnoreMenu/v2"})
@Api(tags={"\u79df\u6237\u7981\u7528\u83dc\u5355\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class TenantIgnoreMenuController2
extends BaseController2<TenantIgnoreMenuManager, TenantIgnoreMenu> {
    @Resource
    TenantIgnoreMenuManager tenantIgnoreMenuManager;

    @GetMapping(value={"/getIgnoreMenuCodes"})
    @ApiOperation(value="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5")
    public CommonResult<List<String>> getIgnoreMenuCodes(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId) throws Exception {
        List<TenantIgnoreMenu> ignoreMenus = this.tenantIgnoreMenuManager.getByTenantId(tenantId);
        ArrayList<String> ignoreCodes = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(ignoreMenus)) {
            for (TenantIgnoreMenu menu : ignoreMenus) {
                ignoreCodes.add(menu.getMenuCode());
            }
        }
        return CommonResult.ok().value(ignoreCodes);
    }

    @PostMapping(value={"saveByTenantId"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e")
    public CommonResult<String> saveByTenantId(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId, @ApiParam(name="ignoreMenus", value="\u9700\u8981\u7981\u7528\u7684\u83dc\u5355\u522b\u540d\u5217\u8868", required=true) @RequestBody List<String> ignoreMenus) throws Exception {
        CommonResult<String> commonResult = this.tenantIgnoreMenuManager.saveByTenantId(tenantId, ignoreMenus);
        return CommonResultUtil.getResult(commonResult);
    }
}

