/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import cn.hutool.core.lang.Assert;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.TwoVerifyService;
import com.hotent.base.util.GoogleAuthenticator;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.TwoVerifyInfoVo;
import com.hotent.uc.manager.OneTimeCodeManager;
import com.hotent.uc.manager.TwoVerifyManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.OneTimeCode;
import com.hotent.uc.model.User;
import com.hotent.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/twoVerify/v1/"})
@Api(tags={"\u53cc\u56e0\u7d20\u8ba4\u8bc1\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class TwoVerifyController {
    @Autowired
    TwoVerifyService twoVerifyService;
    @Autowired
    UserManager userService;
    @Autowired
    TwoVerifyManager twoVerifyManager;
    @Autowired
    OneTimeCodeManager oneTimeCodeManager;

    @RequestMapping(value={"initTwoVerifyInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u83b7\u53d6\u521d\u59cb\u5316\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", httpMethod="GET", notes="\u7528\u6237\u83b7\u53d6\u521d\u59cb\u5316\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public CommonResult<TwoVerifyInfoVo> initTwoVerifyInfo() throws Exception {
        User user = ContextUtil.getCurrentUser();
        Assert.notNull((Object)user, (String)"\u83b7\u53d6\u7528\u6237\u5931\u8d25", (Object[])new Object[0]);
        return CommonResult.success((Object)this.twoVerifyService.initTwoVerifyInfo(user.getAccount(), null));
    }

    @RequestMapping(value={"getTwoVerifyInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u83b7\u53d6\u81ea\u5df1\u7ed1\u5b9a\u7684\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", httpMethod="GET", notes="\u7528\u6237\u83b7\u53d6\u81ea\u5df1\u7ed1\u5b9a\u7684\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public CommonResult<TwoVerifyInfoVo> getTwoVerifyInfo() throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)(user = this.userService.getByAccount(user.getAccount())).getTwoVerifySecret())) {
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_NOT_BIND);
        }
        TwoVerifyInfoVo twoVerifyInfoVo = this.twoVerifyService.initTwoVerifyInfo(user.getAccount(), user.getTwoVerifySecret());
        return CommonResult.success((Object)twoVerifyInfoVo);
    }

    @RequestMapping(value={"bindTwoStepVerifySecret"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", httpMethod="POST", notes="\u9a8c\u8bc1&\u7ed1\u5b9a\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public CommonResult<List<OneTimeCode>> bindTwoStepVerifySecret(@ApiParam(value="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801") @RequestParam String code, @ApiParam(value="\u53cc\u56e0\u7d20\u5bc6\u94a5") @RequestParam String secret) throws Exception {
        User user = ContextUtil.getCurrentUser();
        Assert.isTrue((boolean)GoogleAuthenticator.authcode((String)code, (String)secret), (String)ResponseErrorEnums.TWO_VERIFY_FAIL.getMessage(), (Object[])new Object[0]);
        user = (User)this.userService.getById((Serializable)((Object)user.getUserId()));
        List<OneTimeCode> oneTimeCodeList = this.twoVerifyManager.bindTwoStepVerifySecret(user, secret);
        return CommonResult.success(oneTimeCodeList);
    }

    @RequestMapping(value={"closeTwoStepVerify"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5173\u95ed\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", httpMethod="GET", notes="\u5173\u95ed\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public CommonResult<?> closeTwoStepVerify() throws Exception {
        User user = ContextUtil.getCurrentUser();
        this.twoVerifyManager.closeTwoStepVerify(user);
        return CommonResult.success((Object)"\u5173\u95ed\u6210\u529f");
    }

    @RequestMapping(value={"twoStepVerify"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u767b\u5f55\u9875\uff09", httpMethod="POST", notes="\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u767b\u5f55\u9875\uff09")
    public CommonResult twoStepVerify(@ApiParam(value="\u4e34\u65f6token") @RequestParam String token, @ApiParam(value="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801") @RequestParam String code) throws Exception {
        return this.twoVerifyManager.twoStepVerify(token, code);
    }

    @RequestMapping(value={"twoStepVerifyAndBind"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u767b\u5f55\u9875\u5f3a\u5236\u7ed1\u5b9a\uff09", httpMethod="POST", notes="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u767b\u5f55\u9875\u5f3a\u5236\u7ed1\u5b9a\uff09")
    public CommonResult twoStepVerifyAndBind(@ApiParam(value="\u4e34\u65f6token") @RequestParam String token, @ApiParam(value="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801") @RequestParam String code) throws Exception {
        return this.twoVerifyManager.twoStepVerifyAndBind(token, code);
    }
}

