/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.uc.dao.OrgJobRelationDao;
import com.hotent.uc.manager.OrgJobRelationManager;
import com.hotent.uc.model.OrgJobRelation;
import com.hotent.uc.params.org.OrgJobRelationVO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgJobRelationManagerImpl
extends BaseManagerImpl<OrgJobRelationDao, OrgJobRelation>
implements OrgJobRelationManager {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrgJobRelation(OrgJobRelationVO orgJobRelationVO) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrgJobRelation::getOrgId, (Object)orgJobRelationVO.getOrgId())).in(OrgJobRelation::getJobId, orgJobRelationVO.getJobIds());
        this.physicalDelete((Wrapper<OrgJobRelation>)wrapper);
        List jobRelations = orgJobRelationVO.getJobIds().stream().map(jobId -> {
            OrgJobRelation relation = new OrgJobRelation();
            relation.setJobId((String)jobId);
            relation.setOrgId(orgJobRelationVO.getOrgId());
            return relation;
        }).collect(Collectors.toList());
        this.saveBatch(jobRelations);
    }

    @Override
    public void physicalDelete(Wrapper<OrgJobRelation> wrapper) {
        ((OrgJobRelationDao)this.baseMapper).physicalDelete(wrapper);
    }

    @Override
    public void removeByJobIds(List<String> jobIds, String orgId) {
        if (BeanUtils.isEmpty(jobIds)) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrgJobRelation::getOrgId, (Object)orgId)).in(OrgJobRelation::getJobId, jobIds);
        this.physicalDelete((Wrapper<OrgJobRelation>)wrapper);
    }
}

