/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.cache.CacheManager;
import com.hotent.base.cache.ICache;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.CacheEvictUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.dao.OrgDao;
import com.hotent.uc.dao.OrgJobDao;
import com.hotent.uc.dao.OrgParamsDao;
import com.hotent.uc.dao.OrgPostDao;
import com.hotent.uc.dao.OrgUserDao;
import com.hotent.uc.dto.UserSeletorDto;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.ParamsManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UcOrgUniteManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserUnderManager;
import com.hotent.uc.manager.impl.RoleManagerImpl;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgAuth;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgParams;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.OrgTree;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.OrgUserPost;
import com.hotent.uc.model.Params;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.UcOrgUnite;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserUnder;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.group.GroupIdentity;
import com.hotent.uc.params.org.OrgAuthVo;
import com.hotent.uc.params.org.OrgJobVo;
import com.hotent.uc.params.org.OrgPostVo;
import com.hotent.uc.params.org.OrgTreeVo;
import com.hotent.uc.params.org.OrgUserVo;
import com.hotent.uc.params.org.OrgVo;
import com.hotent.uc.params.orgRole.OrgRoleVo;
import com.hotent.uc.params.orgRole.RoleOrgVo;
import com.hotent.uc.params.post.PostDueVo;
import com.hotent.uc.params.user.UserUnderVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.AuthFilterUtil;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import poi.util.ExcelUtil;

@Service
public class OrgManagerImpl
extends BaseManagerImpl<OrgDao, Org>
implements OrgManager {
    protected static Logger logger = LoggerFactory.getLogger(OrgManagerImpl.class);
    @Autowired
    OrgParamsManager orgParamsService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    UserUnderManager userUnderService;
    @Autowired
    UserUnderManager userUnderManager;
    @Autowired
    UserManager userService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    OrgPostDao orgPostDao;
    @Autowired
    OrgRoleManager orgRoleService;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    ParamsManager paramsSerivce;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    OrgJobDao orgJobDao;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgRoleManager orgRoleManager;
    @Autowired
    DemensionManager DemensionManager;
    @Autowired
    OrgParamsDao orgParamsDao;
    @Autowired
    OrgPostManager postService;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    DemensionManager demService;
    @Resource
    OrgUserDao orgUserDao;
    @Resource
    RoleManager roleManager;
    @Resource
    UserManager userManager;
    @Resource
    private UcOrgUniteManager ucOrgUniteManager;

    @Override
    public Org getByCode(String code) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Org::getCode, (Object)code);
        return (Org)((OrgDao)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<Org> getOrgListByUserId(String userId) {
        return ((OrgDao)this.baseMapper).getOrgListByUserId(userId);
    }

    @Override
    public List<Org> getOrgListByAccount(String account) throws Exception {
        User user = this.userService.getByAccount(account);
        return ((OrgDao)this.baseMapper).getOrgListByUserId(user.getId());
    }

    @Override
    @Cacheable(value={"eip:uc:userMainOrg"}, key="#demId + '-' + #userId")
    public Org getMainGroup(String userId, String demId) {
        Demension sysDemension;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)demId)) {
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)this.demensionService.get((Serializable)((Object)demId))) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)(sysDemension = this.demensionService.getByCode(demId)))) {
                demId = sysDemension.getId();
            }
        } else {
            sysDemension = this.demensionService.getDefaultDemension();
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)sysDemension)) {
                demId = sysDemension.getId();
            }
        }
        List<Org> list = ((OrgDao)this.baseMapper).getMainOrgListByUser(userId, StringUtil.isEmpty((String)demId) ? null : demId);
        if (com.hotent.base.util.BeanUtils.isEmpty(list)) {
            list = ((OrgDao)this.baseMapper).getOrgListByUserId(userId);
        }
        return com.hotent.base.util.BeanUtils.isEmpty(list) ? null : list.get(0);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        HashSet<String> childIds = new HashSet<String>();
        for (String id : ids) {
            List subList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(Org::getPath, (Object)(id + "."))).eq(UcBaseModel::getIsDelete, (Object)"0")).ne(Org::getId, (Object)id)).list();
            if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)subList)) continue;
            childIds.addAll(subList.stream().map(o -> o.getId()).collect(Collectors.toSet()));
        }
        childIds.addAll(Arrays.asList(ids));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.orgUserManager.lambdaQuery().in(OrgUser::getOrgId, childIds)).eq(OrgUser::getIsDelete, (Object)"0")).list();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)list)) {
            throw new com.hotent.base.exception.BaseException("\u5f53\u524d\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u5b58\u5728\u7528\u6237\uff0c\u8bf7\u5148\u79fb\u9664\u7528\u6237\u518d\u64cd\u4f5c");
        }
        super.removeByIds(ids);
        for (String id : ids) {
            this.orgParamsService.removeByOrgId(id);
            this.orgPostService.delByOrgId(id);
            this.orgUserService.delByOrgId(id);
            this.userUnderService.delByOrgId(id);
            this.orgAuthService.delByOrgId(id);
            this.ucOrgUniteManager.delByOrgId(id);
        }
        for (String childId : childIds) {
            this.remove((Serializable)((Object)childId));
            this.orgParamsService.removeByOrgId(childId);
            this.orgPostService.delByOrgId(childId);
            this.orgUserService.delByOrgId(childId);
            this.userUnderService.delByOrgId(childId);
            this.orgAuthService.delByOrgId(childId);
            this.ucOrgUniteManager.delByOrgId(childId);
        }
    }

    @Override
    @Transactional
    public void updateByOrg(Org org) throws SQLException {
        String extName = org.getPathName().substring(0, org.getPathName().indexOf("/" + org.getName()));
        String extId = org.getPath().substring(0, org.getPath().indexOf("." + org.getId()));
        this.update((Model)org);
        String[] ids = new String[]{org.getId()};
        List allList = this.getAll();
        ArrayList<Org> cList = new ArrayList<Org>();
        for (String id : ids) {
            OrgManagerImpl.getChild(allList, id, cList);
        }
        String[] childIds = new String[cList.size()];
        for (int i = cList.size() - 1; i >= 0; --i) {
            String id;
            childIds[i] = id = ((Org)cList.get(i)).getId();
            Org c = this.get((Serializable)((Object)id));
            if (c.getParentId().equals(org.getId())) {
                c.setPathName(org.getPathName() + "/" + c.getName());
                c.setPath(org.getPath() + c.getId() + ".");
                c.setDemId(org.getDemId());
            } else {
                String pName = org.getName();
                String pId = org.getId();
                Org p = this.get((Serializable)((Object)c.getParentId()));
                String pathName = p.getPathName().substring(p.getPathName().indexOf("/" + pName), p.getPathName().length()) + "/" + c.getName();
                String path = p.getPath().substring(p.getPath().indexOf("." + pId), p.getPath().length()) + c.getId() + ".";
                c.setPathName(extName + pathName);
                c.setPath(extId + path);
                c.setDemId(org.getDemId());
            }
            this.update((Model)c);
        }
    }

    @Override
    public List<Org> getByParentId(String parentId) {
        ArrayList<Org> rtnList = new ArrayList<Org>();
        List allList = this.getAll();
        return OrgManagerImpl.getChild(allList, parentId, rtnList);
    }

    public static List<Org> getChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            OrgManagerImpl.getChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    @Override
    public List<Org> getByOrgName(String orgName) {
        return ((OrgDao)this.baseMapper).getByOrgName(orgName);
    }

    @Override
    public List<Org> getByPathName(String pathName) {
        return ((OrgDao)this.baseMapper).getByPathName(pathName);
    }

    @Override
    public List<Org> getByPathNameAndDem(String pathName, String demId) {
        return ((OrgDao)this.baseMapper).getByPathNameAndDem(pathName, demId);
    }

    @Override
    public List<Org> getByParentAndDem(QueryFilter queryFilter) {
        PageBean noPage = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        return ((OrgDao)this.baseMapper).getByParentAndDem((IPage<Org>)this.convert2IPage(noPage), (Wrapper<Org>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
    }

    @Override
    public IPage<Org> getByParentAndDemPage(QueryFilter queryFilter) {
        return ((OrgDao)this.baseMapper).getByParentAndDem((IPage<Org>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Org>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public Org getByDemIdAndSonId(String demId, String sonId) {
        return ((OrgDao)this.baseMapper).getByDemIdAndSonId(demId, sonId);
    }

    @Override
    public List<Org> getMainOrgListByUser(String userId, String demId) {
        return ((OrgDao)this.baseMapper).getMainOrgListByUser(userId, demId);
    }

    @Override
    public List<Org> getOrgListByDemId(String demId) {
        return ((OrgDao)this.baseMapper).getOrgListByDemId(demId);
    }

    @Override
    public List<Org> getUserOrg(String userId, String demId, Boolean isMain) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)isMain)) {
            if (isMain.booleanValue()) {
                params.put("isMain", 1);
            } else {
                params.put("isMain", 0);
            }
        }
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
        }
        params.put("userId", userId);
        return ((OrgDao)this.baseMapper).getUserOrg(params);
    }

    @Override
    @Transactional
    public CommonResult<String> addOrg(OrgVo orgVo) throws Exception {
        if (StringUtil.isEmpty((String)orgVo.getName())) {
            throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u540d\u79f0\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)orgVo.getCode())) {
            throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (orgVo.getCode().contains(",")) {
            throw new com.hotent.base.exception.BaseException("\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)orgVo.getDemId())) {
            throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ef4\u5ea6id\u3010demId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (((OrgDao)this.baseMapper).getCountByCode(orgVo.getCode()) > 0) {
            throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801[" + orgVo.getCode() + "]\u5df2\u5b58\u5728\uff01");
        }
        Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)dem)) {
            throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId[" + orgVo.getDemId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        Org pOrg = null;
        if (!"0".equals(orgVo.getParentId()) && StringUtil.isNotEmpty((String)orgVo.getParentId())) {
            pOrg = this.get((Serializable)((Object)orgVo.getParentId()));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
                throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId[" + orgVo.getParentId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new com.hotent.base.exception.BaseException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
        }
        Org o = new Org();
        o.setId(UniqueIdUtil.getSuid());
        o.setCode(orgVo.getCode());
        o.setName(orgVo.getName());
        o.setDemId(orgVo.getDemId());
        if (StringUtils.isEmpty((CharSequence)orgVo.getParentId())) {
            o.setParentId("0");
        } else {
            o.setParentId(orgVo.getParentId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getGrade())) {
            o.setGrade(orgVo.getGrade());
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgVo.getOrderNo())) {
            o.setOrderNo(orgVo.getOrderNo());
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
            o.setPathName("/" + orgVo.getName());
            o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getShowStatus())) {
            o.setShowStatus(orgVo.getShowStatus());
        }
        o.setLimitNum((int)orgVo.getLimitNum());
        o.setExceedLimitNum((int)orgVo.getExceedLimitNum());
        this.create((Model)o);
        return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrg(String codes) throws Exception {
        String[] codeArr;
        if (StringUtils.isEmpty((CharSequence)codes)) {
            throw new com.hotent.base.exception.BaseException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u4ee3\u7801\u5fc5\u586b\uff01");
        }
        String message = "";
        for (String code : codeArr = codes.split(",")) {
            Org o = this.getByCode(code);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
                message = message + "\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b";
                continue;
            }
            String[] ids = new String[]{o.getId()};
            this.removeByIds(ids);
        }
        message = StringUtils.isEmpty((CharSequence)message) ? "\u5220\u9664\u7ec4\u7ec7\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u6210\u529f\uff0c\u5176\u4e2d" + message;
        return new CommonResult(true, message, (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrg(OrgVo orgVo) throws Exception {
        if (orgVo.getExceedLimitNum() == 1 && orgVo.getLimitNum() < orgVo.getNowNum()) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u4eba\u6570\u8d85\u51fa\u9650\u7f16\u4eba\u6570\uff01");
        }
        if (StringUtil.isEmpty((String)orgVo.getCode())) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgVo.getCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u3010" + orgVo.getCode() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
        if (StringUtil.isNotEmpty((String)orgVo.getDemId()) && com.hotent.base.util.BeanUtils.isEmpty((Object)dem)) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId\u3010" + orgVo.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        Org pOrg = null;
        if (StringUtil.isNotEmpty((String)orgVo.getParentId()) && !"0".equals(orgVo.getParentId())) {
            pOrg = this.get((Serializable)((Object)orgVo.getParentId()));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId\u3010" + orgVo.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (StringUtil.isNotEmpty((String)orgVo.getDemId()) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if (StringUtil.isNotEmpty((String)orgVo.getName())) {
            o.setName(orgVo.getName());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getGrade())) {
            o.setGrade(orgVo.getGrade());
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgVo.getOrderNo())) {
            o.setOrderNo(orgVo.getOrderNo());
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
            if (StringUtil.isNotEmpty((String)orgVo.getName())) {
                o.setPathName("/" + orgVo.getName());
            }
            if (StringUtil.isNotEmpty((String)orgVo.getDemId())) {
                o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
                o.setDemId(orgVo.getDemId());
                if ("0".equals(orgVo.getParentId())) {
                    o.setParentId("0");
                }
            }
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
            o.setDemId(orgVo.getDemId());
            o.setParentId(pOrg.getId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getShowStatus())) {
            o.setShowStatus(orgVo.getShowStatus());
        }
        o.setLimitNum((int)orgVo.getLimitNum());
        o.setExceedLimitNum((int)orgVo.getExceedLimitNum());
        this.updateByOrg(o);
        return new CommonResult(true, "\u7ec4\u7ec7\u66f4\u65b0\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public Org getOrg(String code) throws Exception {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801code\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(code);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        o = this.get((Serializable)((Object)o.getId()));
        String pId = o.getParentId();
        String demId = o.getDemId();
        Demension d = (Demension)this.demensionService.get((Serializable)((Object)demId));
        if (d != null && !StringUtil.isEmpty((String)d.getDemCode())) {
            o.setDemCode(d.getDemCode());
        }
        if ("0".equals(pId) || StringUtil.isEmpty((String)pId)) {
            o.setParentOrgName(d.getDemName());
        } else {
            o.setParentOrgName(this.get((Serializable)((Object)pId)).getName());
        }
        List<OrgParams> params = this.getOrgParams(o.getCode());
        if (com.hotent.base.util.BeanUtils.isNotEmpty(params)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (OrgParams param : params) {
                map.put(param.getAlias(), param.getValue());
            }
            o.setParams(map);
        }
        return o;
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrgParams(String orgCode, List<ObjectNode> params) throws Exception {
        if (StringUtils.isEmpty((CharSequence)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        this.orgParamsService.removeByOrgId(org.getId());
        for (ObjectNode o : params) {
            String key = o.get("alias").asText();
            Params p = this.paramsSerivce.getByAlias(key);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)p)) {
                throw new RuntimeException("\u3010" + key + "\u3011\u53c2\u6570key\u4e0d\u5b58\u5728\uff01");
            }
            if (p.getType().equals("2")) continue;
            throw new RuntimeException("\u3010" + key + "\u3011\u5bf9\u5e94\u7684\u3010\u7528\u6237\u7ec4\u7ec7\u6269\u5c55\u53c2\u6570\u3011\u7c7b\u578b\u4e0d\u662f\u3010\u7ec4\u7ec7\u53c2\u6570\u3011\u7c7b\u578b\uff01");
        }
        try {
            this.orgParamsService.saveParams(org.getId(), params);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("ORA-12899") > -1) {
                throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\u503c\u8fc7\u957f");
            }
            throw e;
        }
        return new CommonResult(true, "\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<OrgParams> getOrgParams(String orgCode) throws Exception {
        Org o = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        List<OrgParams> list = this.orgParamsService.getByOrgId(o.getId());
        return list;
    }

    @Override
    public CommonResult<OrgParams> getParamByAlias(String orgCode, String alias) throws Exception {
        Org o = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        OrgParams p = this.orgParamsService.getByOrgIdAndAlias(o.getId(), alias);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)p)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u53c2\u6570\u522b\u540d\u3010" + alias + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u4fe1\u606f");
        }
        return new CommonResult(true, "\u83b7\u53d6\u5b8c\u6bd5\uff01", (Object)p);
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgUser(OrgUserVo orgUserVo) throws Exception {
        OrgUser orgUser;
        if (StringUtil.isEmpty((String)orgUserVo.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgUserVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        User u = this.userService.getByAccount(orgUserVo.getAccount());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgUserVo.getIsCharge()) && orgUserVo.getIsCharge() == 1 && orgUserVo.getIsCharge() == 0) {
            throw new RuntimeException("isCharge\u53ea\u80fd\u4e3a0\u62161");
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgUserVo.getIsMaster()) && orgUserVo.getIsMaster() == 1 && orgUserVo.getIsMaster() == 0) {
            throw new RuntimeException("isMaster\u53ea\u80fd\u4e3a0\u62161");
        }
        Org o = this.getByCode(orgUserVo.getOrgCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", u.getId());
        map.put("orgId", o.getId());
        List<OrgUser> list = this.orgUserService.getByParms(map);
        if (com.hotent.base.util.BeanUtils.isEmpty(list)) {
            orgUser = new OrgUser();
            orgUser.setId(UniqueIdUtil.getSuid());
            orgUser.setUserId(u.getId());
            orgUser.setOrgId(o.getId());
            orgUser.setDemId(o.getDemId());
            orgUser.setIsRelActive(1);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUserVo.getIsCharge())) {
                orgUser.setIsCharge(0);
            } else {
                orgUser.setIsCharge(orgUserVo.getIsCharge());
            }
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUserVo.getIsMaster())) {
                orgUser.setIsMaster(0);
            } else {
                orgUser.setIsMaster(orgUserVo.getIsMaster());
            }
            List<OrgUser> l = this.orgUserService.getOrgUserMaster(u.getId(), o.getDemId());
            if (com.hotent.base.util.BeanUtils.isNotEmpty(l) && orgUserVo.getIsMaster() == 1) {
                OrgUser ou = l.get(0);
                ou.setIsMaster(0);
                this.orgUserService.update((Model)ou);
            } else if (com.hotent.base.util.BeanUtils.isEmpty(l)) {
                orgUser.setIsMaster(1);
            }
        } else {
            User user = this.userService.getByAccount(orgUserVo.getAccount());
            Org org = this.getByCode(orgUserVo.getOrgCode());
            throw new RuntimeException("\u7528\u6237\u3010" + user.getFullname() + "(" + orgUserVo.getAccount() + ")\u3011\u5df2\u5b58\u5728\u7ec4\u7ec7\u3010" + org.getName() + "(" + orgUserVo.getOrgCode() + ")\u3011\u4e2d");
        }
        this.orgUserService.create((Model)orgUser);
        this.delUserMenuCache(orgUser.getOrgId(), orgUser.getUserId());
        return new CommonResult(true, "\u52a0\u5165\u7528\u6237\u6210\u529f", (Object)"");
    }

    private void delUserMenuCache(String orgId, String userId) {
        List<OrgRole> orgRoles = this.orgRoleManager.getByOrgId(orgId);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgRoles)) {
            RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(RoleManagerImpl.class);
            bean.removeUserMenuCacheByUserIde(userId);
        }
    }

    @Override
    @Transactional
    public CommonResult<String> delOrgUser(String ids) throws Exception {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException("id\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] orgUserIds = ids.split(",");
        Boolean isDele = false;
        StringBuilder str = new StringBuilder();
        for (String id : orgUserIds) {
            OrgUser obj = (OrgUser)this.orgUserService.get((Serializable)((Object)id));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)obj)) {
                this.removeCache(obj);
                isDele = true;
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff01" : "\u90e8\u5206\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff0cid\u4e3a\uff1a" + str.toString() + "\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01";
        this.orgUserService.removeByIds(orgUserIds);
        return new CommonResult(isDele.booleanValue(), msg, (Object)"");
    }

    private void removeCache(OrgUser obj) {
        this.orgUserService.removeUserMainOrgCache(obj.getUserId());
        this.userService.removeUserGroupsCache(obj.getUserId());
        this.orgUserService.removeUserMainOrgCache("", obj.getUserId());
        this.userUnderService.delByUserIdAndOrgId(obj.getUserId(), obj.getOrgId());
        this.delUserMenuCache(obj.getOrgId(), obj.getUserId());
    }

    @Override
    public CommonResult<Boolean> getUserIsMaster(String account, String demCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)demCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ef4\u5ea6\u7f16\u7801demCode\u5fc5\u586b\uff01");
        }
        Demension d = this.demensionService.getByCode(demCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f");
        }
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(u.getId(), d.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty(orgUsers)) {
            return new CommonResult(true, "\u7528\u6237\u5728\u3010" + d.getDemCode() + "\u3011\u4e0b\u6ca1\u6709\u4e3b\u7ec4\u7ec7", (Object)false);
        }
        return new CommonResult(true, "\u7528\u6237\u5728\u3010" + d.getDemCode() + "\u3011\u4e0b\u5b58\u5728\u4e3b\u7ec4\u7ec7", (Object)true);
    }

    @Override
    @Transactional
    public CommonResult<String> setMaster(String account, String postCode) throws Exception {
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
        }
        OrgUser orgUser = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUser)) {
            throw new RuntimeException("\u5bf9\u4e0d\u8d77\uff0c\u8be5\u7528\u6237\u76ee\u524d\u8fd8\u4e0d\u662f\u8be5\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458\uff01");
        }
        this.orgUserService.setMaster(orgUser.getId());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<OrgTree> getTreeDataByDem(String demCode, String pOrgCode) throws Exception {
        if (StringUtil.isEmpty((String)demCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ef4\u5ea6\u7f16\u7801demCode\u5fc5\u586b");
        }
        Demension d = this.demensionService.getByCode(demCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6");
        }
        Org p = this.getByCode(pOrgCode);
        if (StringUtil.isNotEmpty((String)pOrgCode) && com.hotent.base.util.BeanUtils.isEmpty((Object)p)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684pOrgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7");
        }
        ArrayList<OrgTree> orgTree = new ArrayList<OrgTree>();
        String pId = "0";
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)p)) {
            pId = p.getId();
        }
        QueryFilter filter = QueryFilter.build();
        PageBean page = new PageBean();
        page.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        filter.setPageBean(page);
        filter.addParams("demId", (Object)d.getId());
        List<Org> groupList = this.getByParentAndDem(filter);
        ArrayList<Org> rtnList = new ArrayList<Org>();
        OrgManagerImpl.getChild(groupList, pId, rtnList);
        for (Org group : rtnList) {
            OrgTree groupTree = new OrgTree(group);
            orgTree.add(groupTree);
        }
        return orgTree;
    }

    @Override
    @Transactional
    public CommonResult<String> setOrgCharge(String account, String orgCode, Boolean isCharge) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        Org o = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        List<OrgUser> orgUserList = this.orgUserService.getListByOrgIdUserId(o.getId(), u.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty(orgUserList)) {
            throw new RuntimeException("\u7528\u6237\u3010" + account + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + orgCode + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb");
        }
        this.orgUserService.setCharge(u.getId(), isCharge, o.getId());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addUserUnders(UserUnderVo userUnderObj) throws Exception {
        String[] underAccounts;
        if (StringUtil.isEmpty((String)userUnderObj.getUnderAccounts())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u4e0b\u5c5e\u7528\u6237\u5e10\u53f7underAccounts\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)userUnderObj.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)userUnderObj.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(userUnderObj.getAccount());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(userUnderObj.getOrgCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), u.getId()))) {
            return new CommonResult(false, "\u7528\u6237\u3010" + u.getFullname() + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb", (Object)"");
        }
        for (String a : underAccounts = userUnderObj.getUnderAccounts().split(",")) {
            User under = this.userService.getByAccount(a);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)under)) {
                throw new RuntimeException("\u6839\u636e\u5e10\u53f7\u3010" + a + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
            }
            if (com.hotent.base.util.BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), under.getId()))) {
                return new CommonResult(false, "\u7528\u6237\u3010" + under.getFullname() + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb", (Object)"");
            }
            if (userUnderObj.getAccount().equals(a)) {
                throw new RuntimeException("\u7528\u6237\u3010" + a + "\u3011\u4e0d\u80fd\u5c06\u81ea\u5df1\u6dfb\u52a0\u4e3a\u81ea\u5df1\u7684\u4e0b\u5c5e\uff01");
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userId", under.getId());
            m.put("orgId", o.getId());
            m.put("underUserId", u.getId());
            List<UserUnder> list = this.userUnderService.getUserUnder(m);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list)) {
                throw new RuntimeException("\u7528\u6237\u3010" + under.getAccount() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getCode() + "\u3011\u4e0b\u662f\u7528\u6237\u3010" + u.getAccount() + "\u3011\u7684\u4e0a\u7ea7");
            }
            HashMap<String, Object> m1 = new HashMap<String, Object>();
            m1.put("noUserId", u.getId());
            m1.put("orgId", o.getId());
            m1.put("underUserId", under.getId());
            List<UserUnder> list1 = this.userUnderService.getUserUnder(m1);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list1)) {
                User supperUser = (User)this.userService.get((Serializable)((Object)list1.get(0).getUserId()));
                throw new RuntimeException("\u7528\u6237\u3010" + a + "\u3011\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u5df2\u6709\u4e0a\u7ea7\u3010" + supperUser.getFullname() + "\u3011\uff0c\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u80fd\u518d\u8bbe\u7f6e\u5176\u4ed6\u4e0a\u7ea7\u3002");
            }
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            m2.put("userId", u.getId());
            m2.put("orgId", o.getId());
            m2.put("underUserId", under.getId());
            List<UserUnder> list2 = this.userUnderService.getUserUnder(m2);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list2)) continue;
            UserUnder userUnder = new UserUnder();
            userUnder.setId(UniqueIdUtil.getSuid());
            userUnder.setUserId(u.getId());
            userUnder.setUnderUserId(under.getId());
            userUnder.setUnderUserName(under.getFullname());
            userUnder.setOrgId(o.getId());
            this.userUnderService.create((Model)userUnder);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u4e0b\u5c5e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delUserUnders(String account, String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", u.getId());
        params.put("orgId", o.getId());
        List<UserUnder> l = this.userUnderService.getUserUnder(params);
        if (com.hotent.base.util.BeanUtils.isEmpty(l)) {
            return new CommonResult(false, "\u7528\u6237\u3010" + u.getFullname() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0b\u6ca1\u6709\u4e0b\u7ea7", (Object)"");
        }
        this.userUnderService.delByUserIdAndOrgId(u.getId(), o.getId());
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<UserVo> getUserUnders(String account, String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("userId", u.getId());
        m.put("orgId", o.getId());
        List<UserUnder> list = this.userUnderService.getUserUnder(m);
        ArrayList<User> userList = new ArrayList<User>();
        for (UserUnder under : list) {
            User user = (User)this.userService.get((Serializable)((Object)under.getUnderUserId()));
            userList.add(user);
        }
        return OrgUtil.convertToUserVoList(userList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveOrgAuth(OrgAuthVo orgAuthVo) {
        List<OrgAuth> list;
        OrgAuth a;
        User u = this.userService.getByAccount(orgAuthVo.getAccount());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(orgAuthVo.getOrgCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        Demension d = this.demensionService.getByCode(orgAuthVo.getDemCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7ef4\u5ea6\uff01");
        }
        if (!o.getDemId().equals(d.getId())) {
            throw new RuntimeException("\u8f93\u5165\u7684\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0e\u8f93\u5165\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getId()) ? com.hotent.base.util.BeanUtils.isNotEmpty((Object)(a = this.orgAuthService.getByOrgIdAndUserId(o.getId(), u.getId()))) : (list = this.orgAuthService.getListByOrgIdAndUserId(o.getId(), u.getId())) != null && list.size() > 1) {
            throw new RuntimeException("\u7528\u6237\u5728\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u662f\u5206\u7ea7\u7ba1\u7406\u5458\uff01");
        }
        OrgAuth auth = (OrgAuth)BeanUtil.copyProperties((Object)orgAuthVo, OrgAuth.class, (String[])new String[0]);
        auth.setOrgId(o.getId());
        auth.setUserId(u.getId());
        auth.setDemId(d.getId());
        if (StringUtil.isEmpty((String)orgAuthVo.getId())) {
            auth.setId(UniqueIdUtil.getSuid());
            this.orgAuthService.create((Model)auth);
            return new CommonResult(true, "\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406\u6210\u529f\uff01", (Object)"");
        }
        auth.setId(orgAuthVo.getId());
        this.orgAuthService.update((Model)auth);
        return new CommonResult(true, "\u66f4\u65b0\u5206\u7ea7\u7ba1\u7406\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgAuth(String ids) throws Exception {
        String[] idArr;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u5fc5\u586b");
        }
        for (String id : idArr = ids.split(",")) {
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)this.orgAuthService.get((Serializable)((Object)id)))) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01");
            }
            this.orgAuthService.remove((Serializable)((Object)id));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public Page<OrgAuth> getOrgAuthList(String account, String orgCode, String demCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = null;
        if (StringUtil.isNotEmpty((String)orgCode)) {
            o = this.getByCode(orgCode);
        }
        if (StringUtil.isNotEmpty((String)orgCode) && com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        Demension de = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            de = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && com.hotent.base.util.BeanUtils.isEmpty((Object)de)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        QueryFilter filter = QueryFilter.build();
        filter.addParams("userId", (Object)u.getId());
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)o)) {
            filter.addParams("orgId", (Object)o.getId());
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)de)) {
            filter.addParams("demId", (Object)de.getId());
        }
        Page list = (Page)this.orgAuthService.getAllOrgAuth((QueryFilter<OrgAuth>)filter);
        return list;
    }

    @Override
    public OrgAuth getOrgAuth(String id) throws Exception {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)id), (String)(HotentHttpStatus.REUIRED.description() + ":\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u5fc5\u586b"));
        OrgAuth orgAuth = (OrgAuth)this.orgAuthService.get((Serializable)((Object)id));
        Assert.notNull((Object)orgAuth, (String)"\u6839\u636e\u8f93\u5165\u7684id\u6570\u636e\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4fe1\u606f");
        User user = (User)this.userService.get((Serializable)((Object)orgAuth.getUserId()));
        Assert.notNull((Object)user, (String)"\u6743\u9650\u7528\u6237\u4e0d\u5b58\u5728");
        orgAuth.setUserName(user.getFullname());
        orgAuth.setUserAccount(user.getAccount());
        return orgAuth;
    }

    @Override
    public List<Org> getUserOrgs(String account, String demCode, Boolean isMain) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Demension de = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            de = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && com.hotent.base.util.BeanUtils.isEmpty((Object)de)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        List<Org> list = null;
        String demId = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)de)) {
            demId = de.getId();
        }
        list = com.hotent.base.util.BeanUtils.isEmpty((Object)isMain) ? this.getUserOrg(u.getId(), demId, null) : this.getUserOrg(u.getId(), demId, isMain);
        return list;
    }

    @Override
    public List<UserVo> getUsersByOrgCodes(String orgCodes, Boolean isMain) throws Exception {
        String[] orgCodeArr;
        if (StringUtil.isEmpty((String)orgCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCodes\u5fc5\u586b\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        for (String orgCode : orgCodeArr = orgCodes.split(",")) {
            Org o = this.getByCode(orgCode);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
                throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7\u4ee3\u7801\u3010" + orgCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            List<User> l = this.userService.getOrgUsers(o.getId(), isMain);
            if (!com.hotent.base.util.BeanUtils.isNotEmpty(l)) continue;
            list.addAll(l);
        }
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public List<OrgPost> getPostsByOrgCodes(String orgCodes, Boolean isMain) throws Exception {
        String[] orgCodeArr;
        if (StringUtil.isEmpty((String)orgCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCodes\u5fc5\u586b\uff01");
        }
        ArrayList<OrgPost> list = new ArrayList<OrgPost>();
        for (String orgCode : orgCodeArr = orgCodes.split(",")) {
            Org o = this.getByCode(orgCode);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
                throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7\u4ee3\u7801\u3010" + orgCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            List<OrgPost> l = this.orgPostService.getRelCharge(o.getId(), isMain);
            if (!com.hotent.base.util.BeanUtils.isNotEmpty(l)) continue;
            list.addAll(l);
        }
        return list;
    }

    @Override
    public List<Org> getByLevel(String level, String demCode) throws Exception {
        if (StringUtil.isEmpty((String)level)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7ea7\u522blevel\u5fc5\u586b\uff01");
        }
        Demension d = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            d = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && com.hotent.base.util.BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        QueryFilter filter = QueryFilter.build();
        filter.addParams("grade_", (Object)level);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)d)) {
            filter.addParams("dem_id_", (Object)d.getId());
        }
        return this.query(filter).getRows();
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserPost(String accounts, String postCode) throws Exception {
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        String[] postCodeArr = postCode.split(",");
        String[] accountArr = accounts.split(",");
        for (String str : postCodeArr) {
            OrgPost post = this.orgPostService.getByCode(str);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            Org org = this.get((Serializable)((Object)post.getOrgId()));
            if (postCode.indexOf(",") < 0 && org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                Set accountSet = Arrays.stream(accountArr).collect(Collectors.toSet());
                long count = list.stream().filter(item -> item.containsKey("account") && accountSet.contains(item.get("account"))).count();
                if ((long)org.getLimitNum().intValue() < (long)(list.size() + accountArr.length) - count) {
                    return new CommonResult(false, "\u4eba\u6570\u8d85\u51fa\u7ec4\u7ec7\u4e0a\u9650\uff0c\u4e0d\u4e88\u6dfb\u52a0", null);
                }
            }
            for (String account : accountArr) {
                User u = this.userService.getByAccount(account);
                if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
                    throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
                }
                OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)ou)) continue;
                ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), "");
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)ou)) {
                    ou.setDemId(org.getDemId());
                    ou.setRelId(post.getId());
                    this.userService.removeUserGroupsCache(u.getId());
                } else {
                    ou = new OrgUser();
                    ou.setId(UniqueIdUtil.getSuid());
                    ou.setUserId(u.getId());
                    ou.setIsCharge(0);
                    ou.setIsMaster(0);
                    ou.setIsRelActive(1);
                    ou.setOrgId(post.getOrgId());
                    ou.setDemId(org.getDemId());
                    ou.setRelId(post.getId());
                    this.userService.removeUserGroupsCache(u.getId());
                }
                List<OrgUser> l = this.orgUserService.getOrgUserMaster(u.getId(), org.getDemId());
                if (com.hotent.base.util.BeanUtils.isEmpty(l)) {
                    ou.setIsMaster(1);
                }
                this.orgUserService.saveOrUpdate(ou);
                CacheEvictUtil.deleteUserDetailsCache((String)account);
            }
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserPosts(String account, String postCodes) throws Exception {
        String[] postCodesArr;
        if (StringUtil.isEmpty((String)account)) {
            throw new com.hotent.base.exception.BaseException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCodes)) {
            throw new com.hotent.base.exception.BaseException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        for (String postCode : postCodesArr = postCodes.split(",")) {
            User u;
            OrgPost post = this.orgPostService.getByCode(postCode);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
                throw new com.hotent.base.exception.BaseException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            Org org = this.get((Serializable)((Object)post.getOrgId()));
            if (org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                if (org.getLimitNum() <= list.size()) {
                    throw new com.hotent.base.exception.BaseException(org.getName() + "\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4e0d\u4e88\u6dfb\u52a0\uff01\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
            }
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)(u = this.userService.getByAccount(account)))) {
                throw new com.hotent.base.exception.BaseException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
            }
            OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)ou)) {
                throw new com.hotent.base.exception.BaseException("\u5f53\u524d\u7528\u6237\u5df2\u5728\u3010" + post.getName() + "\u3011\u7684\u5c97\u4f4d\u4e0a\uff01");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ORG_ID_", (Object)post.getOrgId());
            queryWrapper.eq((Object)"USER_ID_", (Object)u.getId());
            List list = this.orgUserService.listMaps((Wrapper)queryWrapper);
            for (int i = 0; i < list.size(); ++i) {
                if (com.hotent.base.util.BeanUtils.isEmpty((Object)MapUtil.getIgnoreCase((Map)((Map)list.get(i)), (String)"relId"))) continue;
                this.delOrgUser(MapUtil.getIgnoreCase((Map)((Map)list.get(i)), (String)"relId").toString());
                break;
            }
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)(ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), "")))) {
                ou.setDemId(org.getDemId());
                ou.setRelId(post.getId());
                this.userService.removeUserGroupsCache(u.getId());
            } else {
                ou = new OrgUser();
                ou.setId(UniqueIdUtil.getSuid());
                ou.setUserId(u.getId());
                ou.setIsCharge(0);
                ou.setIsMaster(0);
                ou.setIsRelActive(1);
                ou.setOrgId(post.getOrgId());
                ou.setDemId(org.getDemId());
                ou.setRelId(post.getId());
                this.userService.removeUserGroupsCache(u.getId());
            }
            List<OrgUser> l = this.orgUserService.getOrgUserMaster(u.getId(), org.getDemId());
            if (com.hotent.base.util.BeanUtils.isEmpty(l)) {
                ou.setIsMaster(1);
            }
            this.orgUserService.saveOrUpdate(ou);
            this.userService.removeUserGroupsCache(u.getId());
            CacheEvictUtil.deleteUserDetailsCache((String)account);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delUserPost(String accounts, String postCode) throws Exception {
        String[] accountArr;
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
        }
        for (String account : accountArr = accounts.split(",")) {
            User u = this.userService.getByAccount(account);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
            }
            OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)ou)) {
                throw new RuntimeException("\u7528\u6237\u3010" + account + "\u3011\u4e0d\u5728\u5c97\u4f4d\u3010" + post.getCode() + "\u3011\u4e0b");
            }
            this.orgUserService.remove((Serializable)((Object)ou.getId()));
            this.userService.removeUserGroupsCache(u.getId());
            CacheEvictUtil.deleteUserDetailsCache((String)account);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrgPost(OrgPostVo orgPostVo) throws Exception {
        List<OrgPost> l;
        if (StringUtil.isEmpty((String)orgPostVo.getCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801code\u5fc5\u586b\uff01");
        }
        if (orgPostVo.getCode().contains(",")) {
            throw new RuntimeException("\u6dfb\u52a0\u5c97\u4f4d\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u4e0d\u5141\u8bb8\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getName())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u540d\u79f0name\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getJobCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u804c\u52a1\u4ee3\u7801jobCode\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgPostVo.getOrgCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        OrgJob job = this.orgJobService.getByCode(orgPostVo.getJobCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        if (this.orgPostService.getCountByCode(orgPostVo.getCode()) > 0) {
            throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u3010" + orgPostVo.getCode() + "\u3011\u5df2\u7ecf\u5b58\u5728\u7cfb\u7edf\u4e2d\uff01");
        }
        OrgPost rel = new OrgPost();
        rel.setId(UniqueIdUtil.getSuid());
        rel.setName(orgPostVo.getName());
        rel.setCode(orgPostVo.getCode());
        rel.setRelDefId(job.getId());
        rel.setOrgId(o.getId());
        rel.setIsCharge(orgPostVo.getIsCharge());
        if (orgPostVo.getIsCharge() == 1 && com.hotent.base.util.BeanUtils.isNotEmpty(l = this.orgPostService.getRelCharge(o.getId(), true))) {
            OrgPost p = l.get(0);
            p.setIsCharge(0);
            this.orgPostService.update((Model)p);
        }
        if (StringUtil.isNotEmpty((String)orgPostVo.getShowStatus())) {
            rel.setShowStatus(orgPostVo.getShowStatus());
        }
        this.orgPostService.create((Model)rel);
        return new CommonResult(true, "\u6dfb\u52a0\u5c97\u4f4d\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgPost(String postCodes) throws Exception {
        String[] codeArr;
        if (StringUtil.isEmpty((String)postCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801postCodes\u5fc5\u586b\uff01");
        }
        for (String code : codeArr = postCodes.split(",")) {
            OrgPost rel = this.orgPostService.getByCode(code);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)rel)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u3010" + code + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgId", rel.getOrgId());
            map.put("relId", rel.getId());
            List<OrgUser> orgUsers = this.orgUserService.getByParms(map);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(orgUsers)) {
                throw new RuntimeException("\u5c97\u4f4d\u3010" + rel.getName() + "\u3011\u4e0b\u8fd8\u5b58\u5728\u5206\u914d\u7528\u6237\uff0c\u8bf7\u5220\u9664\u7528\u6237\u5728\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
            String[] ids = new String[]{rel.getId()};
            this.orgPostService.removeByIds(ids);
        }
        return new CommonResult(true, "\u5220\u9664\u5c97\u4f4d\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setPostMaster(String postCode, Boolean isMain) throws Exception {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801postCode\u5fc5\u586b\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)isMain)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u662f\u5426\u8d23\u4efb\u5c97\u4f4disMain\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\uff01");
        }
        if (isMain.booleanValue()) {
            this.orgPostService.cancelRelCharge(post.getOrgId());
        }
        this.orgPostService.setRelCharge(post.getId(), isMain);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setUserPostDueTime(PostDueVo postDueVo) throws Exception {
        LocalDateTime endDate;
        LocalDateTime startDate;
        if (StringUtil.isEmpty((String)postDueVo.getCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801code\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postDueVo.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)postDueVo.getEndDate()) && com.hotent.base.util.BeanUtils.isEmpty((Object)postDueVo.getStartDate())) {
            throw new RuntimeException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postDueVo.getCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
        }
        User u = this.userService.getByAccount(postDueVo.getAccount());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        OrgUser orgUser = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUser)) {
            throw new RuntimeException("\u7528\u6237\u4e0e\u8be5\u5c97\u4f4d\u6ca1\u5173\u7cfb\uff0c\u4e0d\u80fd\u8bbe\u7f6e\uff01");
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getStartDate()) && StringUtil.isNotEmpty((String)postDueVo.getEndDate()) && DateUtil.getTime((LocalDateTime)(startDate = DateFormatUtil.parse((String)postDueVo.getStartDate())), (LocalDateTime)(endDate = DateFormatUtil.parse((String)postDueVo.getEndDate()))) < 0L) {
            throw new RuntimeException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getStartDate())) {
            orgUser.setStartDate(DateFormatUtil.parse((String)postDueVo.getStartDate()));
        } else {
            orgUser.setStartDate(null);
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getEndDate())) {
            orgUser.setEndDate(DateFormatUtil.parse((String)postDueVo.getEndDate()));
        } else {
            orgUser.setEndDate(null);
        }
        this.orgUserService.update((Model)orgUser);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> validOrgUser() throws Exception {
        this.orgUserService.syncValidOrgUser();
        return new CommonResult(true, "\u6821\u9a8c\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgRole(OrgRoleVo orgRoleVo) throws Exception {
        String[] roleCodes;
        if (StringUtil.isEmpty((String)orgRoleVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgRoleVo.getOrgCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        if (StringUtil.isEmpty((String)orgRoleVo.getRoleCodes())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u89d2\u8272\u7f16\u7801roleCodes\u5fc5\u586b\uff01");
        }
        for (String rCode : roleCodes = orgRoleVo.getRoleCodes().split(",")) {
            Role r = this.roleService.getByAlias(rCode);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)r) && com.hotent.base.util.BeanUtils.isEmpty((Object)(r = (Role)this.roleService.get((Serializable)((Object)rCode))))) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u89d2\u8272\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
            }
            if (orgRoleVo.getIsInherit() > 0) {
                this.orgRoleService.addOrgRole(org.getId(), r, 1);
                continue;
            }
            this.orgRoleService.addOrgRole(org.getId(), r, 0);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveRoleOrg(RoleOrgVo vo) {
        Assert.notNull((Object)vo.getRoleId(), (String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(vo.getOrgIds(), (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<OrgRole> orgRoles = new ArrayList<OrgRole>();
        Role role = (Role)this.roleService.getById((Serializable)((Object)vo.getRoleId()));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)role)) {
            throw new com.hotent.base.exception.BaseException(String.format("\u6839\u636e\u89d2\u8272ID\u3010%s\u3011,\u627e\u4e0d\u5230\u5bf9\u5e94\u89d2\u8272", vo.getRoleId()));
        }
        CacheManager cacheManager = (CacheManager)AppUtil.getBean(CacheManager.class);
        Collection caches = cacheManager.getCache("eip:uc:orgRole");
        for (String orgId : vo.getOrgIds()) {
            Org org = (Org)this.getById((Serializable)((Object)orgId));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
                throw new com.hotent.base.exception.BaseException(String.format("\u6839\u636e\u7ec4\u7ec7ID\u3010%s\u3011\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7", orgId));
            }
            OrgRole or = new OrgRole();
            or.setIsInherit(0);
            or.setOrgId(orgId);
            or.setRoleId(vo.getRoleId());
            orgRoles.add(or);
            for (ICache cach : caches) {
                cach.evict((Object)orgId);
            }
            this.removeUserMenuByOrgId(orgId);
            this.orgRoleManager.removeCacheByOrg(orgId);
        }
        QueryWrapper deleteQueryWrapper = new QueryWrapper();
        ((QueryWrapper)deleteQueryWrapper.eq((Object)"ROLE_ID_", (Object)vo.getRoleId())).in((Object)"ORG_ID_", vo.getOrgIds());
        this.orgRoleManager.remove((Wrapper)deleteQueryWrapper);
        this.orgRoleManager.saveBatch(orgRoles);
    }

    @Override
    @Transactional
    public void delOrgRoleByCode(String orgCode, String roleCodes) throws Exception {
        String[] roleCodeArr;
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        if (StringUtil.isEmpty((String)roleCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u89d2\u8272\u7f16\u7801roleCodes\u5fc5\u586b\uff01");
        }
        for (String rCode : roleCodeArr = roleCodes.split(",")) {
            Role r = this.roleService.getByAlias(rCode);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)r)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u89d2\u8272\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
            }
            this.orgRoleService.delByOrgIdAndRoleId(org.getId(), r.getId());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> delOrgRoleById(String ids) throws Exception {
        String[] roleId;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u89d2\u8272ID\u5fc5\u586b\uff01");
        }
        for (String id : roleId = ids.split(",")) {
            this.orgRoleService.remove((Serializable)((Object)id));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public void delAllOrgRole(String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        this.orgRoleService.delByOrgIdAndRoleId(org.getId(), null);
    }

    @Override
    public List<Role> getOrgRoleByCode(String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        return this.getRolesByOrgId(org.getId());
    }

    public List<Role> getRolesByOrgId(String orgId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        List<Role> roleList = this.roleService.getOrgRoleList(map);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(roleList)) {
            return roleList;
        }
        roleList = new ArrayList<Role>();
        String path = this.getPathByOrgId(orgId);
        if (StringUtil.isEmpty((String)path)) {
            return roleList;
        }
        String[] aryPath = path.split("[.]");
        for (int i = aryPath.length - 1; i >= 0; --i) {
            String tmpOrgId = aryPath[i];
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("orgId", tmpOrgId);
            m.put("isInherit", 1);
            roleList = this.roleService.getOrgRoleList(m);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(roleList)) break;
        }
        return roleList;
    }

    private String getPathByOrgId(String orgId) {
        Org sysOrg = this.get((Serializable)((Object)orgId));
        if (sysOrg == null) {
            return "";
        }
        String path = sysOrg.getPath();
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        path = path.replace("." + orgId + ".", "");
        int pos = path.indexOf(".");
        path = path.substring(pos + 1);
        return path;
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrgPost(OrgPostVo postVo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)postVo.getCode())) {
            return new CommonResult(false, "\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b", (Object)"");
        }
        if (StringUtils.isEmpty((CharSequence)postVo.getName())) {
            return new CommonResult(false, "\u5c97\u4f4d\u540d\u79f0\u5fc5\u586b", (Object)"");
        }
        OrgPost p = this.orgPostService.getByCode(postVo.getCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)p)) {
            return new CommonResult(false, "\u6839\u636e\u8f93\u5165\u7684\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)postVo.getOrgCode())) {
            Org o = this.getByCode(postVo.getOrgCode());
            if (!p.getOrgId().equals(o.getId())) {
                p.setOrgId(o.getId());
                if (o.getExceedLimitNum() == 1 && o.getLimitNum() != 0) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgCode", o.getCode());
                    map.put("group", "true");
                    List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                    if (o.getLimitNum() <= list.size()) {
                        return new CommonResult(false, "\u5c97\u4f4d\u7ec4\u7ec7\u6240\u5c5e\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
                    }
                    HashSet<String> userIds = new HashSet<String>();
                    for (Map<String, Object> l : list) {
                        userIds.add((String)l.get("userId"));
                    }
                    QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                    queryFilter.addFilter("pos_id_", (Object)p.getId(), QueryOP.EQUAL);
                    IPage<HashMap<String, Object>> userByGroup = this.orgUserService.getUserByGroup(queryFilter);
                    HashSet<String> addUserIds = new HashSet<String>();
                    if (com.hotent.base.util.BeanUtils.isNotEmpty(userByGroup)) {
                        for (Map orgUser : userByGroup.getRecords()) {
                            if (userIds.contains(orgUser.get("userId"))) continue;
                            addUserIds.add((String)orgUser.get("userId"));
                        }
                    }
                    if (o.getLimitNum() <= list.size() + addUserIds.size()) {
                        return new CommonResult(false, "\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
                    }
                }
                this.orgUserService.updateUserOrgByPostId(p.getId(), p.getOrgId());
            }
        }
        if (postVo.getIsCharge() == 1) {
            p.setIsCharge(1);
            this.setPostMaster(p.getCode(), true);
        }
        if (StringUtil.isNotEmpty((String)postVo.getShowStatus())) {
            p.setShowStatus(postVo.getShowStatus());
        }
        p.setName(postVo.getName());
        if (StringUtil.isNotEmpty((String)postVo.getJobCode())) {
            OrgJob byCode = this.orgJobService.getByCode(postVo.getJobCode());
            p.setRelDefId(byCode.getId());
        }
        this.orgPostService.update((Model)p);
        return new CommonResult(true, "\u66f4\u65b0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setUnderUsers(String orgId, String account, String underAccounts) throws Exception {
        String[] underAccountArr;
        User u = this.userService.getByAccount(account);
        Org o = this.get((Serializable)((Object)orgId));
        for (String a : underAccountArr = underAccounts.split(",")) {
            User under = this.userService.getByAccount(a);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)under)) {
                throw new com.hotent.base.exception.BaseException("\u6839\u636e\u5e10\u53f7\u3010" + a + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
            }
            if (account.equals(a)) {
                throw new com.hotent.base.exception.BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u4e0d\u80fd\u5c06\u81ea\u5df1\u6dfb\u52a0\u4e3a\u81ea\u5df1\u7684\u4e0b\u5c5e\uff01");
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userId", under.getId());
            m.put("orgId", o.getId());
            m.put("underUserId", u.getId());
            List<UserUnder> list = this.userUnderService.getUserUnder(m);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list)) {
                throw new com.hotent.base.exception.BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getCode() + "\u3011\u4e0b\u662f\u7528\u6237\u3010" + u.getFullname() + "\u3011\u7684\u4e0a\u7ea7");
            }
            HashMap<String, Object> m1 = new HashMap<String, Object>();
            m1.put("noUserId", u.getId());
            m1.put("orgId", o.getId());
            m1.put("underUserId", under.getId());
            List<UserUnder> list1 = this.userUnderService.getUserUnder(m1);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list1)) {
                User supperUser = (User)this.userService.get((Serializable)((Object)list1.get(0).getUserId()));
                throw new com.hotent.base.exception.BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u5df2\u6709\u4e0a\u7ea7\u3010" + supperUser.getFullname() + "\u3011\uff0c\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u80fd\u518d\u8bbe\u7f6e\u5176\u4ed6\u4e0a\u7ea7\u3002");
            }
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            m2.put("userId", u.getId());
            m2.put("orgId", o.getId());
            m2.put("underUserId", under.getId());
            List<UserUnder> list2 = this.userUnderService.getUserUnder(m2);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(list2)) continue;
            UserUnder userUnder = new UserUnder();
            userUnder.setId(UniqueIdUtil.getSuid());
            userUnder.setUserId(u.getId());
            userUnder.setUnderUserId(under.getId());
            userUnder.setUnderUserName(under.getFullname());
            userUnder.setOrgId(o.getId());
            this.userUnderService.create((Model)userUnder);
            if (!com.hotent.base.util.BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), under.getId()))) continue;
            OrgUser ou = new OrgUser();
            ou.setId(UniqueIdUtil.getSuid());
            ou.setUserId(under.getId());
            ou.setOrgId(orgId);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u4e0b\u5c5e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addUsersForOrg(String orgCode, String accounts) throws Exception {
        String[] accountArr = accounts.split(",");
        Org o = this.getByCode(orgCode);
        for (String a : accountArr) {
            User u = this.userService.getByAccount(a);
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
                return new CommonResult(false, "\u5e10\u53f7\u3010" + a + "\u3011\u4e0d\u5b58\u5728", (Object)"");
            }
            this.addOrgUser(o.getId(), u.getId(), o.getDemId());
        }
        return new CommonResult(true, "\u52a0\u5165\u6210\u529f", (Object)"");
    }

    @Override
    public void addOrgUser(String orgId, String userId, String demId) {
        List<OrgUser> l = this.orgUserService.getListByOrgIdUserId(orgId, userId);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(l)) {
            return;
        }
        OrgUser ou = new OrgUser();
        ou.setId(UniqueIdUtil.getSuid());
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(userId, demId);
        if (com.hotent.base.util.BeanUtils.isEmpty(orgUsers)) {
            ou.setIsMaster(1);
        } else {
            ou.setIsMaster(0);
        }
        ou.setIsCharge(0);
        ou.setOrgId(orgId);
        ou.setDemId(demId);
        ou.setUserId(userId);
        ou.setVersion(1);
        ou.setIsRelActive(1);
        this.orgUserService.create((Model)ou);
        this.userService.removeUserGroupsCache(userId);
        this.delUserMenuCache(orgId, userId);
    }

    @Override
    public List<Org> getOrgByTime(OrgExportObject exportObject) throws Exception {
        List<String> ids;
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        List list = new ArrayList();
        if (StringUtil.isNotEmpty((String)exportObject.getDemCodes())) {
            QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter.addFilter("CODE_", (Object)exportObject.getDemCodes(), QueryOP.IN, FieldRelation.AND);
            list = this.DemensionManager.queryNoPage(filter);
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty(list)) {
            HashSet<String> demIds = new HashSet<String>();
            for (Demension demension : list) {
                demIds.add(demension.getId());
            }
            queryFilter.addFilter("DEM_ID_", new ArrayList(demIds), QueryOP.IN, FieldRelation.AND);
        }
        if (StringUtil.isNotEmpty((String)exportObject.getOrgCodes()) && com.hotent.base.util.BeanUtils.isNotEmpty(ids = this.getOrgAndChildrens(exportObject.getOrgCodes()))) {
            queryFilter.addFilter("ID_", ids, QueryOP.IN, FieldRelation.AND);
        }
        return this.queryNoPage(queryFilter);
    }

    private List<String> getOrgAndChildrens(String orgCodes) {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("CODE_", (Object)orgCodes, QueryOP.IN, FieldRelation.AND);
        List porgs = this.queryNoPage(filter);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)porgs)) {
            QueryFilter filter2 = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter2.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            for (Org org : porgs) {
                filter2.addFilter("PATH_", (Object)org.getPath(), QueryOP.RIGHT_LIKE, FieldRelation.OR);
            }
            List childrens = this.queryNoPage(filter2);
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)childrens)) {
                HashSet<String> ids = new HashSet<String>();
                for (Org org : childrens) {
                    ids.add(org.getId());
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ids);
                return list;
            }
        }
        return new ArrayList<String>();
    }

    @Transactional
    private void addOrgFilter(QueryFilter queryFilter, OrgExportObject exportObject) throws Exception {
        List<Org> orgs;
        if ((StringUtil.isNotEmpty((String)exportObject.getDemCodes()) || StringUtil.isNotEmpty((String)exportObject.getOrgCodes())) && com.hotent.base.util.BeanUtils.isNotEmpty(orgs = this.getOrgByTime(exportObject))) {
            ArrayList<String> orgIds = new ArrayList<String>();
            for (Org org : orgs) {
                orgIds.add(org.getId());
            }
            queryFilter.addFilter("ORG_ID_", orgIds, QueryOP.IN, FieldRelation.AND);
        }
    }

    @Override
    public List<OrgParams> getOrgParamByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return this.orgParamsService.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgPost> getOrgPostByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return this.orgPostService.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgRole> getOrgRoleByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.orgRoleManager.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgUser> getOrgUserByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.orgUserService.queryNoPage(queryFilter);
    }

    @Override
    public List<UserUnder> getUserUnderByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.userUnderManager.queryNoPage(queryFilter);
    }

    @Override
    public List<Org> getOrgsByAccount(String account) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        List<Org> list = ((OrgDao)this.baseMapper).getOrgsByAccount(account);
        for (Org org : list) {
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)org.getDemId()));
            if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)dem)) continue;
            org.setDemName(dem.getDemName());
        }
        OrgUtil.removeDuplicate(list, "id");
        return list;
    }

    @Override
    @Transactional
    public Integer removePostPhysical() {
        return this.orgPostDao.removePhysical();
    }

    @Override
    @Transactional
    public Integer removeOrgUserPhysical() {
        return this.orgUserService.removePhysical();
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Org org = this.getByCode(code);
        return new CommonResult(isExist, (isExist = com.hotent.base.util.BeanUtils.isNotEmpty((Object)org)) ? "\u8be5\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public CommonResult<Boolean> isPostCodeExist(String code) throws Exception {
        boolean isExist;
        OrgPost post = this.orgPostDao.getByCode(code);
        return new CommonResult(isExist, (isExist = com.hotent.base.util.BeanUtils.isNotEmpty((Object)post)) ? "\u8be5\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrgPos(String orgId, String parentId) throws Exception {
        Org parentOrg;
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u79fb\u52a8\u8282\u70b9\u6216\u76ee\u6807\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = this.get((Serializable)((Object)orgId));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u6839\u636e\u79fb\u52a8\u8282\u70b9id\u3010" + orgId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        org.setParentId(parentId);
        if ("0".equals(parentId)) {
            parentId = org.getDemId();
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)(parentOrg = this.get((Serializable)((Object)parentId))))) {
            org.setPath(parentId + "." + orgId + ".");
            org.setPathName("/" + org.getName());
        } else {
            org.setPath(parentOrg.getPath() + orgId + ".");
            org.setPathName(parentOrg.getPathName() + "/" + org.getName());
        }
        this.update((Model)org);
        this.updateChildrenOrg(org);
        return new CommonResult(true, "\u66f4\u65b0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Transactional
    private void updateChildrenOrg(Org parentOrg) throws SQLException {
        List<Org> childrens = this.getByParentId(parentOrg.getId());
        for (Org org : childrens) {
            org.setPath(parentOrg.getPath() + org.getId() + ".");
            org.setPathName(parentOrg.getPathName() + "/" + org.getName());
            this.update((Model)org);
            this.updateChildrenOrg(org);
        }
    }

    @Override
    public String exportData(String orgCode, boolean isChildre) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u7ec4\u7ec7\u7f16\u7801\u3010orgCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.getPageBean().setPageSize(PageBean.WITHOUT_PAGE.intValue());
        if (isChildre) {
            queryFilter.getParams().put("whereSql", " org.path_ like '" + org.getPath() + "%'");
        } else {
            queryFilter.getParams().put("orgId", org.getId());
        }
        String orgName = org.getName();
        String times = DateUtil.getCurrentTime((String)"yyyymmddhhmmss");
        List<Map<String, Object>> list = this.orgUserService.getOrgUserData(queryFilter);
        String path = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + orgName + "/" + times).replace("/", File.separator);
        String excelPath = path + File.separator;
        String excelName = "\u7ec4\u7ec7\u3010" + orgName + "\u3011\u76f8\u5173\u6570\u636e";
        this.exportExcel(list, orgName, excelName, excelPath);
        return excelPath + excelName;
    }

    private <E> void exportExcel(List<E> list, String sheetName, String excelName, String excelPath) throws Exception {
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("fullName", "\u7528\u6237\u59d3\u540d");
        exportMaps.put("account", "\u7528\u6237\u8d26\u53f7");
        exportMaps.put("userNumber", "\u5de5\u53f7");
        exportMaps.put("userId", "\u7528\u6237ID");
        exportMaps.put("status", "\u7528\u6237\u72b6\u6001");
        exportMaps.put("mobile", "\u624b\u673a\u53f7\u7801");
        exportMaps.put("email", "\u90ae\u7bb1");
        exportMaps.put("orgName", "\u7ec4\u7ec7\u540d\u79f0");
        exportMaps.put("orgCode", "\u7ec4\u7ec7\u7f16\u7801");
        exportMaps.put("orgId", "\u7ec4\u7ec7ID");
        exportMaps.put("orgPath", "\u7ec4\u7ec7\u8def\u5f84");
        exportMaps.put("orgPathName", "\u8def\u5f84\u540d\u79f0");
        exportMaps.put("isMaster", "\u4e3b\u5c97\u4f4d");
        exportMaps.put("isCharge", "\u8d1f\u8d23\u4eba");
        exportMaps.put("relName", "\u5c97\u4f4d\u540d\u79f0");
        exportMaps.put("postCode", "\u5c97\u4f4d\u7f16\u7801");
        exportMaps.put("relId", "\u5c97\u4f4dID");
        exportMaps.put("isRelActive", "\u5c97\u4f4d\u662f\u5426\u6709\u6548");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)sheetName, (int)16, exportMaps, list);
        ExcelUtil.saveExcel((HSSFWorkbook)book, (String)excelName, (String)excelPath);
    }

    @Override
    public List<Map<String, String>> getPathNames(List<String> userIds) {
        return ((OrgDao)this.baseMapper).getPathNames(userIds);
    }

    @Override
    public Map<String, Set<String>> getChildrenIds(Map<String, String> ids) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        if (com.hotent.base.util.BeanUtils.isNotEmpty(ids)) {
            for (String key : ids.keySet()) {
                String idStr = ids.get(key);
                if (StringUtil.isEmpty((String)idStr)) continue;
                String[] idArray = idStr.split(",");
                QueryFilter filter1 = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                filter1.addFilter("ID_", (Object)idArray, QueryOP.IN);
                List orgs = this.queryNoPage(filter1);
                if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgs)) continue;
                HashMap<String, String> pathMap = new HashMap<String, String>();
                for (int i = 0; i < orgs.size(); ++i) {
                    pathMap.put(String.valueOf(i + 1), ((Org)orgs.get(i)).getPath());
                }
                List<String> childrenIds = ((OrgDao)this.baseMapper).getChildrenIds(pathMap);
                resultMap.put(key, new HashSet<String>(childrenIds));
            }
        }
        return resultMap;
    }

    @Override
    public Org getOrgMaster(String account) {
        List<Org> orglist = ((OrgDao)this.baseMapper).getOrgMaster(account);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orglist)) {
            return orglist.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgFromExterUni(Org orgVo) {
        List<Org> orgList;
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgVo.getName())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u540d\u79f0\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgVo.getCode())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (orgVo.getCode().contains(",")) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgVo.getDemId())) {
            Demension defaultDem = this.demensionService.getDefaultDemension();
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)defaultDem)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u672c\u7cfb\u7edf\u65e0\u9ed8\u8ba4\u7ef4\u5ea6");
            }
            orgVo.setDemId(defaultDem.getId());
        } else {
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)dem)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId[" + orgVo.getDemId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
            }
        }
        Org o = this.getByCode(orgVo.getCode());
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)o)) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801[" + orgVo.getCode() + "]\u5df2\u5b58\u5728\uff01");
        }
        if (this.ucOrgUniteManager.exist(orgVo)) {
            return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u672c\u5730\u5df2\u5b58\u5728\u5173\u8054\u7ec4\u7ec7\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPathName()) && !CollectionUtils.isEmpty(orgList = this.getByPathNameAndDem(orgVo.getPathName(), orgVo.getDemId()))) {
            UcOrgUnite ucOrgUnite = new UcOrgUnite();
            ucOrgUnite.setFlybookId(orgVo.getFlybookId());
            ucOrgUnite.setWxWorkId(orgVo.getWxWorkId());
            ucOrgUnite.setDingtalkId(orgVo.getDingtalkId());
            ucOrgUnite.setOrgId(orgList.get(0).getId());
            this.ucOrgUniteManager.updateOrgUnite(ucOrgUnite);
            return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
        }
        String parentOrgId = this.ucOrgUniteManager.getOrgParentId(orgVo);
        Org pOrg = null;
        if (!"0".equals(parentOrgId) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)parentOrgId)) {
            pOrg = this.get((Serializable)((Object)parentOrgId));
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId[" + orgVo.getParentId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
        }
        o = new Org();
        o.setId(UniqueIdUtil.getSuid());
        o.setCode(orgVo.getCode());
        o.setName(orgVo.getName());
        o.setDemId(orgVo.getDemId());
        o.setOrderNo(orgVo.getOrderNo());
        o.setParentId(parentOrgId);
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)pOrg)) {
            o.setPathName("/" + orgVo.getName());
            o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
        }
        this.create((Model)o);
        UcOrgUnite ucOrgUnite = new UcOrgUnite();
        ucOrgUnite.setFlybookId(orgVo.getFlybookId());
        ucOrgUnite.setWxWorkId(orgVo.getWxWorkId());
        ucOrgUnite.setDingtalkId(orgVo.getDingtalkId());
        ucOrgUnite.setOrgId(o.getId());
        this.ucOrgUniteManager.updateOrgUnite(ucOrgUnite);
        return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<Org> getOrgsByparentId(String parentId) {
        if (StringUtil.isEmpty((String)parentId)) {
            parentId = "0";
        }
        return ((OrgDao)this.baseMapper).getByParentId(parentId);
    }

    @Override
    public List<Org> getOrgsExternalNotSync(Integer externalType) {
        return null;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgDao)this.baseMapper).removePhysical();
    }

    public Org get(Serializable id) {
        return ((OrgDao)this.baseMapper).get(id);
    }

    @Override
    public List<String> getSubOrgByIds(Set<String> parentIds) {
        List<String> list = this.getSubOrgIds(parentIds);
        if (CollectionUtils.isNotEmpty(list)) {
            List<String> listSub = this.getSubOrgByIds(new HashSet<String>(list));
            if (CollectionUtils.isNotEmpty(list)) {
                list.addAll(listSub);
            }
        }
        return list;
    }

    private List<String> getSubOrgIds(Set<String> parentIds) {
        if (parentIds.isEmpty()) {
            return new ArrayList<String>();
        }
        return ((OrgDao)this.baseMapper).getSubOrgByIds(parentIds);
    }

    @Override
    public List<Map<String, Object>> getOrgIdMapByUserId(String userId) {
        return ((OrgDao)this.baseMapper).getOrgIdMapByUserId(userId);
    }

    @Override
    public CommonResult<Org> getFillOrg(String demId, String grade) {
        String userId = ContextUtil.getCurrentUserId();
        Org curOrg = this.getMainGroup(userId, demId);
        Org gradeOrg = null;
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)curOrg)) {
            gradeOrg = grade.equals(curOrg.getGrade()) ? curOrg : this.getPOrgByGread(curOrg.getParentId(), grade);
        } else {
            return new CommonResult(false, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4e3b\u7ec4\u7ec7\u5931\u8d25\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)gradeOrg)) {
            return new CommonResult(false, "\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d\uff01");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)gradeOrg);
    }

    private Org getPOrgByGread(String orgId, String grade) {
        Org org = this.get((Serializable)((Object)orgId));
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org) && !grade.equals(org.getGrade())) {
            return this.getPOrgByGread(org.getParentId(), grade);
        }
        return org;
    }

    @Override
    public Map<String, Org> getParentMainOrg(String userId) {
        String path;
        List ids;
        List list;
        HashMap<String, Org> map = new HashMap<String, Org>();
        Org org = this.getMainGroup(userId, "");
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)(list = ((OrgDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"ID_", ids = Arrays.asList((path = org.getPath()).split("\\.")).stream().map(s -> s.trim()).collect(Collectors.toList())))))) {
            list.forEach(item -> {
                String grade = item.getGrade() == null ? "" : item.getGrade();
                map.put(grade, (Org)item);
            });
        }
        return map;
    }

    @Override
    public OrgParams getParamById(String orgId, String alias) {
        return this.orgParamsService.getByOrgIdAndAlias(orgId, alias);
    }

    @Override
    public boolean isOrgHasParamKey(String orgId, String alias) {
        OrgParams byOrgIdAndAlias = this.orgParamsDao.getByOrgIdAndAlias(orgId, alias);
        return !com.hotent.base.util.BeanUtils.isEmpty((Object)byOrgIdAndAlias);
    }

    @Override
    public boolean hasOrgParamKey(String grade, String userId, String alias) throws Exception {
        OrgParams p;
        Map<String, Org> map = this.getParentMainOrg(userId);
        return map.containsKey(grade) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)(p = this.orgParamsService.getByOrgIdAndAlias(map.get(grade).getId(), alias)));
    }

    @Override
    public List<Org> getOrgListByCodes(List<String> list) {
        return ((OrgDao)this.baseMapper).getOrgListByCodes(list);
    }

    @Override
    public List<Org> getByPathNames(List<String> pathNames) {
        return ((OrgDao)this.baseMapper).getPathNameList(pathNames);
    }

    @Override
    public boolean insertBatch(List<Org> list) {
        return this.saveBatch(list);
    }

    @Override
    public List<Org> getParantMainOrgAll(String userId) throws IOException {
        String orgStr = this.orgUserService.getCacheByKeyOrgPost(userId);
        Org org = null;
        if (StringUtil.isNotEmpty((String)orgStr)) {
            Map stringObjectMap = JsonUtil.toMap((String)orgStr);
            Map postMap = (Map)stringObjectMap.get("postCharge");
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)postMap)) {
                org = this.getByCode(postMap.get("orgcode").toString());
            }
        } else {
            org = this.getMainGroup(userId, "");
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org)) {
            String path = org.getPath();
            List ids = Arrays.asList(path.split("\\.")).stream().map(s -> s.trim()).collect(Collectors.toList());
            List list = ((OrgDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"ID_", ids));
            return list;
        }
        return new ArrayList<Org>();
    }

    @Override
    public List<User> getChargesByOrgId(String orgId, Boolean isMain, Boolean demCode) throws Exception {
        List<OrgUser> orgUsers;
        ArrayList<User> users = new ArrayList<User>();
        Org org = this.get((Serializable)((Object)orgId));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)(org = this.getByCode(orgId)))) {
            orgId = org.getId();
        }
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgUsers = this.orgUserManager.getChargesByOrgId(orgId, isMain))) {
            HashSet<String> userIds = new HashSet<String>();
            for (OrgUser orgUser : orgUsers) {
                User user;
                if (userIds.contains(orgUser.getUserId()) || !com.hotent.base.util.BeanUtils.isNotEmpty((Object)(user = (User)this.userService.get((Serializable)((Object)orgUser.getUserId()))))) continue;
                userIds.add(orgUser.getUserId());
                users.add(user);
            }
        }
        return users;
    }

    @Override
    public List<OrgTree> getOrgTreeByParentAndDem(OrgTreeVo params) throws Exception {
        OrgTree root;
        QueryFilter filter = QueryFilter.build();
        String demId = "";
        if (StringUtil.isNotEmpty((String)params.getDemId())) {
            demId = params.getDemId();
            filter.addParams("demId", (Object)demId);
        }
        String parentId = "0";
        if (StringUtil.isNotEmpty((String)params.getParentId())) {
            filter.addParams("parentId", (Object)(" ('" + params.getParentId() + "') "));
        } else if (StringUtil.isNotEmpty((String)params.getOrgId())) {
            filter.addParams("orgId", (Object)params.getOrgId());
        } else {
            parentId = AuthFilterUtil.getOrgAuthParentId(demId);
            filter.addParams("parentId", (Object)parentId);
        }
        String authSql = AuthFilterUtil.getOrgAuthSql(demId);
        if (StringUtil.isNotEmpty((String)authSql)) {
            filter.addParams("authSql", (Object)authSql);
        }
        if (StringUtil.isNotEmpty((String)params.getShowStatus())) {
            filter.addParams("showStatus", (Object)params.getShowStatus());
        }
        List<Org> list = null;
        if (StringUtil.isNotEmpty((String)params.getDeep())) {
            parentId = StringUtil.isNotEmpty((String)params.getParentId()) ? params.getParentId() : "0";
            filter.getParams().remove("parentId");
            Org parent = this.get((Serializable)((Object)parentId));
            filter.addParams("path", (Object)(parent.getPath() + "%"));
            list = this.getByParentAndDem(filter);
            list.removeIf(org -> org.getId().equals(parent.getId()));
        } else {
            list = this.getByParentAndDem(filter);
        }
        if (StringUtil.isNotEmpty((String)authSql)) {
            OrgUtil.dealRepeatAuthRoot(list);
        }
        ArrayList<OrgTree> groupTreeList = new ArrayList<OrgTree>();
        Locale locale = LocaleContextHolder.getLocale();
        for (Org group : list) {
            List<OrgPost> postList;
            OrgTree groupTree = new OrgTree(group);
            if ("true".equals(params.getIsShowPost()) && !groupTree.isIsParent() && (postList = this.postService.getListByOrgId(groupTree.getId())).size() > 0) {
                groupTree.setIsParent(1);
            }
            if (StringUtil.isNotEmpty((String)params.getOrgId())) {
                groupTree.setIsPointParent(true);
            }
            groupTree.setName(I18nUtil.handleI18nMessage((String)String.format("org.%s", groupTree.getCode()), (String)groupTree.getName(), (Locale)locale));
            groupTreeList.add(groupTree);
        }
        if (StringUtil.isNotEmpty((String)params.getDemId()) && StringUtil.isEmpty((String)params.getParentId())) {
            root = new OrgTree();
            Demension d = (Demension)this.demService.get((Serializable)((Object)params.getDemId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)d)) {
                root.setId("0");
                if (com.hotent.base.util.BeanUtils.isNotEmpty(groupTreeList)) {
                    root.setIsParent(1);
                } else {
                    root.setIsParent(0);
                }
                root.setDemId(d.getId());
                root.setName(I18nUtil.handleI18nMessage((String)String.format("org.%s", d.getDemCode()), (String)d.getDemName()));
                root.setParentId("0");
            }
            groupTreeList.add(root);
        } else if ("true".equals(params.getIsOrgAuth())) {
            root = new OrgTree();
            Org org2 = this.get((Serializable)((Object)params.getParentId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org2)) {
                root = new OrgTree(org2);
                if (org2.isIsParent()) {
                    root.setAuthRoot(true);
                }
            }
            groupTreeList.add(root);
        }
        if ("true".equals(params.getIsShowPost()) && StringUtil.isNotEmpty((String)params.getParentId())) {
            List<OrgPost> postList = this.postService.getListByOrgId(params.getParentId());
            for (OrgPost orgPost : postList) {
                OrgTree postTree = new OrgTree(orgPost);
                postTree.setDemId(params.getDemId());
                postTree.setPost(true);
                groupTreeList.add(postTree);
            }
        }
        return groupTreeList;
    }

    @Override
    public PageList<OrgTree> getOrgTreeByParentAndDemPage(QueryFilter queryFilter) throws Exception {
        List<Map<String, Object>> maps;
        OrgTree root;
        String authSql;
        OrgTreeVo params = new OrgTreeVo();
        Map param = queryFilter.getParams();
        BeanUtils.populate((Object)params, (Map)param);
        QueryFilter filter = QueryFilter.build();
        filter.setPageBean(queryFilter.getPageBean());
        filter.setQuerys(queryFilter.getQuerys());
        String demId = "";
        if (StringUtil.isNotEmpty((String)params.getDemId())) {
            demId = params.getDemId();
            filter.addParams("demId", (Object)demId);
        }
        String parentId = "0";
        if (StringUtil.isNotEmpty((String)params.getParentId())) {
            filter.addParams("parentId", (Object)(" ('" + params.getParentId() + "') "));
        } else {
            parentId = AuthFilterUtil.getOrgAuthParentId(demId);
            filter.addParams("parentId", (Object)parentId);
        }
        if (StringUtil.isNotEmpty((String)params.getShowStatus())) {
            filter.addParams("showStatus", (Object)params.getShowStatus());
        }
        if (StringUtil.isNotEmpty((String)(authSql = AuthFilterUtil.getOrgAuthSql(demId)))) {
            filter.addParams("authSql", (Object)authSql);
        }
        IPage<Org> iPage = this.getByParentAndDemPage(filter);
        List list = iPage.getRecords();
        if (StringUtil.isNotEmpty((String)authSql)) {
            OrgUtil.dealRepeatAuthRoot(list);
        }
        ArrayList<OrgTree> groupTreeList = new ArrayList<OrgTree>();
        Locale locale = LocaleContextHolder.getLocale();
        for (Org group : list) {
            List<OrgPost> postList;
            OrgTree groupTree = new OrgTree(group);
            if ("true".equals(params.getIsShowPost()) && !groupTree.isIsParent() && (postList = this.postService.getListByOrgId(groupTree.getId())).size() > 0) {
                groupTree.setIsParent(1);
            }
            if (StringUtil.isNotEmpty((String)params.getOrgId())) {
                groupTree.setIsPointParent(true);
            }
            groupTree.setName(I18nUtil.handleI18nMessage((String)String.format("org.%s", groupTree.getCode()), (String)groupTree.getName(), (Locale)locale));
            groupTreeList.add(groupTree);
        }
        if (StringUtil.isNotEmpty((String)params.getDemId()) && StringUtil.isEmpty((String)params.getParentId())) {
            root = new OrgTree();
            Demension d = (Demension)this.demService.get((Serializable)((Object)params.getDemId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)d)) {
                root.setId("0");
                if (com.hotent.base.util.BeanUtils.isNotEmpty(groupTreeList)) {
                    root.setIsParent(1);
                } else {
                    root.setIsParent(0);
                }
                root.setDemId(d.getId());
                root.setName(I18nUtil.handleI18nMessage((String)String.format("org.%s", d.getDemCode()), (String)d.getDemName()));
                root.setParentId("0");
            }
            groupTreeList.add(root);
        } else if ("true".equals(params.getIsOrgAuth())) {
            root = new OrgTree();
            Org org = this.get((Serializable)((Object)params.getParentId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org)) {
                root = new OrgTree(org);
                if (org.isIsParent()) {
                    root.setAuthRoot(true);
                }
            }
            groupTreeList.add(root);
        }
        if ("true".equals(params.getIsShowPost()) && StringUtil.isNotEmpty((String)params.getParentId())) {
            List<OrgPost> postList = this.postService.getListByOrgId(params.getParentId());
            for (OrgPost orgPost : postList) {
                OrgTree postTree = new OrgTree(orgPost);
                postTree.setDemId(params.getDemId());
                postTree.setPost(true);
                groupTreeList.add(postTree);
            }
        }
        if (params.getIsCountUser() && com.hotent.base.util.BeanUtils.isNotEmpty(groupTreeList)) {
            HashMap orgMap = Maps.newHashMap();
            maps = ((OrgDao)this.baseMapper).countUserByOrg(groupTreeList);
            maps.forEach(item -> orgMap.put(MapUtil.getStringIgnoreKey((Map)item, (String)"orgId", (String)""), Integer.valueOf(MapUtil.getStringIgnoreKey((Map)item, (String)"count", (String)"0"))));
            groupTreeList.forEach(item -> item.setUserNumber((Integer)orgMap.get(item.getId())));
        }
        if (params.getIsCountPost() && com.hotent.base.util.BeanUtils.isNotEmpty(groupTreeList)) {
            HashMap orgPostMap = Maps.newHashMap();
            maps = ((OrgDao)this.baseMapper).countPostByOrg(groupTreeList);
            maps.forEach(item -> orgPostMap.put(MapUtil.getStringIgnoreKey((Map)item, (String)"orgId", (String)""), Integer.valueOf(MapUtil.getStringIgnoreKey((Map)item, (String)"count", (String)"0"))));
            groupTreeList.forEach(item -> item.setPostNumber((Integer)orgPostMap.get(item.getId())));
        }
        PageList orgTreePageList = new PageList(groupTreeList);
        orgTreePageList.setPage(iPage.getPages());
        orgTreePageList.setPageSize(iPage.getSize());
        orgTreePageList.setTotal(iPage.getTotal());
        return orgTreePageList;
    }

    @Override
    public List<OrgTree> getByParentAndDemToTree(OrgTreeVo params) throws Exception {
        OrgTree root;
        String authSql;
        QueryFilter filter = QueryFilter.build();
        String demId = "";
        if (StringUtil.isNotEmpty((String)params.getDemId())) {
            demId = params.getDemId();
            filter.addParams("demId", (Object)demId);
        }
        if (StringUtil.isNotEmpty((String)params.getShowStatus())) {
            filter.addParams("showStatus", (Object)params.getShowStatus());
        }
        if (StringUtil.isNotEmpty((String)(authSql = AuthFilterUtil.getOrgAuthSql(demId)))) {
            filter.addParams("authSql", (Object)authSql);
        }
        List<Org> list = this.getByParentAndDem(filter);
        if (StringUtil.isNotEmpty((String)authSql)) {
            OrgUtil.dealRepeatAuthRoot(list);
        }
        ArrayList<OrgTree> groupTreeList = new ArrayList<OrgTree>();
        for (Org group : list) {
            List<OrgPost> postList;
            OrgTree groupTree = new OrgTree(group);
            if ("true".equals(params.getIsShowPost()) && !groupTree.isIsParent() && (postList = this.postService.getListByOrgId(groupTree.getId())).size() > 0) {
                groupTree.setIsParent(1);
            }
            groupTreeList.add(groupTree);
        }
        if (StringUtil.isNotEmpty((String)params.getDemId()) && StringUtil.isEmpty((String)params.getParentId())) {
            root = new OrgTree();
            Demension d = (Demension)this.demService.get((Serializable)((Object)params.getDemId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)d)) {
                root.setId("0");
                if (com.hotent.base.util.BeanUtils.isNotEmpty(groupTreeList)) {
                    root.setIsParent(1);
                } else {
                    root.setIsParent(0);
                }
                root.setDemId(d.getId());
                root.setName(d.getDemName());
                root.setParentId("0");
            }
            groupTreeList.add(root);
        } else if ("true".equals(params.getIsOrgAuth())) {
            root = new OrgTree();
            Org org = this.get((Serializable)((Object)params.getParentId()));
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)org)) {
                root = new OrgTree(org);
                if (org.isIsParent()) {
                    root.setAuthRoot(true);
                }
            }
            groupTreeList.add(root);
        }
        if ("true".equals(params.getIsShowPost()) && StringUtil.isNotEmpty((String)params.getParentId())) {
            List<OrgPost> postList = this.postService.getListByOrgId(params.getParentId());
            for (OrgPost orgPost : postList) {
                OrgTree postTree = new OrgTree(orgPost);
                postTree.setDemId(params.getDemId());
                postTree.setPost(true);
                groupTreeList.add(postTree);
            }
        }
        return groupTreeList;
    }

    @Override
    public PageList<OrgUserPost> getOrgUserPage(QueryFilter<?> queryFilter) throws Exception {
        QueryFilter groupFilter = QueryFilter.build();
        List userByGroupList = this.orgUserService.getUserByGroupList(groupFilter);
        Page p = (Page)this.orgUserService.getUserByGroupPost(queryFilter);
        String orgId = "";
        ArrayList<String> userIds = new ArrayList<String>();
        if (p.getTotal() > 0L && !userByGroupList.isEmpty()) {
            for (Object user : p.getRecords()) {
                for (Map obj : userByGroupList) {
                    if (!Objects.equals(((OrgUserPost)user).getUserId(), MapUtil.getStringIgnoreKey((Map)obj, (String)"userId", (String)""))) continue;
                    String isMaster = MapUtil.getStringIgnoreKey((Map)obj, (String)"isMaster", (String)"");
                    String[] split = isMaster.split(",");
                    int count = 0;
                    Pattern pt = Pattern.compile("1");
                    Matcher m = pt.matcher(isMaster);
                    while (m.find()) {
                        ++count;
                    }
                    if (split.length > 1 && count > 1 || isMaster.contains("1") && !"1".equals(((OrgUserPost)user).getIsMaster())) {
                        ((OrgUserPost)user).setOtherPost(3);
                    } else if (split.length == 1) {
                        ((OrgUserPost)user).setOtherPost(1);
                    } else {
                        ((OrgUserPost)user).setOtherPost(2);
                    }
                    if (!StringUtil.isNotEmpty((String)((OrgUserPost)user).getRelName())) continue;
                    ((OrgUserPost)user).setRelNames(Arrays.asList(((OrgUserPost)user).getRelName().split(",")));
                }
                userIds.add(((OrgUserPost)user).getUserId());
                orgId = ((OrgUserPost)user).getOrgId();
            }
            if (com.hotent.base.util.BeanUtils.isNotEmpty(userIds)) {
                List orgUsers;
                QueryFilter orgUserQueryFilter = QueryFilter.build().withQuery(new QueryField("user_id_", userIds, QueryOP.IN)).withQuery(new QueryField("org_id_", (Object)orgId)).withSorter(new FieldSort("is_master_", Direction.DESC));
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)queryFilter.getQuerys())) {
                    for (Object query : queryFilter.getQuerys()) {
                        QueryField q = (QueryField)query;
                        if (!"pos_id_".equalsIgnoreCase(q.getProperty())) continue;
                        orgUserQueryFilter.withQuery(new QueryField(q.getProperty(), q.getValue()));
                        break;
                    }
                }
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)(orgUsers = this.orgUserService.queryNoPage(orgUserQueryFilter)))) {
                    HashMap<String, String> userOrgMap = new HashMap<String, String>();
                    for (OrgUser orgUser : orgUsers) {
                        if (userOrgMap.containsKey(orgUser.getUserId())) continue;
                        userOrgMap.put(orgUser.getUserId(), orgUser.getId());
                    }
                    for (OrgUserPost user : p.getRecords()) {
                        String userId = user.getUserId();
                        if (!com.hotent.base.util.BeanUtils.isNotEmpty(userOrgMap.get(userId))) continue;
                        user.setOrgUserId((String)userOrgMap.get(userId));
                    }
                }
            }
        }
        return new PageList((IPage)p);
    }

    @Override
    public Boolean isSupOrgByCurrMain(String userId, String demId, Integer level) throws Exception {
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(userId, demId);
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgUsers)) {
            OrgUser orgUser = orgUsers.get(0);
            String levelGroupId = orgUser.getOrgId();
            Org org = this.get((Serializable)((Object)levelGroupId));
            while (level > 0) {
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)(org = this.get((Serializable)((Object)org.getParentId()))))) {
                    levelGroupId = org.getId();
                    level = level - 1;
                    continue;
                }
                return false;
            }
            Org currentOrg = this.getMainGroup(userId, demId);
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)currentOrg)) {
                String groupId = currentOrg.getId();
                if (levelGroupId.equals(groupId)) {
                    return false;
                }
                if (StringUtil.isNotZeroEmpty((String)currentOrg.getParentId())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public PageList<Org> getOrgLimitByCodes(String codes) {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("code", (Object)codes, QueryOP.IN, FieldRelation.AND, "group_1");
        PageList query = this.query(queryFilter);
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)query) && com.hotent.base.util.BeanUtils.isNotEmpty((Object)query.getRows())) {
            for (Org org : query.getRows()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List list = this.orgUserDao.getUserNumByOrgCode(map);
                org.setNowNum(list.size());
            }
        }
        return query;
    }

    @Override
    public void exportUsers(String orgCode, Boolean isChildre) throws Exception {
        File file;
        String excelPath;
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        String path = this.exportData(orgCode, isChildre = Boolean.valueOf(com.hotent.base.util.BeanUtils.isEmpty((Object)isChildre) ? true : isChildre));
        if (StringUtil.isNotEmpty((String)path)) {
            excelPath = path + ".xls";
            file = new File(excelPath);
            if (!file.exists()) {
                throw new RuntimeException("\u751f\u6210Excel\u6587\u4ef6\u5931\u8d25\uff01");
            }
        } else {
            throw new RuntimeException("\u5bfc\u51fa\u7ec4\u7ec7\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String excelName = file.getName();
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)excelPath, (String)excelName);
        FileUtil.deleteFile((String)file.getParentFile().getPath());
    }

    @Override
    public List<User> getCustomLevelCharge(String userId, String level, boolean isMainCharge) throws Exception {
        List<Org> userOrg = this.getUserOrg(userId, "", true);
        List<User> chargesByOrg = new ArrayList<User>();
        if (com.hotent.base.util.BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = this.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getChargesByOrg(org.getCode(), isMainCharge);
            break;
        }
        return chargesByOrg;
    }

    @Override
    public Set<GroupIdentity> getCustomLevelPost(String userId, String level, String postCode) throws Exception {
        List<Org> userOrg = this.getUserOrg(userId, "", true);
        Set<GroupIdentity> chargesByOrg = new HashSet<GroupIdentity>();
        if (com.hotent.base.util.BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = this.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByPostCodeAndOrgCode(postCode, org.getCode());
            break;
        }
        return chargesByOrg;
    }

    @Override
    public Set<GroupIdentity> getCustomLevelJob(String userId, String level, String jobCode) throws Exception {
        List<Org> userOrg = this.getUserOrg(userId, "", true);
        Set<GroupIdentity> chargesByOrg = new HashSet<GroupIdentity>();
        if (com.hotent.base.util.BeanUtils.isEmpty(userOrg)) {
            return chargesByOrg;
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = this.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByJobCodeAndOrgCode(jobCode, org.getCode());
            break;
        }
        return chargesByOrg;
    }

    @Override
    public List<Map<String, Object>> getUserOrgNowNumByOrgIds(String orgIds) {
        String[] value;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (String orgId : value = orgIds.split(",")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> numMap = new HashMap<String, Object>();
            map.put("orgId", orgId);
            map.put("group", "true");
            List list = this.orgUserDao.getUserNumByOrgId(map);
            numMap.put("orgId", orgId);
            numMap.put("num", list.size());
            mapList.add(numMap);
        }
        return mapList;
    }

    @Override
    @Transactional
    public CommonResult<String> operatingUserOrgPost(Map<String, Object> mapObj) throws Exception {
        List accounts = (List)mapObj.get("accounts");
        String type = mapObj.get("type").toString();
        String msg = "\u7ec4\u7ec7\u5c97\u4f4d\u8f6c\u79fb\u6210\u529f";
        for (String account : accounts) {
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)mapObj.get("orgCodes"))) {
                List orgCodes = (List)mapObj.get("orgCodes");
                for (String code : orgCodes) {
                    OrgUserVo orgUserVo = new OrgUserVo();
                    orgUserVo.setAccount(account);
                    orgUserVo.setOrgCode(code);
                    User u = this.userService.getByAccount(orgUserVo.getAccount());
                    if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
                        throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
                    }
                    Org o = this.getByCode(orgUserVo.getOrgCode());
                    if (com.hotent.base.util.BeanUtils.isEmpty((Object)u)) {
                        throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("userId", u.getId());
                    map.put("orgId", o.getId());
                    List<OrgUser> list = this.orgUserService.getByParms(map);
                    if (!com.hotent.base.util.BeanUtils.isEmpty(list)) continue;
                    OrgUser orgUser = new OrgUser();
                    orgUser.setId(UniqueIdUtil.getSuid());
                    orgUser.setUserId(u.getId());
                    orgUser.setOrgId(o.getId());
                    orgUser.setIsRelActive(1);
                    if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUserVo.getIsCharge())) {
                        orgUser.setIsCharge(0);
                    } else {
                        orgUser.setIsCharge(orgUserVo.getIsCharge());
                    }
                    if (com.hotent.base.util.BeanUtils.isEmpty((Object)orgUserVo.getIsMaster())) {
                        orgUser.setIsMaster(0);
                    } else {
                        List<OrgUser> l;
                        orgUser.setIsMaster(orgUserVo.getIsMaster());
                        if (orgUserVo.getIsMaster() == 1 && com.hotent.base.util.BeanUtils.isNotEmpty(l = this.orgUserService.getOrgUserMaster(u.getId(), o.getDemId()))) {
                            OrgUser ou = l.get(0);
                            ou.setIsMaster(0);
                            this.orgUserService.update((Model)ou);
                        }
                    }
                    this.orgUserService.create((Model)orgUser);
                }
            }
            if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)mapObj.get("postCodes"))) continue;
            List postCodes = (List)mapObj.get("postCodes");
            for (String postCode : postCodes) {
                User u;
                OrgPost post = this.orgPostService.getByCode(postCode);
                if (com.hotent.base.util.BeanUtils.isEmpty((Object)post)) {
                    throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
                }
                Org org = this.get((Serializable)((Object)post.getOrgId()));
                if (org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgCode", org.getCode());
                    map.put("group", "true");
                    List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                    if (org.getLimitNum() <= list.size()) {
                        return new CommonResult(false, "\u4eba\u6570\u8d85\u51fa\u7ec4\u7ec7\u4e0a\u9650\uff0c\u4e0d\u4e88\u6dfb\u52a0", null);
                    }
                }
                if (com.hotent.base.util.BeanUtils.isEmpty((Object)(u = this.userService.getByAccount(account)))) {
                    throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
                }
                OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"ORG_ID_", (Object)post.getOrgId());
                queryWrapper.eq((Object)"USER_ID_", (Object)u.getId());
                List list = this.orgUserService.listMaps((Wrapper)queryWrapper);
                if (!com.hotent.base.util.BeanUtils.isEmpty((Object)ou)) continue;
                for (int i = 0; i < list.size(); ++i) {
                    if (!ObjectUtils.isEmpty(((Map)list.get(i)).get("relId"))) continue;
                    if (com.hotent.base.util.BeanUtils.isNotEmpty(((Map)list.get(i)).get("ID_"))) {
                        this.delOrgUser(((Map)list.get(i)).get("ID_").toString());
                        break;
                    }
                    this.delOrgUser(((Map)list.get(i)).get("id_").toString());
                    break;
                }
                ou = new OrgUser();
                ou.setId(UniqueIdUtil.getSuid());
                ou.setUserId(u.getId());
                ou.setIsCharge(0);
                ou.setIsMaster(0);
                ou.setIsRelActive(1);
                ou.setOrgId(post.getOrgId());
                ou.setRelId(post.getId());
                this.orgUserService.create((Model)ou);
            }
        }
        if ("2".equals(type)) {
            msg = "\u7ec4\u7ec7\u5c97\u4f4d\u590d\u5236\u6210\u529f";
        } else {
            List orgUserIds = (List)mapObj.get("orgUserIds");
            StringBuilder str = new StringBuilder();
            for (String id : orgUserIds) {
                OrgUser obj = (OrgUser)this.orgUserService.get((Serializable)((Object)id));
                if (!com.hotent.base.util.BeanUtils.isNotEmpty((Object)obj)) continue;
                this.userUnderService.delByUserIdAndOrgId(obj.getUserId(), obj.getOrgId());
            }
            this.orgUserService.removeByIds(orgUserIds);
        }
        return new CommonResult(true, msg, (Object)"");
    }

    @Override
    public void removeUserMenuByOrgId(String orgId) {
        try {
            List<User> userListByOrgId = this.userManager.getUserListByOrgId(orgId);
            if (CollectionUtils.isNotEmpty(userListByOrgId)) {
                for (User user : userListByOrgId) {
                    this.roleManager.delUserMenuCacheByUserId(user.getUserId());
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    @Override
    public CommonResult<String> delOrgUserByUserIds(String ids) throws Exception {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException("id\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] userIds = ids.split(",");
        ArrayList<String> removeIds = new ArrayList<String>();
        Boolean isDele = false;
        StringBuilder str = new StringBuilder();
        for (String orgId : userIds) {
            OrgUser orgUser = (OrgUser)this.orgUserService.get((Serializable)((Object)orgId));
            if (orgUser == null) continue;
            QueryFilter build = QueryFilter.build();
            build.addQueryField(new QueryField("USER_ID_", (Object)orgUser.getUserId()));
            build.addQueryField(new QueryField("ORG_ID_", (Object)orgUser.getOrgId()));
            List orgUsers = this.orgUserService.queryNoPage(build);
            for (OrgUser user : orgUsers) {
                if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)user)) {
                    this.removeCache(user);
                    isDele = true;
                    removeIds.add(user.getId());
                    continue;
                }
                str.append(user.getUserId());
                str.append("\uff0c");
            }
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff01" : "\u90e8\u5206\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff0cid\u4e3a\uff1a" + str.toString() + "\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01";
        String[] removeArr = new String[removeIds.size()];
        for (int i = 0; i < removeArr.length; ++i) {
            removeArr[i] = (String)removeIds.get(i);
        }
        this.orgUserService.removeByIds(removeArr);
        return new CommonResult(isDele.booleanValue(), msg, (Object)"");
    }

    @Override
    public User getMainGroupUser(String userId, String demId) {
        Org org = this.getMainGroup(userId, demId);
        String id = org.getId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ORG_ID_", (Object)id);
        wrapper.ge((Object)"IS_CHARGE_", (Object)1);
        List list = this.orgUserManager.list((Wrapper)wrapper);
        String resultId = "";
        for (OrgUser orgUser : list) {
            if (orgUser.getIsCharge() != 2) continue;
            resultId = orgUser.getUserId();
        }
        for (OrgUser orgUser : list) {
            if (!"".equals(resultId) || orgUser.getIsCharge() != 1) continue;
            resultId = orgUser.getUserId();
        }
        return (User)this.userManager.getById((Serializable)((Object)resultId));
    }

    @Override
    public Org getUserOrgsByDefaultDemension() {
        List<Org> userOrg;
        Demension defaultDemension = this.demensionService.getDefaultDemension();
        if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)defaultDemension) && com.hotent.base.util.BeanUtils.isNotEmpty(userOrg = this.getUserOrg(ContextUtil.getCurrentUserId(), defaultDemension.getId(), true))) {
            return userOrg.get(0);
        }
        return null;
    }

    @Override
    public Map<String, ObjectNode> getOrgAndPostByUserIds(List<String> userIds) {
        HashMap result = Maps.newHashMap();
        List<OrgUser> orgUsers = ((OrgDao)this.baseMapper).getOrgAndPostByUserIds(userIds);
        if (com.hotent.base.util.BeanUtils.isEmpty(orgUsers)) {
            return result;
        }
        List demId = orgUsers.stream().map(OrgUser::getDemId).collect(Collectors.toList());
        Map<Object, Object> dimensionMap = new HashMap();
        if (com.hotent.base.util.BeanUtils.isNotEmpty(demId)) {
            dimensionMap = this.demensionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Demension::getId, demId)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().collect(Collectors.toMap(Demension::getId, dimension -> dimension));
        }
        List postIds = orgUsers.stream().map(OrgUser::getPostId).collect(Collectors.toList());
        Map<Object, Object> postMap = new HashMap();
        if (com.hotent.base.util.BeanUtils.isNotEmpty(postIds)) {
            postMap = this.postService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OrgPost::getId, postIds)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().collect(Collectors.toMap(OrgPost::getId, orgPost -> orgPost));
        }
        for (OrgUser orgUser : orgUsers) {
            if (dimensionMap.containsKey(orgUser.getDemId())) {
                Demension dimension2 = (Demension)dimensionMap.get(orgUser.getDemId());
                orgUser.setDemDefault(dimension2.getIsDefault());
            }
            if (!postMap.containsKey(orgUser.getPostId())) continue;
            OrgPost orgPost2 = (OrgPost)postMap.get(orgUser.getPostId());
            orgUser.setPostName(orgPost2.getName());
            orgUser.setPostCharge(orgPost2.getIsCharge());
        }
        orgUsers = orgUsers.stream().sorted(Comparator.comparing(OrgUser::getPostCharge).reversed()).sorted(Comparator.comparing(OrgUser::getIsMaster).reversed()).sorted(Comparator.comparing(OrgUser::getDemDefault).reversed()).sorted(Comparator.comparing(OrgUser::getUserId).reversed()).collect(Collectors.toList());
        String curOrgId = "";
        for (OrgUser orgUser : orgUsers) {
            ObjectNode userPostNode;
            ArrayNode arrayNode;
            ObjectNode userOrgPostNode = null;
            if (!result.containsKey(orgUser.getUserId())) {
                curOrgId = orgUser.getOrgId();
                userOrgPostNode = JsonUtil.createObjectNode();
                if (StringUtil.isNotEmpty((String)orgUser.getOrgName())) {
                    ObjectNode userOrgNode = JsonUtil.createObjectNode();
                    userOrgNode.put("orgName", orgUser.getOrgName());
                    userOrgPostNode.put("org", (JsonNode)userOrgNode);
                }
                userOrgPostNode.put("account", orgUser.getAccount());
                if (StringUtil.isNotEmpty((String)orgUser.getPostName())) {
                    arrayNode = JsonUtil.createArrayNode();
                    userPostNode = JsonUtil.createObjectNode();
                    userPostNode.put("postName", orgUser.getPostName());
                    arrayNode.add((JsonNode)userPostNode);
                    userOrgPostNode.put("post", (JsonNode)arrayNode);
                }
                result.put(orgUser.getUserId(), userOrgPostNode);
                continue;
            }
            if (curOrgId == null || !curOrgId.equals(orgUser.getOrgId())) continue;
            userOrgPostNode = (ObjectNode)result.get(orgUser.getUserId());
            if (!StringUtil.isNotEmpty((String)orgUser.getPostName())) continue;
            ArrayNode arrayNode2 = arrayNode = com.hotent.base.util.BeanUtils.isNotEmpty((Object)userOrgPostNode.get("post")) ? (ArrayNode)userOrgPostNode.get("post") : JsonUtil.createArrayNode();
            if (arrayNode.size() >= 2) continue;
            userPostNode = JsonUtil.createObjectNode();
            userPostNode.put("postName", orgUser.getPostName());
            arrayNode.add((JsonNode)userPostNode);
            userOrgPostNode.put("post", (JsonNode)arrayNode);
            result.put(orgUser.getUserId(), userOrgPostNode);
        }
        return result;
    }

    @Override
    public CommonResult<String> batchUpdateOrgJob(OrgJobVo orgJobVo) {
        OrgJob job = this.orgJobService.getByCode(orgJobVo.getJobCode());
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty(orgJobVo.getCodes())) {
            throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().in(OrgPost::getCode, orgJobVo.getCodes())).set(OrgPost::getRelDefId, (Object)job.getId());
        this.orgPostService.update((Wrapper)updateWrapper);
        return new CommonResult(true, "\u5c97\u4f4d\u804c\u52a1\u4fee\u6539\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public CommonResult<String> batchUpdatePostOrg(OrgJobVo orgJobVo) {
        if (StringUtils.isEmpty((CharSequence)orgJobVo.getOrgId())) {
            return new CommonResult(false, "\u7ec4\u7ec7\u5fc5\u586b", (Object)"");
        }
        if (com.hotent.base.util.BeanUtils.isEmpty(orgJobVo.getCodes())) {
            throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = (Org)this.getById((Serializable)((Object)orgJobVo.getOrgId()));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org)) {
            return new CommonResult(false, "\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object)"");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OrgPost::getCode, orgJobVo.getCodes());
        List orgPostIds = this.orgPostService.list((Wrapper)queryWrapper).stream().map(OrgPost::getId).collect(Collectors.toList());
        if (org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgCode", org.getCode());
            map.put("group", "true");
            List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
            if (org.getLimitNum() <= list.size()) {
                return new CommonResult(false, "\u5c97\u4f4d\u7ec4\u7ec7\u6240\u5c5e\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
            }
            HashSet<String> userIds = new HashSet<String>();
            for (Map<String, Object> l : list) {
                userIds.add((String)l.get("userId"));
            }
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("pos_id_", orgPostIds, QueryOP.IN);
            IPage<HashMap<String, Object>> userByGroup = this.orgUserService.getUserByGroup(queryFilter);
            HashSet<String> addUserIds = new HashSet<String>();
            if (com.hotent.base.util.BeanUtils.isNotEmpty(userByGroup)) {
                for (Map orgUser : userByGroup.getRecords()) {
                    if (userIds.contains(orgUser.get("userId"))) continue;
                    addUserIds.add((String)orgUser.get("userId"));
                }
            }
            if (org.getLimitNum() <= list.size() + addUserIds.size()) {
                return new CommonResult(false, "\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
            }
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().in(OrgUser::getRelId, orgPostIds)).set(OrgUser::getOrgId, (Object)orgJobVo.getOrgId());
        this.orgUserService.update((Wrapper)updateWrapper);
        UpdateWrapper orgPostWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)orgPostWrapper.lambda().in(OrgPost::getId, orgPostIds)).set(OrgPost::getOrgId, (Object)orgJobVo.getOrgId());
        this.orgPostService.update((Wrapper)orgPostWrapper);
        return new CommonResult(true, "\u5c97\u4f4d\u7ec4\u7ec7\u4fee\u6539\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public PageList<Object> getByParentAndUserPage(QueryFilter filter) throws Exception {
        PageList result = new PageList((List)Lists.newArrayList());
        result.setPage((long)filter.getPageBean().getPage().intValue());
        result.setPageSize((long)filter.getPageBean().getPageSize().intValue());
        Object dataType = filter.getParams().get("dataType");
        PageList<OrgTree> orgPageList = new PageList<OrgTree>();
        int userPageSize = filter.getPageBean().getPageSize();
        if (!"user".equals(dataType)) {
            filter.addParams("isCountUser", (Object)true);
            orgPageList = this.getOrgTreeByParentAndDemPage(filter);
            result.setTotal(orgPageList.getTotal());
            userPageSize = filter.getPageBean().getPageSize() - orgPageList.getRows().size();
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgPageList.getRows())) {
                for (OrgTree row : orgPageList.getRows()) {
                    Map rowMap = JsonUtil.toMap((String)JsonUtil.toJsonString((Object)row));
                    rowMap.put("dataType", "org");
                    result.getRows().add(rowMap);
                }
            }
        }
        if (userPageSize > 0 && !"org".equals(dataType)) {
            QueryFilter build = QueryFilter.build();
            build.setQuerys(filter.getQuerys());
            Object parentId = filter.getParams().get("parentId");
            if (parentId != null) {
                build.addQueryField(new QueryField("uo.id_", parentId));
            }
            int userPage = filter.getPageBean().getPage() - Integer.valueOf(orgPageList.getTotal() / (long)filter.getPageBean().getPageSize().intValue() + "");
            build.setPageBean(new PageBean(Integer.valueOf(userPage), Integer.valueOf(userPageSize)));
            PageList<UserSeletorDto> pageList = this.userManager.queryUserWithOrgPost(build);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(pageList)) {
                for (UserSeletorDto userSeletorDto : pageList.getRows()) {
                    userSeletorDto.setDataType("user");
                    result.getRows().add(userSeletorDto);
                }
            }
            result.setTotal(result.getTotal() + pageList.getTotal());
        }
        return result;
    }

    @Override
    public List<Org> getOrgByUserIds(List<String> userIds) {
        return ((OrgDao)this.baseMapper).getOrgByUserIds(userIds);
    }

    @Override
    public void calculateSubOrg(List<Org> orgs) {
        if (com.hotent.base.util.BeanUtils.isEmpty(orgs)) {
            return;
        }
        HashMap orgMap = Maps.newHashMap();
        List<Map<String, Object>> maps = ((OrgDao)this.baseMapper).countSubOrg(orgs);
        maps.forEach(item -> orgMap.put(MapUtil.getStringIgnoreKey((Map)item, (String)"orgId", (String)""), Integer.valueOf(MapUtil.getStringIgnoreKey((Map)item, (String)"count", (String)"0"))));
        orgs.forEach(item -> item.setSubOrgNumber((Integer)orgMap.get(item.getId()) - 1));
    }

    @Override
    public PageList<Object> getByParentAndPostPage(QueryFilter filter) throws Exception {
        PageList result = new PageList((List)Lists.newArrayList());
        result.setPage((long)filter.getPageBean().getPage().intValue());
        result.setPageSize((long)filter.getPageBean().getPageSize().intValue());
        Object dataType = filter.getParams().get("dataType");
        PageList<OrgTree> orgPageList = new PageList<OrgTree>();
        int postPageSize = filter.getPageBean().getPageSize();
        if (!"post".equals(dataType)) {
            filter.addParams("isCountPost", (Object)true);
            orgPageList = this.getOrgTreeByParentAndDemPage(filter);
            result.setTotal(orgPageList.getTotal());
            postPageSize = filter.getPageBean().getPageSize() - orgPageList.getRows().size();
            if (com.hotent.base.util.BeanUtils.isNotEmpty((Object)orgPageList.getRows())) {
                for (OrgTree row : orgPageList.getRows()) {
                    Map rowMap = JsonUtil.toMap((String)JsonUtil.toJsonString((Object)row));
                    rowMap.put("dataType", "org");
                    result.getRows().add(rowMap);
                }
            }
        }
        if (postPageSize > 0 && !"org".equals(dataType)) {
            QueryFilter build = QueryFilter.build();
            build.setQuerys(filter.getQuerys());
            Object parentId = filter.getParams().get("parentId");
            if (parentId != null) {
                build.addQueryField(new QueryField("o.id_", parentId));
            }
            int postPage = filter.getPageBean().getPage() - Integer.valueOf(orgPageList.getTotal() / (long)filter.getPageBean().getPageSize().intValue() + "");
            build.setPageBean(new PageBean(Integer.valueOf(postPage), Integer.valueOf(postPageSize)));
            PageList<OrgPost> orgPosts = this.orgPostService.getOrgPost(build);
            if (com.hotent.base.util.BeanUtils.isNotEmpty(orgPosts)) {
                for (OrgPost orgPost : orgPosts.getRows()) {
                    Map rowMap = JsonUtil.toMap((String)JsonUtil.toJson((Object)orgPost));
                    rowMap.put("dataType", "post");
                    result.getRows().add(rowMap);
                }
            }
            result.setTotal(result.getTotal() + orgPosts.getTotal());
        }
        return result;
    }

    @Override
    public List<Org> getOrgsByCharge(String userId, int type) {
        return ((OrgDao)this.baseMapper).getOrgsByCharge(userId, type);
    }

    @Override
    public List<User> getCustomLevelAndViaOrgId(String level, String orgId) {
        Set userIds;
        List<User> list = new ArrayList<User>();
        Org org = this.get((Serializable)((Object)orgId));
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)org) || StringUtil.isEmpty((String)org.getPath())) {
            return list;
        }
        List idList = CollUtil.list((boolean)false, (Object[])org.getPath().split("\\."));
        List orgList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Org::getId, (Collection)idList)).or()).likeRight(Org::getPath, (Object)org.getPath())).select(new SFunction[]{Org::getId, Org::getGrade}));
        List orgIds = orgList.stream().filter(item -> level.equals(item.getGrade())).map(Org::getId).collect(Collectors.toList());
        if (com.hotent.base.util.BeanUtils.isNotEmpty(orgIds) && com.hotent.base.util.BeanUtils.isNotEmpty(userIds = this.orgUserManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(OrgUser::getOrgId, orgIds)).eq(OrgUser::getIsCharge, (Object)2)).select(new SFunction[]{OrgUser::getUserId})).stream().map(OrgUser::getUserId).collect(Collectors.toSet()))) {
            list = this.userManager.list((Wrapper)Wrappers.lambdaQuery().in(User::getId, userIds));
        }
        return list;
    }

    @Override
    public JsonNode getMainOrgByUserIdAndCurOrgId(String userId, String orgId) {
        ObjectNode objectNode = JsonUtil.createObjectNode();
        String START_USER_ORG_ID = "startUserOrgId";
        String START_USER_ORG_CODE = "startUserOrgCode";
        String START_USER_ORG_NAME = "startUserOrgName";
        String nullValue = null;
        objectNode.put(START_USER_ORG_ID, nullValue);
        objectNode.put(START_USER_ORG_CODE, nullValue);
        objectNode.put(START_USER_ORG_NAME, nullValue);
        if (StringUtil.isNotEmpty((String)orgId)) {
            List<OrgUser> orgUserMasterList;
            Org org = this.get((Serializable)((Object)orgId));
            if (org != null && StringUtil.isNotEmpty((String)org.getDemId()) && com.hotent.base.util.BeanUtils.isNotEmpty(orgUserMasterList = this.orgUserManager.getOrgUserMaster(userId, org.getDemId()))) {
                Org orgMaster = this.get((Serializable)((Object)orgUserMasterList.get(0).getOrgId()));
                objectNode.put(START_USER_ORG_ID, orgMaster.getId());
                objectNode.put(START_USER_ORG_CODE, orgMaster.getCode());
                objectNode.put(START_USER_ORG_NAME, orgMaster.getName());
            }
        } else if (StringUtil.equals((String)userId, (String)ContextUtil.getCurrentUserId())) {
            objectNode.put(START_USER_ORG_ID, (String)Optional.ofNullable(ContextUtil.getCurrentUser()).map(user -> user.getAttrbuite("CURRENT_USER_MAIN_ORGID")).orElse(nullValue));
            objectNode.put(START_USER_ORG_CODE, (String)Optional.ofNullable(ContextUtil.getCurrentUser()).map(user -> user.getAttrbuite("CURRENT_USER_MAIN_ORGCODE")).orElse(nullValue));
            objectNode.put(START_USER_ORG_NAME, (String)Optional.ofNullable(ContextUtil.getCurrentUser()).map(user -> user.getAttrbuite("CURRENT_USER_MAIN_ORGNAME")).orElse(nullValue));
        }
        return objectNode;
    }

    @Override
    public List<Org> getByOrgParams(String code, String relation, String value) {
        if (StringUtil.isEmpty((String)code) || StringUtil.isEmpty((String)value)) {
            return new ArrayList<Org>();
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"uop.code_", (Object)code)).eq((Object)"uo.is_dele_", (Object)"0");
        if ("equals".equals(relation)) {
            wrapper.eq((Object)"uop.value_", (Object)value);
        } else if ("contains".equals(relation)) {
            wrapper.like((Object)"uop.value_", (Object)value);
        } else if ("belongTo".equals(relation)) {
            List list = Stream.of(value.split(",")).collect(Collectors.toList());
            wrapper.in((Object)"uop.value_", list);
        } else {
            return new ArrayList<Org>();
        }
        return ((OrgDao)this.baseMapper).getWithOrgParams((Wrapper<Org>)wrapper);
    }

    @Override
    public List<Org> getByIdsOrCodes(String idsOrCodes) {
        if (com.hotent.base.util.BeanUtils.isEmpty((Object)idsOrCodes)) {
            return new ArrayList<Org>();
        }
        List idOrCodeList = Stream.of(idsOrCodes.split(",")).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Org::getId, idOrCodeList)).or()).in(Org::getCode, idOrCodeList);
        return this.list((Wrapper)wrapper);
    }
}

