/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.OrgPostDao;
import com.hotent.uc.dao.OrgUserDao;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.FullnameVO;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgPostUser;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPostManagerImpl
extends BaseManagerImpl<OrgPostDao, OrgPost>
implements OrgPostManager {
    @Autowired
    OrgUserDao orgUserDao;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    OrgManager orgService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    DemensionManager demensionService;
    @Resource
    UserManager userManager;

    @Override
    public OrgPost getByCode(String code) {
        return ((OrgPostDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<OrgPost> getListByOrgId(String orgId) {
        return ((OrgPostDao)this.baseMapper).getListByOrgId(orgId);
    }

    @Override
    public List<OrgPost> queryInfoList(QueryFilter queryFilter) {
        return ((OrgPostDao)this.baseMapper).queryInfoList(queryFilter);
    }

    @Override
    public OrgPost getByOrgIdRelDefId(String orgId, String relDefId) {
        return ((OrgPostDao)this.baseMapper).getByOrgIdRelDefId(orgId, relDefId);
    }

    @Override
    public List<OrgPost> getListByUserId(String userId, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        if (StringUtil.isNotEmpty((String)demId)) {
            map.put("demId", demId);
        }
        return this.getRelListByParam(map);
    }

    @Override
    public List<OrgPost> getRelListByParam(Map<String, Object> map) {
        QueryFilter queryFilter = QueryFilter.build();
        if (BeanUtils.isNotEmpty(map)) {
            User user;
            if (map.containsKey("account") && BeanUtils.isNotEmpty((Object)map.get("account")) && BeanUtils.isNotEmpty((Object)(user = this.userManager.getByAccount(map.get("account").toString())))) {
                queryFilter.addFilter("orguser.USER_ID_", (Object)user.getId(), QueryOP.EQUAL);
            }
            if (map.containsKey("demId") && BeanUtils.isNotEmpty((Object)map.get("demId"))) {
                List<Org> orgList = this.orgService.getOrgListByDemId(map.get("demId").toString());
                List orgIds = orgList.stream().map(Org::getId).collect(Collectors.toList());
                queryFilter.addFilter("rel.ORG_ID_", orgIds, QueryOP.IN);
            }
            if (map.containsKey("userId") && BeanUtils.isNotEmpty((Object)map.get("userId")) && BeanUtils.isNotEmpty((Object)(user = (User)this.userManager.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getId, map.get("userId"))).eq(UcBaseModel::getIsDelete, (Object)"0"))))) {
                queryFilter.addFilter("orguser.USER_ID_", (Object)user.getId(), QueryOP.EQUAL);
            }
            if (map.containsKey("orgId") && BeanUtils.isNotEmpty((Object)map.get("orgId"))) {
                queryFilter.addFilter("rel.ORG_ID_", (Object)map.get("orgId").toString(), QueryOP.EQUAL);
            }
            if (map.containsKey("relDefId") && BeanUtils.isNotEmpty((Object)map.get("relDefId"))) {
                queryFilter.addFilter("rel.JOB_ID_", (Object)map.get("relDefId").toString(), QueryOP.EQUAL);
            }
        }
        return ((OrgPostDao)this.baseMapper).getRelListByParam((Wrapper<OrgPost>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<OrgPost> getListByAccount(String account, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", account);
        map.put("demId", demId);
        List<OrgPost> orgPosts = this.getRelListByParam(map);
        for (OrgPost orgPost : orgPosts) {
            Org org = (Org)this.orgService.get((Serializable)((Object)orgPost.getOrgId()));
            if (BeanUtils.isNotEmpty((Object)org)) {
                orgPost.setOrgName(org.getName());
                Demension dem = (Demension)this.demensionService.get((Serializable)((Object)org.getDemId()));
                if (BeanUtils.isNotEmpty((Object)dem)) {
                    orgPost.setDemName(dem.getDemName());
                }
            }
            OrgJob orgJob = (OrgJob)this.orgJobService.get((Serializable)((Object)orgPost.getRelDefId()));
            String postLevel = orgJob.getPostLevel();
            if (!BeanUtils.isNotEmpty((Object)orgJob)) continue;
            orgPost.setJobName(orgJob.getName());
            orgPost.setPostLevel(postLevel);
        }
        return orgPosts;
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            OrgPost rel = this.get((Serializable)((Object)id));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgId", rel.getOrgId());
            List<OrgUser> orgUserList = this.orgUserDao.getByParms(map);
            if (BeanUtils.isNotEmpty(orgUserList)) {
                this.removeOrgUser(rel, orgUserList);
                continue;
            }
            this.remove((Serializable)((Object)rel.getId()));
        }
    }

    @Transactional
    public void removeOrgUser(OrgPost rel, List<OrgUser> orgUserList) {
        for (OrgUser user : orgUserList) {
            OrgUser orgUser;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgId", rel.getOrgId());
            params.put("userId", user.getUserId());
            List<OrgUser> list = this.orgUserDao.getByParms(params);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", user.getUserId());
            map.put("relId", rel.getId());
            if (list.size() == 1 && rel.getId().equals(list.get(0).getRelId())) {
                orgUser = this.orgUserDao.getByParms(map).get(0);
                orgUser.setRelId(null);
                this.orgUserService.update((Model)orgUser);
            } else if (list.size() > 1 && BeanUtils.isNotEmpty(this.orgUserDao.getByParms(map))) {
                orgUser = this.orgUserDao.getByParms(map).get(0);
                this.orgUserService.remove((Serializable)((Object)orgUser.getId()));
            }
            this.remove((Serializable)((Object)rel.getId()));
        }
    }

    @Override
    public List<OrgPost> getByRelDefId(String relDefId) {
        return ((OrgPostDao)this.baseMapper).getByReldefId(relDefId);
    }

    @Override
    @Transactional
    public boolean setRelCharge(String id, boolean isCharge) {
        int charge = isCharge ? 1 : 0;
        ((OrgPostDao)this.baseMapper).updateRelCharge(id, charge, LocalDateTime.now());
        return true;
    }

    @Override
    @Transactional
    public boolean cancelRelCharge(String orgId) {
        ((OrgPostDao)this.baseMapper).cancelRelCharge(orgId, LocalDateTime.now());
        return true;
    }

    @Override
    public List<OrgPost> getRelCharge(String orgId, Boolean isCharge) {
        if (BeanUtils.isEmpty((Object)isCharge)) {
            return ((OrgPostDao)this.baseMapper).getRelChargeByOrgId(orgId, null);
        }
        Integer charge = isCharge != false ? 1 : 0;
        return ((OrgPostDao)this.baseMapper).getRelChargeByOrgId(orgId, charge);
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((OrgPostDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public PageList<OrgPost> getOrgPost(QueryFilter filter) {
        List dimensionList;
        PageBean pageBean = filter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        filter.addFilter("p.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        filter.addFilter("o.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<OrgPost> orgPost = ((OrgPostDao)this.baseMapper).getOrgPost((IPage<OrgPost>)page, (Wrapper<OrgPost>)this.convert2Wrapper(filter, this.currentModelClass()));
        List demIds = orgPost.getRecords().stream().map(OrgPost::getDemId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(demIds) && BeanUtils.isNotEmpty((Object)(dimensionList = this.demensionService.listByIds(demIds)))) {
            Map<String, String> dimensionMap = dimensionList.stream().collect(Collectors.toMap(Demension::getId, Demension::getName));
            for (OrgPost record : orgPost.getRecords()) {
                if (!dimensionMap.containsKey(record.getDemId())) continue;
                record.setDemName(dimensionMap.get(record.getDemId()));
            }
        }
        return new PageList(orgPost);
    }

    @Override
    public List<FullnameVO> getFullname(String postId) {
        return ((OrgPostDao)this.baseMapper).getFullname(postId);
    }

    @Override
    public List<Map<String, Object>> getPostByJobId(String postId) {
        return ((OrgPostDao)this.baseMapper).getPostByJobId(postId);
    }

    @Override
    public List<OrgPostUser> getUserByUserId(String userId) {
        List dimensionList;
        List<OrgPostUser> mapList = ((OrgPostDao)this.baseMapper).getUserByUserId(userId);
        List demIds = mapList.stream().map(OrgPostUser::getDemId).filter(BeanUtils::isNotEmpty).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(demIds) && BeanUtils.isNotEmpty((Object)(dimensionList = this.demensionService.listByIds(demIds)))) {
            Map<String, Demension> dimensionMap = dimensionList.stream().collect(Collectors.toMap(Demension::getId, dimension -> dimension));
            for (OrgPostUser map : mapList) {
                if (!BeanUtils.isNotEmpty((Object)map.getDemId()) || !dimensionMap.containsKey(map.getDemId())) continue;
                map.setDemName(dimensionMap.get(map.getDemId()).getDemName());
            }
        }
        this.orgJobService.fillJobToDataModel(mapList);
        return mapList;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgPostDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<OrgPost> getByReldefId(String jobId) {
        return ((OrgPostDao)this.baseMapper).getByReldefId(jobId);
    }

    @Override
    public List<OrgPost> getByReldefIds(String jobIds) {
        if (BeanUtils.isEmpty((Object)jobIds)) {
            return new ArrayList<OrgPost>();
        }
        return ((OrgPostDao)this.baseMapper).getByReldefIds(Arrays.asList(jobIds.split(",")));
    }

    @Override
    public Integer getCountByCode(String code) {
        return ((OrgPostDao)this.baseMapper).getCountByCode(code);
    }

    public OrgPost get(Serializable id) {
        return ((OrgPostDao)this.baseMapper).get(id);
    }

    @Override
    public Map<String, Object> getSuperiorPost(String userId) {
        List<OrgPostUser> list = this.getUserByUserId(userId);
        if (list.isEmpty()) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u67e5\u65e0\u5c97\u4f4d");
        }
        OrgPostUser post = null;
        if (list.size() == 1) {
            post = list.get(0);
        } else {
            for (OrgPostUser map : list) {
                Integer isMaster = map.getIsMaster();
                if (!BeanUtils.isNotEmpty((Object)isMaster) || isMaster != 1) continue;
                post = map;
            }
        }
        if (post == null) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u65e0\u4e3b\u5c97\u4f4d\u6216\u975e\u4e3b\u5c97\u4f4d\u4e0d\u6b62\u4e00\u4e2a");
        }
        String parentId = post.getParentId();
        if (StringUtil.isEmpty((String)parentId)) {
            throw new BaseException("userid=" + userId + "\u7528\u6237\u65e0\u4e0a\u7ea7\u5c97\u4f4d");
        }
        OrgPost orgPost = this.get((Serializable)((Object)parentId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", orgPost.getCode());
        result.put("name", orgPost.getName());
        return result;
    }

    @Override
    public boolean insertBatch(List<OrgPost> list) {
        return this.saveBatch(list);
    }

    @Override
    public List<OrgPost> getByIdsOrCodes(String idsOrCodes) {
        if (BeanUtils.isEmpty((Object)idsOrCodes)) {
            return new ArrayList<OrgPost>();
        }
        List idOrCodeList = Stream.of(idsOrCodes.split(",")).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(OrgPost::getId, idOrCodeList)).or()).in(OrgPost::getCode, idOrCodeList);
        return this.list((Wrapper)wrapper);
    }
}

