/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.OrgRoleDao;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.impl.RoleManagerImpl;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.Role;
import com.hotent.uc.params.orgRole.RoleOrgVo;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class OrgRoleManagerImpl
extends BaseManagerImpl<OrgRoleDao, OrgRole>
implements OrgRoleManager {
    @Resource
    OrgManager orgManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    OrgUserManager orgUserManager;

    @Override
    @Transactional
    public void addOrgRole(String orgId, Role role, int isInherit) throws SQLException {
        OrgRole or = ((OrgRoleDao)this.baseMapper).getByOrgIdAndRoleId(orgId, role.getId());
        if (BeanUtils.isNotEmpty((Object)or)) {
            or.setIsDelete("0");
            or.setIsInherit(isInherit);
            or.setOrgId(orgId);
            or.setRoleName(role.getName());
            or.setRoleId(role.getId());
            this.update((Model)or);
        } else {
            or = new OrgRole();
            or.setId(UniqueIdUtil.getSuid());
            or.setIsInherit(isInherit);
            or.setOrgId(orgId);
            or.setRoleId(role.getId());
            or.setRoleName(role.getName());
            or.setVersion(1);
            this.create((Model)or);
        }
        this.removeUserMenuCacheByOrgId(orgId);
    }

    @Override
    @Transactional
    public void delByOrgIdAndRoleId(String orgId, String roleId) {
        ((OrgRoleDao)this.baseMapper).delByOrgIdAndRoleId(orgId, roleId, LocalDateTime.now());
    }

    @Transactional(readOnly=true)
    public PageList<OrgRole> query(QueryFilter<OrgRole> queryFilter) {
        Map<String, Object> queryFilterParams = this.getInitParams(queryFilter);
        if (BeanUtils.isNotEmpty(queryFilterParams) && queryFilterParams.containsKey("orgId")) {
            String orgId = (String)queryFilterParams.get("orgId");
            OrgManager orgService = (OrgManager)AppUtil.getBean(OrgManager.class);
            Org org = (Org)orgService.get((Serializable)((Object)orgId));
            if (BeanUtils.isNotEmpty((Object)org)) {
                queryFilter.addParams("path", (Object)org.getPath());
            }
        }
        PageBean pageBean = queryFilter.getPageBean();
        IPage<OrgRole> result = ((OrgRoleDao)this.baseMapper).query((IPage<OrgRole>)this.convert2IPage(pageBean), (Wrapper<OrgRole>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public Map<String, Object> getInitParams(QueryFilter queryFilter) {
        List querys = queryFilter.getQuerys();
        LinkedHashMap<String, Object> initParams = new LinkedHashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)querys)) {
            return initParams;
        }
        for (QueryField element : querys) {
            QueryField queryField = element;
            QueryOP operation = queryField.getOperation();
            if (QueryOP.IS_NULL.equals((Object)operation) || QueryOP.NOTNULL.equals((Object)operation) || QueryOP.IN.equals((Object)operation)) continue;
            String property = queryField.getProperty();
            if (property.indexOf(".") > -1) {
                property = property.substring(property.indexOf(".") + 1);
            }
            Object value = queryField.getValue();
            initParams.put(property, value);
        }
        initParams.putAll(queryFilter.getParams());
        return initParams;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgRoleDao)this.baseMapper).removePhysical();
    }

    @Override
    public PageList<Org> getRoleOrgs(String roleId, QueryFilter<Org> queryFilter) {
        IPage<Org> page = ((OrgRoleDao)this.baseMapper).getRoleOrgs((IPage<OrgRole>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<OrgRole>)this.convert2Wrapper(queryFilter, this.currentModelClass()), roleId);
        return new PageList(page);
    }

    @Override
    public void removeRoleOrgs(RoleOrgVo vo) {
        Assert.notEmpty(vo.getOrgIds(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtil.isEmpty((String)vo.getRoleId())) {
            throw new IllegalArgumentException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgRoleManager this_ = (OrgRoleManager)AppUtil.getBean(OrgRoleManager.class);
        for (String orgId : vo.getOrgIds()) {
            this.orgManager.removeUserMenuByOrgId(orgId);
            this_.removeByRoleAndOrg(vo.getRoleId(), orgId);
            this.removeUserMenuCacheByOrgId(orgId);
        }
    }

    private void removeUserMenuCacheByOrgId(String orgId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrgUser::getOrgId, (Object)orgId);
        List orgUsers = this.orgUserManager.list((Wrapper)wrapper);
        RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(RoleManagerImpl.class);
        orgUsers.stream().map(OrgUser::getUserId).forEach(bean::removeUserMenuCacheByUserIde);
    }

    @Override
    @CacheEvict(value={"eip:uc:orgRole"}, key="#orgId")
    public void removeByRoleAndOrg(String roleId, String orgId) {
        ((OrgRoleDao)this.baseMapper).removeRoleOrg(roleId, orgId);
    }

    @Override
    @CacheEvict(value={"eip:uc:orgRole"}, key="#orgId")
    public void removeCacheByOrg(String orgId) {
    }

    @Override
    @CacheEvict(value={"eip:uc:orgRole"}, key="#vo.orgIds[0]")
    public void updateInheritStatus(RoleOrgVo vo) {
        String orgId = vo.getOrgIds().get(0);
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"ORG_ID_", (Object)orgId)).eq((Object)"ROLE_ID_", (Object)vo.getRoleId());
        OrgRole one = (OrgRole)this.getOne((Wrapper)qw);
        if (BeanUtils.isEmpty((Object)one)) {
            throw new BaseException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u89d2\u8272");
        }
        UpdateWrapper uw = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)uw.eq((Object)"ORG_ID_", (Object)orgId)).eq((Object)"ROLE_ID_", (Object)vo.getRoleId())).set((Object)"IS_INHERIT_", (Object)(one.getIsInherit() == 1 ? 0 : 1));
        this.update((Wrapper)uw);
        this.portalFeignService.removeUserMenu();
    }

    @Override
    @Cacheable(value={"eip:uc:orgRole"}, key="#orgId")
    public List<OrgRole> getByOrgId(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ORG_ID_", (Object)orgId);
        List list = this.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            return list;
        }
        return list;
    }
}

