/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CacheEvictUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.RoleDao;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserRole;
import com.hotent.uc.params.role.RoleVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.util.ExcelUtil;

@Service
public class RoleManagerImpl
extends BaseManagerImpl<RoleDao, Role>
implements RoleManager {
    @Autowired
    UserRoleManager userRoleManager;
    @Autowired
    UserManager userService;
    @Autowired
    OrgManager orgService;
    @Autowired
    UserRoleManager userRoleService;
    @Resource
    OrgRoleManager orgRoleManager;
    @Autowired
    DatabaseContext databaseContext;
    @Autowired
    CommonManager commonManager;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public Role getByAlias(String code) {
        return ((RoleDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<Role> getListByUserId(String userId) {
        Set<String> roleIds = this.gatherParentOrgRoles("userId", userId);
        return ((RoleDao)this.baseMapper).getListByUserId(userId, roleIds);
    }

    @Override
    public List<Role> getListByAccount(String account) throws Exception {
        User user = this.userService.getByAccount(account);
        List<Role> roles = ((RoleDao)this.baseMapper).getListByUserId(user.getId(), new HashSet<String>());
        Set<String> roleIds = this.gatherParentOrgRoles("account", account);
        List<Role> orgRoles = ((RoleDao)this.baseMapper).getByIds(roleIds);
        HashSet byAccount = new HashSet();
        roles.parallelStream().forEach(role -> byAccount.add(role.getId()));
        orgRoles.parallelStream().forEach(role -> {
            if (!byAccount.contains(role.getId())) {
                roles.add((Role)role);
            }
        });
        return roles;
    }

    private Set<String> gatherParentOrgRoles(String field, String userCode) {
        List<Org> orgs = null;
        if ("account".equals(field)) {
            try {
                orgs = this.orgService.getOrgListByAccount(userCode);
            }
            catch (Exception e) {
                return new HashSet<String>();
            }
        } else if ("userId".equals(field)) {
            orgs = this.orgService.getOrgListByUserId(userCode);
        }
        if (BeanUtils.isEmpty(orgs)) {
            return new HashSet<String>();
        }
        HashSet<String> roleIds = new HashSet<String>();
        HashSet<String> orgGather = new HashSet<String>();
        for (Org org : orgs) {
            List<String> tempIds;
            if (!orgGather.contains(org.getId())) {
                List<OrgRole> orgRoles = this.orgRoleManager.getByOrgId(org.getId());
                orgRoles.parallelStream().forEach(orgRole -> roleIds.add(orgRole.getRoleId()));
                orgGather.add(org.getId());
            }
            if (StringUtil.isEmpty((String)org.getPath()) || !CollUtil.isNotEmpty(tempIds = Arrays.asList(org.getPath().split("\\.")))) continue;
            for (String tempId : tempIds) {
                if (!StringUtil.isNotEmpty((String)tempId) || tempId.equals(org.getId()) || "0".equals(org.getId()) || orgGather.contains(tempId)) continue;
                List<OrgRole> orgRoles = this.orgRoleManager.getByOrgId(tempId);
                orgRoles.parallelStream().filter(orgRole -> orgRole.getIsInherit() == 1).forEach(orgRole -> roleIds.add(orgRole.getRoleId()));
                orgGather.add(tempId);
            }
        }
        if (roleIds.isEmpty()) {
            return new HashSet<String>();
        }
        return roleIds;
    }

    @Transactional
    public void remove(String roleId) {
        super.remove((Serializable)((Object)roleId));
        this.userRoleManager.removeByRoleId(roleId, LocalDateTime.now());
        this.delUserMenuCache();
    }

    private void delUserMenuCache() {
        RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(this.getClass());
        bean.removeUserMenuCache();
    }

    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    protected void removeUserMenuCache() {
    }

    @Override
    public void delUserMenuCacheByUserId(String userId) {
        RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(this.getClass());
        bean.removeUserMenuCacheByUserIde(userId);
        this.userService.removeUserGroupsCache(userId);
    }

    @CacheEvict(value={"eip:sys:userMenu"}, key="#userId")
    protected void removeUserMenuCacheByUserIde(String userId) {
    }

    @Override
    @Transactional
    public CommonResult<String> addRole(RoleVo roleVo) throws Exception {
        if (StringUtil.isEmpty((String)roleVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)roleVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (((RoleDao)this.baseMapper).getCountByCode(roleVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010" + roleVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        Role role = RoleVo.parse(roleVo);
        role.setUpdateTime(LocalDateTime.now());
        role.setId(UniqueIdUtil.getSuid());
        if (StringUtil.isNotEmpty((String)role.getShowStatus())) {
            role.setShowStatus(roleVo.getShowStatus());
        }
        this.create((Model)role);
        return new CommonResult(true, "\u6dfb\u52a0\u89d2\u8272\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteRole(String codes) throws Exception {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        boolean isTrue = false;
        for (String code : codeArray) {
            Role role = this.getByAlias(code);
            if (BeanUtils.isNotEmpty((Object)role)) {
                if (OrgUtil.checkUserGruopIsUserRel("role", role.getId())) {
                    str.append("\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u89d2\u8272\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                    continue;
                }
                this.remove(role.getId());
                this.portalFeignService.removeByRoleAlias(code);
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        this.delUserMenuCache();
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteRoleByIds(String ids) throws Exception {
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        boolean isTrue = false;
        for (String id : idArray) {
            Role role = (Role)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)role)) {
                this.remove(role.getId());
                this.portalFeignService.removeByRoleAlias(role.getCode());
                this.clearRoleCahceMenu(role.getCode());
                isTrue = true;
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateRole(RoleVo roleVo) throws Exception {
        if (StringUtil.isEmpty((String)roleVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Role role = ((RoleDao)this.baseMapper).getByCode(roleVo.getCode());
        if (BeanUtils.isEmpty((Object)role)) {
            return new CommonResult(false, "\u66f4\u65b0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010" + roleVo.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)roleVo.getName())) {
            role.setName(roleVo.getName());
        }
        if (roleVo.getDescription() != null) {
            role.setDescription(roleVo.getDescription());
        }
        if (roleVo.getEnabled() != null) {
            if (!roleVo.getEnabled().equals(role.getEnabled())) {
                this.clearRoleCahceMenu(role.getCode());
            }
            role.setEnabled(roleVo.getEnabled());
        }
        if (StringUtil.isNotEmpty((String)roleVo.getShowStatus())) {
            role.setShowStatus(roleVo.getShowStatus());
        }
        this.update((Model)role);
        return new CommonResult(true, "\u66f4\u65b0\u89d2\u8272\u6210\u529f\uff01", (Object)"");
    }

    @Transactional
    private void clearRoleCahceMenu(String roleCode) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("r.CODE_", (Object)roleCode, QueryOP.EQUAL, FieldRelation.AND, "group_code");
        Page list = (Page)this.userService.getRoleUserQuery(filter);
        for (User userRole : list.getRecords()) {
            this.delUserMenuCacheByUserId(userRole.getUserId());
        }
    }

    @Override
    public Role getRole(String code) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return role;
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserRole(String code, String accounts) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] accountArray = accounts.split(",");
        StringBuilder values = new StringBuilder();
        boolean isFirst = true;
        int size = 0;
        String msg = "\u5206\u914d\u7528\u6237\u6210\u529f\uff01";
        for (String account : accountArray) {
            CacheEvictUtil.deleteUserDetailsCache((String)account);
            User user = this.userService.getByAccount(account);
            if (BeanUtils.isNotEmpty((Object)user)) {
                this.addUserRole(user.getUserId(), role.getId());
                ++size;
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(account);
        }
        if (size == 0) {
            msg = "\u672a\u5206\u914d\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < accountArray.length) {
            msg = "\u90e8\u5206\u5206\u914d\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)(StringUtil.isNotEmpty((String)values.toString()) ? "\u8d26\u53f7\uff1a\u3010" + values.toString() + "\u3011\u4e0d\u5b58\u5728\uff01" : ""));
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserRoles(String codes, String account) {
        String[] codeArr;
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + codes + "\u3011\u5fc5\u586b\uff01");
        }
        for (String code : codeArr = codes.split(",")) {
            Role role = ((RoleDao)this.baseMapper).getByCode(code);
            if (BeanUtils.isEmpty((Object)role)) {
                throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            StringBuilder values = new StringBuilder();
            boolean isFirst = true;
            User user = null;
            try {
                user = this.userService.getByAccount(account);
            }
            catch (Exception e) {
                throw new RequiredException("\u8d26\u53f7\u3010" + account + "\u3011\u65e0\u6548\uff01");
            }
            if (BeanUtils.isNotEmpty((Object)user)) {
                this.addUserRole(user.getUserId(), role.getId());
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(account);
        }
        return new CommonResult(true, "\u5206\u914d\u89d2\u8272\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResult<String> addUserRoleByOrg(String code, String orgCodes) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] orgCodesArray = orgCodes.split(",");
        StringBuilder values = new StringBuilder();
        boolean isFirst = true;
        int size = 0;
        String msg = "\u5206\u914d\u7528\u6237\u6210\u529f\uff01";
        for (String orgCode : orgCodesArray) {
            Org org = this.orgService.getByCode(orgCode);
            if (BeanUtils.isNotEmpty((Object)org)) {
                List<User> users = this.userService.getUserListByOrgId(org.getId());
                for (User user : users) {
                    this.addUserRole(user.getUserId(), role.getId());
                }
                ++size;
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(orgCode);
        }
        if (size == 0) {
            msg = "\u672a\u5206\u914d\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < orgCodesArray.length) {
            msg = "\u90e8\u5206\u5206\u914d\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)(StringUtil.isNotEmpty((String)values.toString()) ? "\u7ec4\u7ec7\u7f16\u7801\uff1a\u3010" + values.toString() + "\u3011\u4e0d\u5b58\u5728\uff01" : ""));
    }

    @Override
    @Transactional
    public CommonResult<String> removeUserRole(String code, String accounts) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] accountArray = accounts.split(",");
        int size = 0;
        String msg = "\u79fb\u9664\u7528\u6237\u6210\u529f\uff01";
        for (String account : accountArray) {
            UserRole userRole;
            User user = this.userService.getByAccount(account);
            if (!BeanUtils.isNotEmpty((Object)user) || !BeanUtils.isNotEmpty((Object)(userRole = this.userRoleManager.getByRoleIdUserId(role.getId(), user.getId())))) continue;
            this.userRoleManager.remove((Serializable)((Object)userRole.getId()));
            ++size;
            this.delUserMenuCacheByUserId(userRole.getUserId());
        }
        if (size == 0) {
            msg = "\u672a\u79fb\u9664\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < accountArray.length) {
            msg = "\u90e8\u5206\u79fb\u9664\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)"");
    }

    @Override
    public List<UserVo> getUsersByRoleCode(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<User> list = this.userService.getUsersByRoleCode(Arrays.asList(codes.split(",")));
        return OrgUtil.convertToUserVoList(list);
    }

    @Transactional
    private void addUserRole(String userId, String roleId) {
        if (this.userRoleService.getByRoleIdUserId(roleId, userId) != null) {
            return;
        }
        UserRole userRole = new UserRole();
        userRole.setId(UniqueIdUtil.getSuid());
        userRole.setUserId(userId);
        userRole.setRoleId(roleId);
        this.userRoleService.create((Model)userRole);
        this.delUserMenuCacheByUserId(userRole.getUserId());
    }

    @Override
    public List<Role> getOrgRoleList(Map<String, Object> params) {
        return ((RoleDao)this.baseMapper).getOrgRoleList(params);
    }

    @Override
    @Transactional
    public CommonResult<String> forbiddenRoles(String codes) throws Exception {
        String str = this.forbOrActiveRole(codes, 0);
        String msg = StringUtil.isEmpty((String)str) ? "\u7981\u7528\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u7981\u7528\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(true, msg, (Object)str);
    }

    @Override
    @Transactional
    public CommonResult<String> activateRoles(String codes) throws Exception {
        String str = this.forbOrActiveRole(codes, 1);
        String msg = StringUtil.isEmpty((String)str) ? "\u6fc0\u6d3b\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u6fc0\u6d3b\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(true, msg, (Object)str);
    }

    @Transactional
    private String forbOrActiveRole(String codes, Integer enabled) throws SQLException {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        for (String code : codeArray) {
            Role role = this.getByAlias(code);
            if (BeanUtils.isNotEmpty((Object)role)) {
                role.setEnabled(enabled);
                this.update((Model)role);
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        return str.toString();
    }

    @Override
    public List<Role> getRoleByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    @Transactional
    public Integer removeUserRolePhysical() throws Exception {
        return this.userRoleManager.removePhysical();
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)role)) ? "\u8be5\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public List<Role> getOrgRoleListNotCode(String code) {
        return ((RoleDao)this.baseMapper).getOrgRoleListNotCode(code);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((RoleDao)this.baseMapper).removePhysical();
    }

    @Transactional
    public Boolean importRoleFile(MultipartFile file) {
        List list = ExcelUtil.readExcel(RoleVo.class, (MultipartFile)file);
        ArrayList<RoleVo> roleVoList = new ArrayList<RoleVo>();
        ArrayList<RoleVo> checkList = new ArrayList<RoleVo>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            if (!this.validateAllRole(list)) {
                String message = "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e\u3002";
                throw new BaseException(message);
            }
            for (RoleVo roleVo : list) {
                roleVoList.add(roleVo);
                Role role = ((RoleDao)this.baseMapper).getAllByCode(roleVo.getCode());
                if (!BeanUtils.isNotEmpty((Object)role)) continue;
                checkList.add(roleVo);
            }
            if (checkList.size() > 0) {
                return false;
            }
            for (RoleVo roleVo : roleVoList) {
                Role nrole = RoleVo.parse(roleVo);
                nrole.setId(UniqueIdUtil.getSuid());
                this.create((Model)nrole);
            }
        }
        return true;
    }

    @Override
    public CommonResult<String> importRole(MultipartHttpServletRequest request) throws Exception {
        MultipartFile file = request.getFile("file");
        Boolean isRepeat = this.importRoleFile(file);
        if (!isRepeat.booleanValue()) {
            return new CommonResult(true, "confirmUpload");
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public CommonResult<String> importRoleData(MultipartHttpServletRequest request, String status) throws Exception {
        MultipartFile file = request.getFile("file");
        List list = ExcelUtil.readExcel(RoleVo.class, (MultipartFile)file);
        if (BeanUtils.isNotEmpty((Object)list)) {
            if (!this.validateAllRole(list)) {
                String message = "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e\u3002";
                throw new BaseException(message);
            }
            for (RoleVo roleVo : list) {
                Role role = ((RoleDao)this.baseMapper).getAllByCode(roleVo.getCode());
                Role nrole = RoleVo.parse(roleVo);
                if (BeanUtils.isEmpty((Object)role)) {
                    nrole.setId(UniqueIdUtil.getSuid());
                    this.create((Model)nrole);
                    continue;
                }
                if ("update".equals(status)) {
                    nrole.setId(role.getId());
                    nrole.setIsDelete("0");
                    ((RoleDao)this.baseMapper).updateRole(nrole);
                    continue;
                }
                if (!"recover".equals(status)) continue;
                role.setIsDelete("0");
                ((RoleDao)this.baseMapper).updateRole(role);
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public CommonResult<Role> getRoleByCode(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            return new CommonResult(false, "\u89d2\u8272\u7f16\u7801\u5fc5\u586b\uff01", null);
        }
        Role r = this.getByAlias(code);
        if (BeanUtils.isEmpty((Object)r)) {
            r = (Role)this.get((Serializable)((Object)code));
        }
        if (BeanUtils.isEmpty((Object)r)) {
            return new CommonResult(false, "\u6839\u636e\u8f93\u5165\u7684\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272", null);
        }
        return new CommonResult(true, "", (Object)r);
    }

    @Override
    public List<Role> getRoleByCodes(List<String> codes) {
        return ((RoleDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.in(Role::getCode, (Collection)codes)).or()).in(Role::getId, (Collection)codes);
        })).eq(UcBaseModel::getIsDelete, (Object)Character.valueOf('0')));
    }

    @Override
    public void export(HttpServletResponse response, String ids) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("id", (Object)ids.split(","), QueryOP.IN);
        PageList roles = this.query(filter);
        ArrayList<Map> list = new ArrayList<Map>();
        if (BeanUtils.isNotEmpty((Object)roles.getRows())) {
            for (Role role : roles.getRows()) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)role)));
            }
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("name", "\u89d2\u8272\u540d\u79f0");
        exportMap.put("code", "\u89d2\u8272\u7f16\u7801");
        exportMap.put("enabled", "\u72b6\u6001");
        exportMap.put("description", "\u63cf\u8ff0");
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u89d2\u8272\u5217\u8868", (int)22, exportMap, list);
        ExcelUtil.downloadExcel((Workbook)exportFile, (String)"\u89d2\u8272\u5bfc\u51fa", (HttpServletResponse)response);
    }

    private boolean validateAllRole(List<RoleVo> list) {
        for (RoleVo roleVo : list) {
            if (StringUtil.isEmpty((String)roleVo.getName()) || StringUtil.isEmpty((String)roleVo.getCode()) || BeanUtils.isEmpty((Object)roleVo.getEnabled())) {
                return false;
            }
            if (!roleVo.getName().matches("^[\\s\\S]{1,30}$") || !roleVo.getCode().matches("^[-0-9a-zA-Z_]{1,30}$")) {
                return false;
            }
            if (roleVo.getEnabled() == 0 || roleVo.getEnabled() == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public CommonResult<String> operatingUserRoles(Map<String, Object> map) throws Exception {
        List accounts = (List)map.get("accounts");
        List codes = (List)map.get("codes");
        String type = map.get("type").toString();
        for (String account : accounts) {
            for (String code : codes) {
                Role role = ((RoleDao)this.baseMapper).getByCode(code);
                if (BeanUtils.isEmpty((Object)role)) {
                    throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
                }
                StringBuilder values = new StringBuilder();
                boolean isFirst = true;
                User user = null;
                try {
                    user = this.userService.getByAccount(account);
                }
                catch (Exception e) {
                    throw new RequiredException("\u8d26\u53f7\u3010" + account + "\u3011\u65e0\u6548\uff01");
                }
                if (BeanUtils.isNotEmpty((Object)user)) {
                    this.addUserRole(user.getUserId(), role.getId());
                    continue;
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    values.append("\uff0c");
                }
                values.append(account);
            }
        }
        String msg = "\u89d2\u8272\u8f6c\u79fb\u6210\u529f";
        if ("2".equals(type)) {
            msg = "\u89d2\u8272\u590d\u5236\u6210\u529f";
        } else {
            String account;
            account = map.get("account").toString();
            for (String code : codes) {
                UserRole userRole;
                User user = this.userService.getByAccount(account);
                Role role = ((RoleDao)this.baseMapper).getByCode(code);
                if (!BeanUtils.isNotEmpty((Object)user) || !BeanUtils.isNotEmpty((Object)role) || !BeanUtils.isNotEmpty((Object)(userRole = this.userRoleManager.getByRoleIdUserId(role.getId(), user.getId())))) continue;
                this.userRoleManager.remove((Serializable)((Object)userRole.getId()));
                this.delUserMenuCacheByUserId(userRole.getUserId());
            }
        }
        return new CommonResult(true, msg);
    }

    @Override
    public CommonResult<String> restoreByAlias(String alias) {
        String sql = String.format("update uc_role set IS_DELE_ ='0'  where code_  = '%s' ", alias);
        int execute = this.commonManager.execute(sql);
        if (execute == 0) {
            return CommonResult.error((String)"\u6062\u590d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u89d2\u8272\u522b\u540d\u662f\u5426\u5b58\u5728");
        }
        Role role = this.getByAlias(alias);
        LambdaUpdateWrapper userRoleWrapper = Wrappers.lambdaUpdate();
        userRoleWrapper.eq(UserRole::getRoleId, (Object)role.getId());
        userRoleWrapper.set(UcBaseModel::getIsDelete, (Object)"0");
        this.userRoleManager.update((Wrapper)userRoleWrapper);
        return CommonResult.ok();
    }

    @Override
    public List<Role> getByIdsOrCodes(String idsOrCodes) {
        if (BeanUtils.isEmpty((Object)idsOrCodes)) {
            return new ArrayList<Role>();
        }
        List idOrCodeList = Stream.of(idsOrCodes.split(",")).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Role::getId, idOrCodeList)).or()).in(Role::getCode, idOrCodeList);
        return this.list((Wrapper)wrapper);
    }
}

