/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.UcGroupUserDao;
import com.hotent.uc.dto.UserSeletorDto;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.UcGroupManager;
import com.hotent.uc.manager.UcGroupUserManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.UcGroupUser;
import com.hotent.uc.util.ContextUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UcGroupUserManagerImpl
extends BaseManagerImpl<UcGroupUserDao, UcGroupUser>
implements UcGroupUserManager {
    @Resource
    DemensionManager demensionManager;
    @Autowired
    UcGroupManager ucGroupManager;
    @Autowired
    UserManager userManager;
    @Resource
    OrgPostManager orgPostManager;
    @Resource
    OrgManager orgManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveJson(Map<String, Object> map) {
        String groupId = map.get("groupId").toString();
        List ids = (List)map.get("ids");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"GROUP_ID_", (Object)groupId);
        wrapper.in((Object)"USER_ID", (Collection)ids);
        this.remove((Wrapper)wrapper);
        wrapper.clear();
        wrapper.eq((Object)"GROUP_ID_", (Object)groupId);
        List groups = this.list((Wrapper)wrapper);
        Integer maxIndex = 0;
        for (UcGroupUser group : groups) {
            if (group.getSn() < maxIndex) continue;
            maxIndex = group.getSn() + 1;
        }
        ArrayList<UcGroupUser> list = new ArrayList<UcGroupUser>();
        for (Object id : ids) {
            UcGroupUser ucGroupUser = new UcGroupUser();
            Integer n = maxIndex;
            Integer n2 = maxIndex = Integer.valueOf(maxIndex + 1);
            ucGroupUser.setSn(n);
            ucGroupUser.setGroupId(groupId);
            ucGroupUser.setUserId(id.toString());
            list.add(ucGroupUser);
        }
        this.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void swap(String s1, String s2) {
        UcGroupUser u1 = (UcGroupUser)((Object)this.getById((Serializable)((Object)s1)));
        UcGroupUser u2 = (UcGroupUser)((Object)this.getById((Serializable)((Object)s2)));
        if (BeanUtils.isEmpty((Object)((Object)u1)) || BeanUtils.isEmpty((Object)((Object)u2))) {
            throw new BaseException("\u987a\u5e8f\u4ea4\u6362\u5931\u8d25\uff0c\u8bb0\u5f55\u4e3a\u7a7a");
        }
        Integer t1 = u1.getSn();
        u1.setSn(u2.getSn());
        u2.setSn(t1);
        UcGroupUser[] ucGroupUsers = new UcGroupUser[]{u1, u2};
        this.updateBatchById(Arrays.asList(ucGroupUsers));
    }

    @Override
    public PageList<UserSeletorDto> loadUserByGroupId(String groupIds, String demId, Boolean isMobile, QueryFilter queryFilter) throws Exception {
        Class<?> aClass = Class.forName("com.hotent.uc.model.User");
        for (Object query : queryFilter.getQuerys()) {
            TableField annotation;
            Field field;
            QueryField queryField = (QueryField)query;
            if (queryField.getProperty().equals("uu.ID_") || (field = aClass.getDeclaredField(queryField.getProperty())) == null || null == (annotation = field.getAnnotation(TableField.class))) continue;
            queryField.setProperty(annotation.value());
        }
        ArrayList groupIdList = new ArrayList();
        if (StringUtil.isNotEmpty((String)groupIds)) {
            groupIdList = Lists.newArrayList((Object[])groupIds.split(","));
        }
        if (StringUtil.isEmpty((String)demId)) {
            demId = this.demensionManager.getDefaultDemension().getId();
        }
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addParams("userId", (Object)userId);
        int userGroupCount = groupIdList.size();
        if (BeanUtils.isEmpty((Object)groupIdList)) {
            userGroupCount = this.ucGroupManager.count((Wrapper)new LambdaQueryWrapper().eq(AutoFillModel::getCreateBy, (Object)userId));
        }
        queryFilter.addParams("userGroupCount", (Object)userGroupCount);
        IPage<UserSeletorDto> page = ((UcGroupUserDao)this.baseMapper).loadUserByGroupId((IPage<UcGroupUser>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<UcGroupUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()), groupIdList, demId);
        List records = page.getRecords();
        if (BeanUtils.isNotEmpty((Object)records)) {
            List orgList;
            List orgIds;
            List orgPosts;
            Map<Object, Object> orgPostMap = new HashMap();
            Map<Object, Object> orgMap = new HashMap();
            List postIds = records.stream().map(UserSeletorDto::getPostid).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(postIds) && BeanUtils.isNotEmpty((Object)(orgPosts = this.orgPostManager.listByIds(postIds)))) {
                orgPostMap = orgPosts.stream().collect(Collectors.toMap(OrgPost::getId, OrgPost::getName));
            }
            if (BeanUtils.isNotEmpty(orgIds = records.stream().map(UserSeletorDto::getOrgid).collect(Collectors.toList())) && BeanUtils.isNotEmpty((Object)(orgList = this.orgManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Org::getId, orgIds)).eq(Org::getDemId, (Object)demId))))) {
                orgMap = orgList.stream().collect(Collectors.toMap(Org::getId, org -> org));
            }
            for (UserSeletorDto record : records) {
                if (orgPostMap.containsKey(record.getPostid())) {
                    record.setPostname((String)orgPostMap.get(record.getPostid()));
                }
                if (!orgMap.containsKey(record.getOrgid())) continue;
                Org org2 = (Org)orgMap.get(record.getOrgid());
                record.setOrgname(org2.getName());
                record.setPathname(org2.getPathName());
                record.setDemoid(org2.getDemId());
            }
        }
        PageList result = new PageList(page);
        this.userManager.handleUserMainOrgAndPost(result.getRows());
        if (isMobile.booleanValue() && BeanUtils.isNotEmpty((Object)page.getRecords())) {
            this.userManager.handleUserOrgPathsList((PageList<UserSeletorDto>)result);
        }
        return result;
    }
}

