/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.UcOrgUniteDao;
import com.hotent.uc.manager.UcOrgUniteManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.UcOrgUnite;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UcOrgUniteManagerImpl
extends BaseManagerImpl<UcOrgUniteDao, UcOrgUnite>
implements UcOrgUniteManager {
    @Override
    public UcOrgUnite getDetail(String id) {
        UcOrgUnite ucOrgUnite = (UcOrgUnite)this.get((Serializable)((Object)id));
        return ucOrgUnite;
    }

    @Override
    @Transactional
    public void createOrUpdate(UcOrgUnite ucOrgUnite) {
        this.saveOrUpdate((Object)ucOrgUnite);
    }

    @Override
    public void updateOrgUnite(UcOrgUnite ucOrgUnite) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"ORG_ID_", (Object)ucOrgUnite.getOrgId());
        UcOrgUnite exist = (UcOrgUnite)((Object)this.getOne((Wrapper)queryWrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)exist))) {
            if (StringUtil.isNotEmpty((String)ucOrgUnite.getWxWorkId())) {
                exist.setWxWorkId(ucOrgUnite.getWxWorkId());
            }
            if (StringUtil.isNotEmpty((String)ucOrgUnite.getDingtalkId())) {
                exist.setDingtalkId(ucOrgUnite.getDingtalkId());
            }
            if (StringUtil.isNotEmpty((String)ucOrgUnite.getFlybookId())) {
                exist.setFlybookId(ucOrgUnite.getFlybookId());
            }
            this.update((Model)exist);
        } else {
            this.create((Model)ucOrgUnite);
        }
    }

    @Override
    public String getOrgParentId(Org orgVo) {
        if (StringUtils.isEmpty((CharSequence)orgVo.getParentId()) || Objects.equals("1", orgVo.getParentId())) {
            return "0";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)orgVo.getWxWorkId())) {
            queryWrapper.eq((Object)"WX_WORK_ID_", (Object)orgVo.getParentId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getDingtalkId())) {
            queryWrapper.eq((Object)"DINGTALK_ID_", (Object)orgVo.getParentId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getFlybookId())) {
            queryWrapper.eq((Object)"FLYBOOK_ID_", (Object)orgVo.getParentId());
        }
        UcOrgUnite unite = (UcOrgUnite)((Object)this.getOne((Wrapper)queryWrapper));
        String orgId = orgVo.getParentId();
        if (unite != null && StringUtil.isNotEmpty((String)unite.getOrgId())) {
            orgId = unite.getOrgId();
        }
        return orgId;
    }

    @Override
    public String getOrgId(String deptId, String type) {
        if (StringUtils.isEmpty((CharSequence)deptId) || Objects.equals("1", deptId) || Objects.equals("0", deptId)) {
            return "0";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if ("weChatWork".equals(type)) {
            queryWrapper.eq((Object)"WX_WORK_ID_", (Object)deptId);
        } else if ("dingtalk".equals(type)) {
            queryWrapper.eq((Object)"DINGTALK_ID_", (Object)deptId);
        } else if ("flyBook".equals(type)) {
            queryWrapper.eq((Object)"FLYBOOK_ID_", (Object)deptId);
        }
        UcOrgUnite unite = (UcOrgUnite)((Object)this.getOne((Wrapper)queryWrapper));
        String orgId = deptId;
        if (unite != null && StringUtil.isNotEmpty((String)unite.getOrgId())) {
            orgId = unite.getOrgId();
        }
        return orgId;
    }

    @Override
    public boolean exist(Org orgVo) {
        int count;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)orgVo.getWxWorkId())) {
            queryWrapper.eq((Object)"WX_WORK_ID_", (Object)orgVo.getId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getDingtalkId())) {
            queryWrapper.eq((Object)"DINGTALK_ID_", (Object)orgVo.getId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getFlybookId())) {
            queryWrapper.eq((Object)"FLYBOOK_ID_", (Object)orgVo.getId());
        }
        return (count = this.count((Wrapper)queryWrapper)) > 0;
    }

    @Override
    public boolean delByOrgId(String orgId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery().eq(UcOrgUnite::getOrgId, (Object)orgId));
    }
}

