/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.params.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.User;
import com.hotent.uc.util.OperateLogUtil;
import com.hotent.uc.util.UpdateCompare;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import javax.validation.constraints.Email;

@ApiModel
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserVo
implements UpdateCompare {
    @ApiModelProperty(name="id", notes="\u7528\u6237id")
    private String id;
    @ApiModelProperty(name="account", notes="\u767b\u5f55\u5e10\u53f7\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", required=true)
    private String account;
    @ApiModelProperty(name="fullname", notes="\u7528\u6237\u540d", required=true)
    private String fullname;
    @ApiModelProperty(name="userNumber", notes="\u5de5\u53f7", required=true)
    private String userNumber;
    @ApiModelProperty(name="password", notes="\u767b\u5f55\u5bc6\u7801\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", required=true)
    private String password;
    @ApiModelProperty(name="email", notes="\u90ae\u7bb1\u5730\u5740")
    @Email(message="{valid.com.hotent.Email} {valid.com.hotent.Email.message}")
    private @Email(message="{valid.com.hotent.Email} {valid.com.hotent.Email.message}") String email;
    @ApiModelProperty(name="mobile", notes="\u624b\u673a\u53f7\u7801")
    private String mobile;
    @ApiModelProperty(name="weixin", notes="\u5fae\u4fe1")
    private String weixin;
    @ApiModelProperty(name="address", notes="\u5730\u5740")
    private String address;
    @ApiModelProperty(name="sex", notes="\u6027\u522b", allowableValues="\u7537,\u5973,\u672a\u77e5")
    private String sex;
    @ApiModelProperty(name="photo", notes="\u5934\u50cf\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", allowableValues="\u7528\u6237\u7684\u5934\u50cf")
    protected String photo;
    @ApiModelProperty(name="status", notes="\u72b6\u6001 1\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528\uff1b-1\uff1a\u5f85\u6fc0\u6d3b\uff1b-2\uff1a\u79bb\u804c\uff08\u9ed8\u8ba4\u4e3a\u6b63\u5e38\uff09")
    private Integer status;
    @ApiModelProperty(name="idCard", notes="\u8eab\u4efd\u8bc1\u53f7")
    private String idCard;
    @ApiModelProperty(name="phone", notes="\u529e\u516c\u7535\u8bdd")
    private String phone;
    @ApiModelProperty(name="birthday", notes="\u751f\u65e5")
    private String birthday;
    @ApiModelProperty(name="entryDate", notes="\u5165\u804c\u65e5\u671f")
    private String entryDate;
    @ApiModelProperty(name="leaveDate", notes="\u79bb\u804c\u65e5\u671f")
    private LocalDate leaveDate;
    @ApiModelProperty(name="education", notes="\u5b66\u5386")
    private String education;
    @ApiModelProperty(name="updateTime", notes="\u66f4\u65b0\u65f6\u95f4")
    private LocalDateTime updateTime;
    @ApiModelProperty(name="isDelete", notes="\u662f\u5426\u5df2\u5220\u9664 1\u5df2\u5220\u9664 0\u672a\u5220\u9664\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09")
    private String isDelete;
    @ApiModelProperty(name="version", notes="\u7248\u672c\u53f7\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09")
    private Integer version;
    @ApiModelProperty(name="from", notes="\u6765\u6e90")
    private String from;
    @ApiModelProperty(name="params", notes="\u7528\u6237\u53c2\u6570\uff08\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u65f6\u624d\u4f1a\u6709\u503c\uff09")
    private Map<String, Object> params;
    @ApiModelProperty(name="tenantId", notes="\u79df\u6237id")
    protected String tenantId;
    @ApiModelProperty(name="clientId", notes="\u63a8\u9001\u670d\u52a1\u4ee4\u724c\uff08\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\uff09")
    protected String clientId;
    @ApiModelProperty(name="clientToken", notes="\u8bbe\u5907\u4ee4\u724c\uff08iOS\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\uff09")
    protected String clientToken;
    @ApiModelProperty(name="showStatus", notes="\u663e\u793a\u72b6\u6001")
    protected String showStatus;
    @ApiModelProperty(name="orgId", notes="\u7ec4\u7ec7id")
    protected String orgId;
    @ApiModelProperty(name="expireDate", notes="\u767b\u5f55\u6709\u6548\u65e5\u671f")
    protected LocalDate expireDate;

    public UserVo(User user) {
        this.id = user.getId();
        this.account = user.getAccount();
        this.fullname = user.getFullname();
        this.userNumber = user.getUserNumber();
        this.email = user.getEmail() == null ? "" : user.getEmail();
        this.mobile = user.getMobile() == null ? "" : user.getMobile();
        this.address = user.getAddress() == null ? "" : user.getAddress();
        this.sex = user.getSex() == null ? "" : user.getSex();
        this.photo = user.getPhoto() == null ? "" : user.getPhoto();
        this.status = user.getStatus();
        this.idCard = user.getIdCard() == null ? "" : user.getIdCard();
        this.phone = user.getPhone() == null ? "" : user.getPhone();
        this.birthday = BeanUtils.isNotEmpty((Object)user.getBirthday()) ? DateFormatUtil.format((LocalDateTime)user.getBirthday().atStartOfDay(), (String)"yyyy-MM-dd") : "";
        this.entryDate = BeanUtils.isNotEmpty((Object)user.getEntryDate()) ? DateFormatUtil.format((LocalDateTime)user.getEntryDate().atStartOfDay(), (String)"yyyy-MM-dd") : "";
        this.leaveDate = user.getLeaveDate();
        this.education = user.getEducation() == null ? "" : user.getEducation();
        this.updateTime = user.getUpdateTime();
        this.isDelete = user.getIsDelete();
        this.version = user.getVersion() == null ? 1 : user.getVersion();
        this.from = user.getFrom();
        this.tenantId = user.getTenantId();
        this.clientId = user.getClientId();
        this.clientToken = user.getClientToken();
        this.expireDate = user.getExpireDate();
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPhoto() {
        return this.photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public LocalDate getLeaveDate() {
        return this.leaveDate;
    }

    public void setLeaveDate(LocalDate leaveDate) {
        this.leaveDate = leaveDate;
    }

    public String getEducation() {
        return this.education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getIsDelete() {
        return this.isDelete;
    }

    public void setIsDelete(String isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(String showStatus) {
        this.showStatus = showStatus;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String toString() {
        return "{\"account\":\"" + this.account + "\",\"fullname\":\"" + this.fullname + "\",\"userNumber\":\"" + this.userNumber + "\",\"password\":\"" + this.password + "\",\"email\":\"" + this.email + "\",\"mobile\":\"" + this.mobile + "\",\"address\":\"" + this.address + "\",\"sex\":\"" + this.sex + "\",\"status\":\"" + this.status + "\",\"idCard\":\"" + this.idCard + "\",\"phone\":\"" + this.phone + "\",\"birthday\":\"" + this.birthday + "\",\"entryDate\":\"" + this.entryDate + "\",\"leaveDate\":\"" + this.leaveDate + "\",\"education\":\"" + this.education + "\"\"updateTime\":\"" + this.updateTime + "\"\"isDelete\":\"" + this.isDelete + "\"\"version\":\"" + this.version + "\"\"from\":\"" + this.from + "\"}";
    }

    public UserVo() {
    }

    @Override
    public String compare() throws Exception {
        UserManager service = (UserManager)AppUtil.getBean(UserManager.class);
        User oldVo = service.getByAccount(this.account);
        UserVo newVo = this;
        newVo.setVersion(null);
        newVo.setParams(null);
        return OperateLogUtil.compare(newVo, UserVo.changeVo(oldVo));
    }

    public static UserVo changeVo(User oldVo) {
        UserVo newVo = new UserVo();
        if (BeanUtils.isEmpty((Object)oldVo)) {
            return newVo;
        }
        newVo.setAccount(oldVo.getAccount());
        newVo.setAddress(oldVo.getAddress());
        newVo.setBirthday(DateFormatUtil.format((LocalDateTime)oldVo.getBirthday().atStartOfDay(), (String)"yyyy-MM-dd"));
        newVo.setEducation(oldVo.getEducation());
        newVo.setEmail(oldVo.getEmail());
        newVo.setEntryDate(DateFormatUtil.format((LocalDateTime)oldVo.getEntryDate().atStartOfDay(), (String)"yyyy-MM-dd"));
        newVo.setLeaveDate(oldVo.getLeaveDate());
        newVo.setFrom(oldVo.getFrom());
        newVo.setFullname(oldVo.getFullname());
        newVo.setIdCard(oldVo.getIdCard());
        newVo.setIsDelete(oldVo.getIsDelete());
        newVo.setMobile(oldVo.getMobile());
        newVo.setPhone(oldVo.getPhone());
        newVo.setPhoto(oldVo.getPhoto());
        newVo.setSex(oldVo.getSex());
        newVo.setStatus(oldVo.getStatus());
        newVo.setUpdateTime(oldVo.getUpdateTime());
        newVo.setUserNumber(oldVo.getUserNumber());
        newVo.setTenantId(oldVo.getTenantId());
        newVo.setShowStatus(oldVo.getShowStatus());
        return newVo;
    }
}

