/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.matrix.impl;

import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlBuilder;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.SQLUtil;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.service.matrix.MatrixDataService;
import com.hotent.uc.service.matrix.impl.AbstractMatrixDataServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class UserMatrixDataServiceImpl
extends AbstractMatrixDataServiceImpl
implements MatrixDataService {
    public UserMatrixDataServiceImpl(CommonManager commonManager) {
        super(commonManager);
        this.idColumn = "ucUserId";
        this.nameColumn = "ucUsername";
        this.codeColumn = "ucAccount";
        this.nameDbColumn = "uc_user.fullname_";
        this.ctrlType = "user";
    }

    @Override
    public String generateSql(String matrixCode, List<MatrixColField> colFields) {
        Optional<MatrixColField> first = this.getSuitableColField(colFields);
        String codeField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondkFieldName).orElse(this.codeColumn);
        String nameField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondvFieldName).orElse(this.nameColumn);
        ArrayList<String> fields = new ArrayList<String>();
        if ("gbase-8s".equals(SQLUtil.getDbType())) {
            fields.add(String.format("uc_user.account_ as %s", codeField));
            fields.add(String.format(this.nameDbColumn + " as %s", nameField));
        } else {
            fields.add(String.format("uc_user.account_ \"%s\"", codeField));
            fields.add(String.format(this.nameDbColumn + " \"%s\"", nameField));
        }
        for (MatrixColField field : colFields) {
            if (codeField.equals(field.getField()) || nameField.equals(field.getField())) continue;
            if ("ro".equals(field.getFtype()) && "oracle".equals(SQLUtil.getDbType())) {
                fields.add(String.format("DBMS_LOB.SUBSTR(%s.%s, 4000, 1) \"%s\"", "uc_matrix", field.getField(), field.getField()));
                continue;
            }
            if ("ro".equals(field.getFtype()) && "dm".equals(SQLUtil.getDbType())) {
                fields.add(String.format("CAST(%s.%s AS VARCHAR(4000)) \"%s\"", "uc_matrix", field.getField(), field.getField()));
                continue;
            }
            if ("gbase-8s".equals(SQLUtil.getDbType())) {
                fields.add(String.format("%s.%s as %s", "uc_matrix", field.getField(), field.getField()));
                continue;
            }
            fields.add(String.format("%s.%s \"%s\"", "uc_matrix", field.getField(), field.getField()));
        }
        String fieldAll = "uc_matrix." + first.map(MatrixColField::getField).orElse("code_");
        Condition condition = first.isPresent() && "ck".equals(first.get().getFtype()) && "dm".equals(SQLUtil.getDbType()) ? this.getJoinCondition("uc_user.account_", String.format("CAST(%s AS VARCHAR(4000))", fieldAll)) : this.getJoinCondition("uc_user.account_", fieldAll);
        SqlBuilder sqlBuilder = SqlBuilder.create().select(true, fields).from(new String[]{"uc_user uc_user"}).join("UC_MATRIX_" + matrixCode + " " + "uc_matrix", SqlBuilder.Join.LEFT).on(new Condition[]{condition}).join("uc_org_user uou", SqlBuilder.Join.LEFT).on(new Condition[]{this.getJoinCondition("uc_user.id_", "uou.user_id_")}).join("uc_org uo", SqlBuilder.Join.LEFT).on(new Condition[]{this.getJoinCondition("uou.org_id_", "uo.id_")}).join("uc_user_role ur", SqlBuilder.Join.LEFT).on(new Condition[]{this.getJoinCondition("uc_user.id_", "ur.user_id_")});
        return sqlBuilder.toString();
    }

    @Override
    public void addQueryFilter(QueryFilter<?> queryFilter) {
        queryFilter.addFilter("uc_user.status_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("uc_user.is_dele_", (Object)0, QueryOP.EQUAL);
    }

    private Condition getJoinCondition(String field, String value) {
        Condition condition = new Condition(field, (Object)value);
        condition.setPlaceHolder(false);
        return condition;
    }
}

