/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.util;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkQueue {
    private final int nThreads;
    private final PoolWorker[] threads;
    LinkedList<Runnable> queue;

    public WorkQueue(int nThreads) {
        this.nThreads = nThreads;
        this.queue = new LinkedList();
        this.threads = new PoolWorker[nThreads];
        for (int i = 0; i < this.nThreads; ++i) {
            this.threads[i] = new PoolWorker();
            this.threads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable r) {
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(r);
            this.queue.notify();
        }
    }

    private class PoolWorker
    extends Thread {
        private Logger logger = LoggerFactory.getLogger(PoolWorker.class);

        private PoolWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable r;
                LinkedList<Runnable> linkedList = WorkQueue.this.queue;
                synchronized (linkedList) {
                    while (WorkQueue.this.queue.isEmpty()) {
                        try {
                            WorkQueue.this.queue.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            this.logger.error(e.getMessage());
                        }
                    }
                    r = WorkQueue.this.queue.removeFirst();
                }
                try {
                    r.run();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error(e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

