/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uds.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.uds.dao.UcBatchSyncDao;
import com.hotent.uds.manager.UcBatchSyncManager;
import com.hotent.uds.model.UcBatchSync;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UcBatchSyncManagerImpl
extends BaseManagerImpl<UcBatchSyncDao, UcBatchSync>
implements UcBatchSyncManager {
    @Resource
    protected IdGenerator idGenerator;

    @Override
    public UcBatchSync getDetail(String id) {
        UcBatchSync ucBatchSync = (UcBatchSync)this.get((Serializable)((Object)id));
        return ucBatchSync;
    }

    @Override
    @Transactional
    public void createOrUpdate(UcBatchSync ucBatchSync) {
        this.saveOrUpdate((Object)ucBatchSync);
    }

    @Override
    public UcBatchSync createByXid() {
        LocalDateTime lastExecuteTime = null;
        UcBatchSync lastSync = ((UcBatchSyncDao)this.baseMapper).selectLast();
        if (lastSync != null) {
            lastExecuteTime = lastSync.getExecuteTime();
        }
        UcBatchSync ucBatchSync = new UcBatchSync();
        ucBatchSync.setId(this.idGenerator.getSuid());
        ucBatchSync.setExecuteTime(LocalDateTime.now());
        ucBatchSync.setLastExecuteTime(lastExecuteTime);
        this.create((Model)ucBatchSync);
        return ucBatchSync;
    }

    @Override
    public Boolean removeByDays(Integer days) {
        LocalDateTime time = LocalDateTime.now().minusDays(days.intValue());
        return this.remove((Wrapper)Wrappers.lambdaQuery().le(UcBatchSync::getExecuteTime, (Object)time));
    }
}

