/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.context;

import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.model.TenantManage;
import com.hotent.uc.model.User;
import com.hotent.uc.util.ContextUtil;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Primary
public class UcContext
implements BaseContext,
ContextThread {
    private ThreadLocal<String> tempTenantId = new ThreadLocal();

    public void setTempTenantId(String tenantId) {
        this.tempTenantId.set(tenantId);
    }

    public void clearTempTenantId() {
        this.tempTenantId.remove();
    }

    public boolean hasTempTenant() {
        return BeanUtils.isNotEmpty((Object)this.tempTenantId.get());
    }

    public String getCurrentUserId() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUserId();
    }

    public String getCurrentUserAccout() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUser().getAccount();
    }

    public String getCurrentUserFullname() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUser().getFullname();
    }

    public String getCurrentOrgId() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentGroupId();
    }

    public String getCurrentTenantId() {
        String tempTenantId = this.tempTenantId.get();
        if (StringUtil.isNotEmpty((String)tempTenantId)) {
            return tempTenantId;
        }
        String tenantId = HttpUtil.getTenantId();
        if (BeanUtils.isNotEmpty((Object)tenantId)) {
            return tenantId;
        }
        if (this.authenticationEmpty()) {
            return "-1";
        }
        User currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            String tenantCode = HttpUtil.getRequest().getHeader("Tenant-Code");
            TenantManageManager tenantManageManager = (TenantManageManager)AppUtil.getBean(TenantManageManager.class);
            TenantManage tenantManage = tenantManageManager.getByCode(tenantCode);
            if (BeanUtils.isNotEmpty((Object)((Object)tenantManage))) {
                String status = tenantManage.getStatus();
                if ("draft".equals(status)) {
                    throw new BaseException("\u8349\u7a3f\u72b6\u6001\u7684\u79df\u6237\u4e0d\u5141\u8bb8\u767b\u5f55");
                }
                return tenantManage.getId();
            }
            return "-1";
        }
        return ContextUtil.getCurrentUser().getTenantId();
    }

    private boolean authenticationEmpty() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return BeanUtils.isEmpty((Object)authentication) || authentication instanceof AnonymousAuthenticationToken;
    }

    public void cleanAll() {
        this.clearTempTenantId();
    }
}

