/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.JsonUtil;
import com.hotent.uc.manager.CasPageConfigManager;
import com.hotent.uc.model.CasPageConfig;
import fr.opensagres.xdocreport.document.json.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/casPageConfig/v1/"})
@Api(tags={"CAS\u9875\u9762\u914d\u7f6e"})
@ApiGroup(group={"group_uc"})
public class CasPageConfigController
extends BaseController<CasPageConfigManager, CasPageConfig> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String IMG_BACKGROUND = "background";
    public static final String IMG_LOGO = "logo";

    @GetMapping(value={"{type}/url"})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u56fe\u7247", httpMethod="GET", notes="\u83b7\u53d6\u914d\u7f6e\u56fe\u7247")
    public void getUserPage(@PathVariable(value="type") String type, @RequestParam(value="id", required=false) String id, @RequestParam(value="download", defaultValue="false") Boolean download, HttpServletResponse response) throws Exception {
        if (StringUtils.equalsIgnoreCase((String)type, (String)IMG_BACKGROUND)) {
            ((CasPageConfigManager)this.baseService).getBackgroundImg(id, download, response);
        } else if (StringUtils.equalsIgnoreCase((String)type, (String)IMG_LOGO)) {
            ((CasPageConfigManager)this.baseService).getLogoImg(id, download, response);
        } else {
            return;
        }
    }

    @PostMapping(value={"create"})
    @ApiOperation(value="\u4fdd\u5b58CAS\u9875\u9762\u914d\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58CAS\u9875\u9762\u914d\u7f6e")
    public CommonResult<CasPageConfig> saveCasPageConfig(@RequestBody JSONObject params) {
        try {
            String endDate;
            String startDate;
            String string = startDate = params.containsKey((Object)"startDate") ? params.getString("startDate") : "";
            if (StringUtils.isNotBlank((String)startDate) && StringUtils.length((String)startDate) == 10) {
                params.put("startDate", (Object)(startDate + " 00:00:00"));
            }
            String string2 = endDate = params.containsKey((Object)"endDate") ? params.getString("endDate") : "";
            if (StringUtils.isNotBlank((String)endDate) && StringUtils.length((String)endDate) == 10) {
                params.put("endDate", (Object)(endDate + " 23:59:59"));
            }
            CasPageConfig casPageConfig = (CasPageConfig)((Object)JsonUtil.toBean((String)params.toString(), CasPageConfig.class));
            ((CasPageConfigManager)this.baseService).saveOrUpdate((Object)casPageConfig);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)casPageConfig);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25,Error: " + e.getMessage());
        }
    }

    @PostMapping(value={"upload"})
    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247", httpMethod="POST", notes="\u4e0a\u4f20\u56fe\u7247")
    public CommonResult<CasPageConfig> upload(@RequestPart(value="file") MultipartFile file, @RequestParam(value="type") String type, @RequestParam(value="id", required=false) String id, @RequestParam(value="alias", required=false) String alias, @RequestParam(value="headerTitle", required=false) String headerTitle, @RequestParam(value="footerText", required=false) String footerText, @RequestParam(value="enabled", required=false) String enabled, @RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) {
        try {
            CasPageConfig casPageConfig = new CasPageConfig();
            casPageConfig.setId(id);
            casPageConfig.setAlias(alias);
            casPageConfig.setHeaderTitle(headerTitle);
            casPageConfig.setFooterText(footerText);
            casPageConfig.setEnabled(enabled);
            if (StringUtils.isNotBlank((String)startDate) && StringUtils.length((String)startDate) == 10) {
                startDate = startDate + " 00:00:00";
            }
            LocalDateTime startDateTime = LocalDateTime.parse(startDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            casPageConfig.setStartDate(startDateTime);
            if (StringUtils.isNotBlank((String)endDate) && StringUtils.length((String)endDate) == 10) {
                endDate = endDate + " 23:59:59";
            }
            LocalDateTime endDateTime = LocalDateTime.parse(endDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            casPageConfig.setEndDate(endDateTime);
            casPageConfig = ((CasPageConfigManager)this.baseService).upload(casPageConfig, type, file);
            return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)casPageConfig);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u4e0a\u4f20\u5931\u8d25,Error: " + e.getMessage());
        }
    }

    @PostMapping(value={"removeFile"})
    @ApiOperation(value="\u5220\u9664\u56fe\u7247", httpMethod="POST", notes="\u5220\u9664\u56fe\u7247")
    public CommonResult<CasPageConfig> removeFile(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        try {
            ((CasPageConfigManager)this.baseService).removeFile(id, type);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25,Error: " + e.getMessage());
        }
    }
}

